/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.js;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.dynjs.parser.ast.ProgramTree;
import org.dynjs.parser.js.ASTFactory;
import org.dynjs.parser.js.CharStream;
import org.dynjs.parser.js.CircularCharBuffer;
import org.dynjs.parser.js.Lexer;
import org.dynjs.parser.js.Parser;
import org.dynjs.parser.js.ParserException;
import org.dynjs.parser.js.TokenQueue;
import org.dynjs.runtime.ExecutionContext;

public class JavascriptParser {
    private ExecutionContext context;
    private ASTFactory factory;

    public JavascriptParser(ExecutionContext context) {
        this(context, new ASTFactory());
    }

    public JavascriptParser(ExecutionContext context, ASTFactory factory) {
        this.context = context;
        this.factory = factory;
    }

    public ProgramTree parse(File file) throws IOException {
        return this.parse(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramTree parse(File file, boolean forceStrict) throws IOException {
        try (FileReader reader = new FileReader(file);){
            ProgramTree programTree = this.parse(reader, file.getName(), forceStrict);
            return programTree;
        }
    }

    public ProgramTree parse(String source) {
        return this.parse(source, null);
    }

    public ProgramTree parse(String source, String fileName) {
        return this.parse(source, fileName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramTree parse(String source, String fileName, boolean forceStrict) {
        try (StringReader reader = new StringReader(source);){
            ProgramTree programTree = this.parse(reader, fileName, forceStrict);
            return programTree;
        }
    }

    public ProgramTree parse(Reader source) {
        return this.parse(source, false);
    }

    public ProgramTree parse(Reader source, boolean forceStrict) {
        return this.parse(source, null, forceStrict);
    }

    public ProgramTree parse(Reader source, String fileName) {
        return this.parse(source, fileName, false);
    }

    public ProgramTree parse(Reader source, String fileName, boolean forceStrict) {
        try {
            return this.parse(new CircularCharBuffer(source), fileName, forceStrict);
        }
        catch (IOException e) {
            throw new ParserException(e);
        }
    }

    public ProgramTree parse(CharStream source, String fileName) {
        return this.parse(source, fileName, false);
    }

    public ProgramTree parse(CharStream source, String fileName, boolean forceStrict) {
        Lexer lexer = new Lexer(source);
        lexer.setFileName(fileName);
        TokenQueue tokens = new TokenQueue(lexer);
        Parser parser = new Parser(this.context, this.factory, tokens);
        parser.forceStrict(forceStrict);
        return parser.program();
    }
}

