/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.js;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.dynjs.parser.js.CharStream;
import org.dynjs.parser.js.LexerException;
import org.dynjs.parser.js.SyntaxError;
import org.dynjs.parser.js.Token;
import org.dynjs.parser.js.TokenType;

public class Lexer {
    private static Set<String> KEYWORDS = new HashSet<String>(){
        {
            this.add("break");
            this.add("do");
            this.add("instanceof");
            this.add("typeof");
            this.add("case");
            this.add("else");
            this.add("new");
            this.add("var");
            this.add("catch");
            this.add("finally");
            this.add("return");
            this.add("void");
            this.add("continue");
            this.add("for");
            this.add("switch");
            this.add("while");
            this.add("debugger");
            this.add("function");
            this.add("this");
            this.add("with");
            this.add("default");
            this.add("if");
            this.add("throw");
            this.add("delete");
            this.add("in");
            this.add("try");
            this.add("null");
            this.add("true");
            this.add("false");
        }
    };
    private CharStream stream;
    private String fileName = "<eval>";
    private int lineNumber;
    private int columnNumber;
    private TokenType lastTokenType;
    private int parens;

    public Lexer(CharStream stream) {
        this.stream = stream;
        this.lineNumber = 1;
        this.columnNumber = 0;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName == null ? "<eval>" : fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    protected int la() {
        try {
            return this.stream.peek();
        }
        catch (IOException e) {
            throw new LexerException(e);
        }
    }

    protected int la(int pos) {
        try {
            return this.stream.peek(pos);
        }
        catch (IOException e) {
            throw new LexerException(e);
        }
    }

    protected int consume() {
        try {
            ++this.columnNumber;
            return this.stream.consume();
        }
        catch (IOException e) {
            throw new LexerException(e);
        }
    }

    protected Token newToken(TokenType type, String text) {
        if (!type.isSkippable()) {
            this.lastTokenType = type;
        }
        Token token = null;
        token = text == null ? new Token(type, text, this.fileName, this.lineNumber, this.columnNumber) : new Token(type, text, this.fileName, this.lineNumber, this.columnNumber - text.length());
        if (type == TokenType.LEFT_PAREN) {
            ++this.parens;
        } else if (type == TokenType.RIGHT_PAREN) {
            --this.parens;
        }
        return token;
    }

    protected void incrementLine() {
        ++this.lineNumber;
        this.columnNumber = 0;
    }

    private boolean isRegexpEnabled() {
        if (this.lastTokenType == null) {
            return true;
        }
        switch (this.lastTokenType) {
            case IDENTIFIER: 
            case NULL: 
            case TRUE: 
            case FALSE: 
            case THIS: 
            case DECIMAL_LITERAL: 
            case HEX_LITERAL: 
            case STRING_LITERAL: 
            case RIGHT_BRACKET: 
            case RIGHT_PAREN: {
                return false;
            }
            case RIGHT_BRACE: {
                if (this.parens <= 0) break;
                return false;
            }
        }
        return true;
    }

    public Token nextToken() throws LexerException {
        Token token = null;
        block73: while (token == null) {
            int c = this.la();
            switch (c) {
                case -1: {
                    token = this.newToken(TokenType.EOF, null);
                    break block73;
                }
                case 123: {
                    this.consume();
                    token = this.newToken(TokenType.LEFT_BRACE, "{");
                    break block73;
                }
                case 125: {
                    this.consume();
                    token = this.newToken(TokenType.RIGHT_BRACE, "}");
                    break block73;
                }
                case 40: {
                    this.consume();
                    token = this.newToken(TokenType.LEFT_PAREN, "(");
                    break block73;
                }
                case 41: {
                    this.consume();
                    token = this.newToken(TokenType.RIGHT_PAREN, ")");
                    break block73;
                }
                case 91: {
                    this.consume();
                    token = this.newToken(TokenType.LEFT_BRACKET, "[");
                    break block73;
                }
                case 93: {
                    this.consume();
                    token = this.newToken(TokenType.RIGHT_BRACKET, "[");
                    break block73;
                }
                case 46: {
                    int d = this.la(2);
                    if (d >= 48 && d <= 57) {
                        token = this.decimalLiteral();
                        break block73;
                    }
                    this.consume();
                    token = this.newToken(TokenType.DOT, ".");
                    break block73;
                }
                case 59: {
                    this.consume();
                    token = this.newToken(TokenType.SEMICOLON, ";");
                    break block73;
                }
                case 44: {
                    this.consume();
                    token = this.newToken(TokenType.COMMA, ",");
                    break block73;
                }
                case 58: {
                    this.consume();
                    token = this.newToken(TokenType.COLON, ":");
                    break block73;
                }
                case 63: {
                    this.consume();
                    token = this.newToken(TokenType.QUESTION, "?");
                    break block73;
                }
                case 60: {
                    this.consume();
                    int d = this.la();
                    switch (d) {
                        case 61: {
                            this.consume();
                            token = this.newToken(TokenType.LESS_THAN_EQUAL, "<=");
                            break block73;
                        }
                        case 60: {
                            this.consume();
                            if (this.la() == 61) {
                                this.consume();
                                token = this.newToken(TokenType.LEFT_SHIFT_EQUALS, "<<=");
                                break block73;
                            }
                            token = this.newToken(TokenType.LEFT_SHIFT, "<<");
                            break block73;
                        }
                    }
                    token = this.newToken(TokenType.LESS_THAN, ">");
                    break block73;
                }
                case 62: {
                    this.consume();
                    int d = this.la();
                    switch (d) {
                        case 61: {
                            this.consume();
                            token = this.newToken(TokenType.GREATER_THAN_EQUAL, ">=");
                            break block73;
                        }
                        case 62: {
                            this.consume();
                            d = this.la();
                            switch (d) {
                                case 62: {
                                    this.consume();
                                    if (this.la() == 61) {
                                        this.consume();
                                        token = this.newToken(TokenType.UNSIGNED_RIGHT_SHIFT_EQUALS, ">>>=");
                                        break block73;
                                    }
                                    token = this.newToken(TokenType.UNSIGNED_RIGHT_SHIFT, ">>>");
                                    break block73;
                                }
                                case 61: {
                                    this.consume();
                                    token = this.newToken(TokenType.RIGHT_SHIFT_EQUALS, ">>>");
                                    break block73;
                                }
                            }
                            token = this.newToken(TokenType.RIGHT_SHIFT, ">>");
                            break block73;
                        }
                    }
                    token = this.newToken(TokenType.GREATER_THAN, ">");
                    break block73;
                }
                case 61: {
                    this.consume();
                    if (this.la() == 61) {
                        this.consume();
                        if (this.la() == 61) {
                            this.consume();
                            token = this.newToken(TokenType.STRICT_EQUALITY, "===");
                            break block73;
                        }
                        token = this.newToken(TokenType.EQUALITY, "==");
                        break block73;
                    }
                    token = this.newToken(TokenType.EQUALS, "=");
                    break block73;
                }
                case 33: {
                    this.consume();
                    if (this.la() == 61) {
                        this.consume();
                        if (this.la() == 61) {
                            this.consume();
                            token = this.newToken(TokenType.STRICT_NOT_EQUALITY, "!==");
                            break block73;
                        }
                        token = this.newToken(TokenType.NOT_EQUALITY, "!=");
                        break block73;
                    }
                    token = this.newToken(TokenType.NOT, "!");
                    break block73;
                }
                case 43: {
                    int d = this.la(2);
                    switch (d) {
                        case 43: {
                            this.consume();
                            this.consume();
                            token = this.newToken(TokenType.PLUS_PLUS, "++");
                            break block73;
                        }
                        case 61: {
                            this.consume();
                            this.consume();
                            token = this.newToken(TokenType.PLUS_EQUALS, "+=");
                            break block73;
                        }
                    }
                    this.consume();
                    token = this.newToken(TokenType.PLUS, "+");
                    break block73;
                }
                case 45: {
                    int d = this.la(2);
                    switch (d) {
                        case 45: {
                            this.consume();
                            this.consume();
                            token = this.newToken(TokenType.MINUS_MINUS, "--");
                            break block73;
                        }
                        case 61: {
                            this.consume();
                            this.consume();
                            token = this.newToken(TokenType.MINUS_EQUALS, "-=");
                            break block73;
                        }
                    }
                    this.consume();
                    token = this.newToken(TokenType.MINUS, "-");
                    break block73;
                }
                case 42: {
                    this.consume();
                    if (this.la() == 61) {
                        this.consume();
                        token = this.newToken(TokenType.MULTIPLY_EQUALS, "*=");
                        break block73;
                    }
                    token = this.newToken(TokenType.MULTIPLY, "*");
                    break block73;
                }
                case 47: {
                    this.consume();
                    int d = this.la();
                    switch (d) {
                        case 61: {
                            if (this.isRegexpEnabled()) {
                                token = this.regexpLiteral();
                                break block73;
                            }
                            this.consume();
                            token = this.newToken(TokenType.DIVIDE_EQUALS, "/=");
                            break block73;
                        }
                        case 47: {
                            this.singleLineComment();
                            continue block73;
                        }
                        case 42: {
                            this.multiLineComment();
                            continue block73;
                        }
                    }
                    if (this.isRegexpEnabled()) {
                        token = this.regexpLiteral();
                        break block73;
                    }
                    token = this.newToken(TokenType.DIVIDE, "/");
                    break block73;
                }
                case 37: {
                    this.consume();
                    if (this.la() == 61) {
                        this.consume();
                        token = this.newToken(TokenType.MODULO_EQUALS, "%=");
                        break block73;
                    }
                    token = this.newToken(TokenType.MODULO, "%");
                    break block73;
                }
                case 124: {
                    this.consume();
                    int d = this.la();
                    switch (d) {
                        case 124: {
                            this.consume();
                            token = this.newToken(TokenType.LOGICAL_OR, "||");
                            break block73;
                        }
                        case 61: {
                            this.consume();
                            token = this.newToken(TokenType.BITWISE_OR_EQUALS, "|=");
                            break block73;
                        }
                    }
                    token = this.newToken(TokenType.BITWISE_OR, "|");
                    break block73;
                }
                case 38: {
                    this.consume();
                    int d = this.la();
                    switch (d) {
                        case 38: {
                            this.consume();
                            token = this.newToken(TokenType.LOGICAL_AND, "&&");
                            break block73;
                        }
                        case 61: {
                            this.consume();
                            token = this.newToken(TokenType.BITWISE_AND_EQUALS, "&&");
                            break block73;
                        }
                    }
                    token = this.newToken(TokenType.BITWISE_AND, "&");
                    break block73;
                }
                case 94: {
                    this.consume();
                    if (this.la() == 61) {
                        this.consume();
                        token = this.newToken(TokenType.BITWISE_XOR_EQUALS, "^=");
                        break block73;
                    }
                    token = this.newToken(TokenType.BITWISE_XOR, "^");
                    break block73;
                }
                case 126: {
                    this.consume();
                    token = this.newToken(TokenType.INVERSION, "~");
                    break block73;
                }
                case 9: {
                    this.consume();
                    continue block73;
                }
                case 11: {
                    this.consume();
                    continue block73;
                }
                case 12: {
                    this.consume();
                    continue block73;
                }
                case 32: {
                    this.consume();
                    continue block73;
                }
                case 160: {
                    this.consume();
                    continue block73;
                }
                case 65279: {
                    this.consume();
                    continue block73;
                }
                case 10: {
                    this.consume();
                    token = this.newToken(TokenType.NL, "\n");
                    this.incrementLine();
                    break block73;
                }
                case 13: {
                    this.consume();
                    if (this.la() == 10) {
                        this.consume();
                        token = this.newToken(TokenType.CRNL, "\r\n");
                    } else {
                        token = this.newToken(TokenType.CR, "\r");
                    }
                    this.incrementLine();
                    break block73;
                }
                case 8232: {
                    this.consume();
                    token = this.newToken(TokenType.LINE_SEPARATOR, "\u2028");
                    break block73;
                }
                case 8233: {
                    this.consume();
                    token = this.newToken(TokenType.PARAGRAPH_SEPARATOR, "\u2029");
                    break block73;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    token = this.numericLiteral();
                    break block73;
                }
                case 39: {
                    token = this.stringLiteral('\'');
                    break block73;
                }
                case 34: {
                    token = this.stringLiteral('\"');
                    break block73;
                }
                default: {
                    if (Character.getType(c) == 12) {
                        this.consume();
                        continue block73;
                    }
                    if ((Character.isLetter(c) || c == 36 || c == 95 || this.isUnicodeEscapeSequence(c)) && (token = this.identifierOrReservedWord()) != null) break block73;
                    throw new SyntaxError("unexpected character: " + c);
                }
            }
        }
        return token;
    }

    private boolean isIdentifierStart(int c) {
        return Character.isLetter(c) || Character.getType(c) == 10 || c == 36 || c == 95 || this.isUnicodeEscapeSequence(c) && !this.isNonEscapeSequence(c);
    }

    private boolean isIdentifierPart(int c) {
        if (this.isIdentifierStart(c)) {
            return true;
        }
        int type = Character.getType(c);
        switch (type) {
            case 6: 
            case 8: 
            case 9: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    private boolean isUnicodeEscapeSequence(int start) {
        if (start != 92) {
            return false;
        }
        return this.la(2) == 117 && this.isHexDigit(this.la(3)) && this.isHexDigit(this.la(4)) && this.isHexDigit(this.la(5)) && this.isHexDigit(this.la(6));
    }

    private boolean isHexEscapeSequence(int start) {
        if (start != 92) {
            return false;
        }
        return this.la(2) == 120 && this.isHexDigit(this.la(3)) && this.isHexDigit(this.la(4));
    }

    private boolean isNonEscapeSequence(int start) {
        if (this.la(3) == 48 && this.la(4) == 48 && this.la(5) == 48 && (this.la(6) == 65 || this.la(6) == 68)) {
            return true;
        }
        return this.la(3) == 50 && this.la(4) == 48 && this.la(5) == 50 && (this.la(6) == 56 || this.la(6) == 57);
    }

    private boolean isHexDigit(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    public Token regexpLiteral() {
        StringBuilder text = new StringBuilder();
        text.append("/");
        block8: while (this.la() != 47) {
            switch (this.la()) {
                case -1: {
                    throw new LexerException("unexpected end-of-file");
                }
                case 91: {
                    text.append((char)this.consume());
                    block9: while (this.la() != 93) {
                        switch (this.la()) {
                            case 91: {
                                text.append('\\');
                                text.append((char)this.consume());
                                continue block9;
                            }
                        }
                        text.append((char)this.consume());
                    }
                    text.append((char)this.consume());
                    continue block8;
                }
                case 92: {
                    if (this.la(2) == 47) {
                        this.consume();
                        this.consume();
                        text.append("/");
                        continue block8;
                    }
                    text.append((char)this.consume());
                    text.append((char)this.consume());
                    continue block8;
                }
            }
            text.append((char)this.consume());
        }
        text.append((char)this.consume());
        while (this.isIdentifierPart(this.la())) {
            text.append((char)this.consume());
        }
        return this.newToken(TokenType.REGEXP_LITERAL, text.toString());
    }

    protected Token identifierOrReservedWord() {
        StringBuilder text = new StringBuilder();
        if (this.isIdentifierStart(this.la())) {
            if (this.isUnicodeEscapeSequence(this.la())) {
                text.append(this.unicodeEscapeSequence());
            } else {
                text.append((char)this.consume());
            }
        }
        while (this.isIdentifierPart(this.la())) {
            if (this.isUnicodeEscapeSequence(this.la())) {
                text.append(this.unicodeEscapeSequence());
                continue;
            }
            text.append((char)this.consume());
        }
        if (text.length() == 0) {
            this.isNonEscapeSequence(this.la());
            this.consume();
            this.consume();
            this.consume();
            this.consume();
            this.consume();
            this.consume();
            throw new SyntaxError("unicode escapes not allowed here");
        }
        String str = text.toString();
        if (KEYWORDS.contains(str)) {
            return this.newToken(TokenType.valueOf(str.toUpperCase()), str);
        }
        return this.newToken(TokenType.IDENTIFIER, text.toString());
    }

    protected boolean isLineTerminator(char c) {
        return c == '\n' || c == '\r' || c == '\u2028' || c == '\u2029';
    }

    protected void singleLineComment() {
        this.consume();
        int c = 0;
        while (((c = this.la()) != 13 || this.la(2) != 10) && c >= 0 && c != 13 && c != 10 && c != 8232 && c != 8233) {
            this.consume();
        }
        this.incrementLine();
    }

    protected void multiLineComment() {
        this.consume();
        while (true) {
            int c;
            if ((c = this.consume()) < 0) {
                throw new LexerException("unexpected end-of-file");
            }
            if (c == 10) {
                this.incrementLine();
                continue;
            }
            if (c == 13) {
                if (this.la() == 10) {
                    this.consume();
                }
                this.incrementLine();
                continue;
            }
            if (c == 42 && this.la() == 47) break;
        }
        this.consume();
    }

    protected Token numericLiteral() {
        int c = this.la();
        if (c == 48) {
            int d = this.la(2);
            if (d == 120 || d == 88) {
                return this.hexLiteral();
            }
            if (d >= 48 && d <= 55) {
                return this.octalLiteral();
            }
        }
        return this.decimalLiteral();
    }

    protected Token octalLiteral() {
        StringBuilder text = new StringBuilder();
        this.consume();
        while (this.la() >= 48 && this.la() <= 55) {
            text.append((char)this.consume());
        }
        return this.newToken(TokenType.OCTAL_LITERAL, text.toString());
    }

    protected Token decimalLiteral() {
        StringBuilder text = new StringBuilder();
        int c = this.la();
        if (c == 43 || c == 45) {
            text.append((char)this.consume());
        }
        while ((c = this.la()) >= 48 && c <= 57) {
            text.append((char)this.consume());
        }
        if (this.la() == 46) {
            text.append((char)this.consume());
            while ((c = this.la()) >= 48 && c <= 57) {
                text.append((char)this.consume());
            }
        }
        if (this.la() == 69 || this.la() == 101) {
            text.append((char)this.consume());
            c = this.la();
            if (c == 43 || c == 45) {
                text.append((char)this.consume());
            }
            while ((c = this.la()) >= 48 && c <= 57) {
                text.append((char)this.consume());
            }
        }
        return this.newToken(TokenType.DECIMAL_LITERAL, text.toString());
    }

    protected Token hexLiteral() {
        int c;
        StringBuilder text = new StringBuilder();
        text.append((char)this.consume());
        text.append((char)this.consume());
        while ((c = this.la()) >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70) {
            text.append((char)this.consume());
        }
        return this.newToken(TokenType.HEX_LITERAL, text.toString());
    }

    protected Token stringLiteral(char type) {
        StringBuilder text = new StringBuilder();
        this.consume();
        int c = 0;
        boolean escapedString = false;
        boolean escapedOctalString = false;
        boolean continuedLine = false;
        block17: while ((c = this.la()) != type) {
            if (c < 0) {
                throw new LexerException("unexpected end-of-file");
            }
            if (c == 10) {
                throw new LexerException("line-feeds not allowed within string literals");
            }
            if (c == 13) {
                throw new LexerException("carriage-returns not allowed within string literals");
            }
            if (c == 92) {
                int d = this.la(2);
                switch (d) {
                    case 34: 
                    case 39: 
                    case 92: {
                        this.consume();
                        text.append((char)this.consume());
                        continue block17;
                    }
                    case 98: {
                        this.consume();
                        this.consume();
                        text.append("\b");
                        continue block17;
                    }
                    case 102: {
                        this.consume();
                        this.consume();
                        text.append("\f");
                        continue block17;
                    }
                    case 110: {
                        this.consume();
                        this.consume();
                        text.append("\n");
                        continue block17;
                    }
                    case 114: {
                        this.consume();
                        this.consume();
                        text.append("\r");
                        continue block17;
                    }
                    case 116: {
                        this.consume();
                        this.consume();
                        text.append("\t");
                        continue block17;
                    }
                    case 118: {
                        this.consume();
                        this.consume();
                        text.append("\u000b");
                        continue block17;
                    }
                    case 10: 
                    case 13: 
                    case 8232: 
                    case 8233: {
                        this.consume();
                        this.lineTerminatorSequence();
                        continuedLine = true;
                        continue block17;
                    }
                    case 117: {
                        text.append(this.unicodeEscapeSequence());
                        escapedString = true;
                        continue block17;
                    }
                    case 120: {
                        text.append(this.hexEscapeSequence());
                        escapedString = true;
                        continue block17;
                    }
                    case 48: {
                        switch (this.la(3)) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                break;
                            }
                            default: {
                                this.consume();
                                this.consume();
                                text.append(new String(new char[]{'\u0000'}));
                                continue block17;
                            }
                        }
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        text.append(this.octalEscapeSequence());
                        escapedString = true;
                        escapedOctalString = true;
                        continue block17;
                    }
                }
                this.consume();
                text.append((char)this.consume());
                continue;
            }
            text.append((char)this.consume());
        }
        this.consume();
        Token token = this.newToken(TokenType.STRING_LITERAL, text.toString());
        token.setEscapedString(escapedString);
        token.setEscapedOctalString(escapedOctalString);
        token.setContinuedLine(continuedLine);
        return token;
    }

    protected String unicodeEscapeSequence() {
        StringBuilder text = new StringBuilder();
        text.append("0x");
        this.consume();
        this.consume();
        for (int i = 0; i < 4; ++i) {
            char c = this.hexDigit();
            text.append(c);
        }
        int code = Integer.decode(text.toString());
        return new String(Character.toChars(code));
    }

    protected String hexEscapeSequence() {
        StringBuilder text = new StringBuilder();
        text.append("0x");
        this.consume();
        this.consume();
        for (int i = 0; i < 2; ++i) {
            text.append(this.hexDigit());
        }
        int code = Integer.decode(text.toString());
        return Character.toString((char)code);
    }

    protected String octalEscapeSequence() {
        StringBuilder text = new StringBuilder();
        this.consume();
        text.append(this.octalDigit());
        if (this.isOctalDigit(this.la())) {
            text.append(this.octalDigit());
            if (this.isOctalDigit(this.la())) {
                text.append(this.octalDigit());
            }
        }
        int code = Integer.decode(text.toString());
        return Character.toString((char)code);
    }

    protected boolean isOctalDigit(int c) {
        return c >= 48 && c <= 55;
    }

    protected char octalDigit() {
        int c = this.la();
        if (this.isOctalDigit(c)) {
            return (char)this.consume();
        }
        throw new LexerException("expected octal digit, but found '" + c + "'");
    }

    protected char hexDigit() {
        int c = this.la();
        if (c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70) {
            return (char)this.consume();
        }
        throw new LexerException("expected hex digit, but found '" + c + "'");
    }

    protected void lineTerminatorSequence() {
        int c = this.la();
        switch (c) {
            case 10: 
            case 8232: 
            case 8233: {
                this.consume();
                return;
            }
            case 13: {
                this.consume();
                if (this.la() == 10) {
                    this.consume();
                    return;
                }
                return;
            }
        }
    }
}

