/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime;

import java.util.Collections;
import java.util.List;
import org.dynjs.parser.Statement;
import org.dynjs.parser.ast.BlockStatement;
import org.dynjs.parser.ast.FunctionDeclaration;
import org.dynjs.parser.ast.VariableDeclaration;
import org.dynjs.parser.ast.VariableStatement;
import org.dynjs.runtime.JSCode;

public abstract class AbstractCode
implements JSCode {
    private Statement block;
    private boolean strict;

    public AbstractCode(Statement block) {
        this(block, false);
    }

    public AbstractCode(Statement block, boolean strict) {
        this.block = block;
        this.strict = strict;
    }

    @Override
    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public Statement getBlock() {
        return this.block;
    }

    @Override
    public List<FunctionDeclaration> getFunctionDeclarations() {
        if (this.block instanceof BlockStatement) {
            return ((BlockStatement)this.block).getFunctionDeclarations();
        }
        if (this.block instanceof FunctionDeclaration) {
            return Collections.singletonList((FunctionDeclaration)this.block);
        }
        return Collections.emptyList();
    }

    @Override
    public List<VariableDeclaration> getVariableDeclarations() {
        if (this.block instanceof BlockStatement) {
            return ((BlockStatement)this.block).getVariableDeclarations();
        }
        if (this.block instanceof VariableStatement) {
            return ((VariableStatement)this.block).getVariableDeclarations();
        }
        return Collections.emptyList();
    }

    public String getFileName() {
        String name = null;
        if (this.block.getPosition() != null) {
            name = this.block.getPosition().getFileName();
        }
        if (name == null) {
            name = "<eval>";
        }
        return name;
    }
}

