/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime;

import org.dynjs.exception.ThrowException;
import org.dynjs.runtime.DynObject;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.JSFunction;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.LexicalEnvironment;
import org.dynjs.runtime.PropertyDescriptor;
import org.dynjs.runtime.Types;

public abstract class AbstractFunction
extends DynObject
implements JSFunction {
    private String[] formalParameters;
    private LexicalEnvironment scope;
    private boolean strict;
    protected String debugContext;

    public AbstractFunction(LexicalEnvironment scope, boolean strict, String ... formalParameters) {
        super(scope.getGlobalObject());
        Object thrower;
        this.formalParameters = formalParameters;
        this.scope = scope;
        this.strict = strict;
        this.setClassName("Function");
        PropertyDescriptor lengthDesc = new PropertyDescriptor();
        lengthDesc.set((byte)0, formalParameters.length);
        lengthDesc.set((byte)3, false);
        lengthDesc.set((byte)4, false);
        lengthDesc.set((byte)5, false);
        this.defineOwnProperty(null, "length", lengthDesc, false);
        if (strict && (thrower = scope.getGlobalObject().get(null, "__throwTypeError")) != null) {
            PropertyDescriptor callerDesc = new PropertyDescriptor();
            callerDesc.set((byte)1, thrower);
            callerDesc.set((byte)2, thrower);
            callerDesc.set((byte)4, false);
            callerDesc.set((byte)5, false);
            this.defineOwnProperty(null, "caller", callerDesc, false);
            PropertyDescriptor argDesc = new PropertyDescriptor();
            argDesc.set((byte)1, thrower);
            argDesc.set((byte)2, thrower);
            argDesc.set((byte)4, false);
            argDesc.set((byte)5, false);
            this.defineOwnProperty(null, "arguments", argDesc, true);
        }
        this.setPrototype(scope.getGlobalObject().getPrototypeFor("Function"));
    }

    @Override
    public LexicalEnvironment getScope() {
        return this.scope;
    }

    public void setScope(LexicalEnvironment scope) {
        this.scope = scope;
    }

    @Override
    public boolean isStrict() {
        return this.strict;
    }

    @Override
    public boolean isConstructor() {
        return true;
    }

    @Override
    public String[] getFormalParameters() {
        return this.formalParameters;
    }

    protected void setFormalParamters(String[] formalParameters) {
        this.formalParameters = formalParameters;
    }

    @Override
    public Object get(ExecutionContext context, String name) {
        if (name.equals("caller") && this.strict) {
            throw new ThrowException(context, context.createTypeError("may not reference 'caller'"));
        }
        return super.get(context, name);
    }

    @Override
    public boolean hasInstance(ExecutionContext context, Object v) {
        if (!(v instanceof JSObject)) {
            return false;
        }
        Object o = this.get(null, "prototype");
        if (!(o instanceof JSObject)) {
            throw new ThrowException(context, context.createTypeError("prototype must be an object"));
        }
        JSObject proto = (JSObject)this.get(null, "prototype");
        if (proto == null || v == Types.UNDEFINED) {
            return false;
        }
        do {
            if ((v = ((JSObject)v).getPrototype()) != null && v != Types.UNDEFINED) continue;
            return false;
        } while (v != proto);
        return true;
    }

    @Override
    public JSObject createNewObject(ExecutionContext context) {
        return new DynObject(context.getGlobalObject());
    }

    @Override
    public void setDebugContext(String debugContext) {
        this.debugContext = debugContext;
    }

    @Override
    public String getDebugContext() {
        return this.debugContext;
    }
}

