/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime;

import java.util.Collections;
import java.util.List;
import org.dynjs.parser.ast.FunctionDeclaration;
import org.dynjs.parser.ast.VariableDeclaration;
import org.dynjs.runtime.AbstractFunction;
import org.dynjs.runtime.Arguments;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.LexicalEnvironment;
import org.dynjs.runtime.Reference;
import org.dynjs.runtime.Types;

public abstract class AbstractNativeFunction
extends AbstractFunction {
    protected String filename;

    public AbstractNativeFunction(GlobalObject globalObject, String ... formalParameters) {
        super(LexicalEnvironment.newObjectEnvironment(globalObject, false, null), true, formalParameters);
        this.setupDebugContext();
        this.setFileName();
    }

    public AbstractNativeFunction(GlobalObject globalObject, boolean strict, String ... formalParameters) {
        super(LexicalEnvironment.newObjectEnvironment(globalObject, false, null), strict, formalParameters);
        this.setupDebugContext();
        this.setFileName();
    }

    public AbstractNativeFunction(LexicalEnvironment scope, boolean strict, String ... formalParameters) {
        super(scope, strict, formalParameters);
        this.setupDebugContext();
        this.setFileName();
    }

    @Override
    public List<FunctionDeclaration> getFunctionDeclarations() {
        return Collections.emptyList();
    }

    @Override
    public List<VariableDeclaration> getVariableDeclarations() {
        return Collections.emptyList();
    }

    @Override
    public Object call(ExecutionContext context) {
        int i;
        int paramsLen;
        Object self = context.getThisBinding();
        Arguments argsObj = (Arguments)context.resolve("arguments").getValue(context);
        int numArgs = (Integer)argsObj.get(context, "length");
        Object[] args = new Object[numArgs < (paramsLen = this.getFormalParameters().length) ? paramsLen : numArgs];
        for (i = 0; i < numArgs; ++i) {
            Object v = argsObj.get(context, "" + i);
            if (v instanceof Reference) {
                v = ((Reference)v).isUnresolvableReference() ? Types.UNDEFINED : ((Reference)v).getValue(context);
            }
            args[i] = v;
        }
        for (i = numArgs; i < paramsLen; ++i) {
            args[i] = Types.UNDEFINED;
        }
        return this.call(context, self, args);
    }

    public abstract Object call(ExecutionContext var1, Object var2, Object ... var3);

    @Override
    public String getFileName() {
        return this.filename;
    }

    public void setFileName() {
        this.filename = this.getClass().getName().replace(".", "/") + ".java";
    }

    public void setupDebugContext() {
        this.debugContext = "<native function: " + this.getClass().getSimpleName() + ">";
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("function(");
        String[] params = this.getFormalParameters();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(params[i]);
        }
        buffer.append("){\n");
        buffer.append("  <native code in: ").append(this.getClass().getName()).append(">\n");
        buffer.append("}");
        return buffer.toString();
    }
}

