/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime;

import org.dynjs.exception.ThrowException;
import org.dynjs.runtime.DynObject;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.PropertyDescriptor;
import org.dynjs.runtime.Types;

public class DynArray
extends DynObject {
    public DynArray(GlobalObject globalObject) {
        super(globalObject);
        this.setClassName("Array");
        PropertyDescriptor lengthDesc = new PropertyDescriptor();
        lengthDesc.set((byte)3, true);
        lengthDesc.set((byte)4, true);
        lengthDesc.set((byte)5, true);
        lengthDesc.set((byte)0, 0L);
        super.defineOwnProperty(null, "length", lengthDesc, false);
        this.setPrototype(globalObject.getPrototypeFor("Array"));
    }

    @Override
    public boolean defineOwnProperty(ExecutionContext context, String name, PropertyDescriptor desc, boolean shouldThrow) {
        PropertyDescriptor oldLenDesc = (PropertyDescriptor)this.getOwnProperty(context, "length");
        long oldLen = (Long)oldLenDesc.getValue();
        if (name.equals("length")) {
            if (desc.getValue() == null) {
                return super.defineOwnProperty(context, "length", desc, shouldThrow);
            }
            PropertyDescriptor newLenDesc = desc;
            Long newLen = Types.toUint32(context, desc.getValue());
            if (!Types.compareEquality(context, newLen, Types.toNumber(context, desc.getValue()))) {
                throw new ThrowException(context, context.createRangeError("invalid length: " + newLen));
            }
            newLenDesc.setValue(newLen);
            if (newLen >= oldLen) {
                return super.defineOwnProperty(context, "length", newLenDesc, shouldThrow);
            }
            if (oldLenDesc.get((byte)3) == Boolean.FALSE) {
                return this.reject(context, shouldThrow);
            }
            boolean newWritable = false;
            if (!newLenDesc.hasWritable() || newLenDesc.get((byte)3) == Boolean.TRUE) {
                newWritable = true;
            } else {
                newWritable = false;
                newLenDesc.set((byte)3, true);
            }
            boolean succeeded = super.defineOwnProperty(context, "length", newLenDesc, shouldThrow);
            if (!succeeded) {
                return false;
            }
            while (newLen < oldLen) {
                boolean deleteSucceeded = this.delete(context, "" + --oldLen, false);
                if (deleteSucceeded) continue;
                newLenDesc.setValue(oldLen + 1L);
                if (!newWritable) {
                    newLenDesc.setWritable(false);
                }
                super.defineOwnProperty(context, "length", newLenDesc, false);
                return this.reject(context, shouldThrow);
            }
            if (!newWritable) {
                PropertyDescriptor lengthDesc = new PropertyDescriptor();
                lengthDesc.set((byte)3, false);
                super.defineOwnProperty(context, "length", lengthDesc, false);
            }
            return true;
        }
        if (this.isArrayIndex(context, name)) {
            Long index = Types.toUint32(context, name);
            if (index >= oldLen && oldLenDesc.get((byte)3) == Boolean.FALSE) {
                return this.reject(context, shouldThrow);
            }
            boolean succeeded = super.defineOwnProperty(context, name, desc, shouldThrow);
            if (!succeeded) {
                return this.reject(context, shouldThrow);
            }
            if (index >= oldLen && index < 0xFFFFFFFFL) {
                oldLenDesc.setValue(index + 1L);
                super.defineOwnProperty(context, "length", oldLenDesc, false);
            }
            return true;
        }
        return super.defineOwnProperty(context, name, desc, shouldThrow);
    }

    public long length() {
        return Types.toInt32(null, this.get(null, "length"));
    }

    protected boolean isArrayIndex(ExecutionContext context, String name) {
        return name.equals(Types.toUint32(context, name).toString());
    }
}

