/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime;

import java.util.ArrayList;
import java.util.List;
import org.dynjs.Config;
import org.dynjs.compiler.JSCompiler;
import org.dynjs.runtime.BlockManager;
import org.dynjs.runtime.DynJS;
import org.dynjs.runtime.DynObject;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.PropertyDescriptor;
import org.dynjs.runtime.Types;
import org.dynjs.runtime.builtins.DecodeUri;
import org.dynjs.runtime.builtins.DecodeUriComponent;
import org.dynjs.runtime.builtins.DynJSBuiltin;
import org.dynjs.runtime.builtins.EncodeUri;
import org.dynjs.runtime.builtins.EncodeUriComponent;
import org.dynjs.runtime.builtins.Escape;
import org.dynjs.runtime.builtins.Eval;
import org.dynjs.runtime.builtins.Include;
import org.dynjs.runtime.builtins.Intl;
import org.dynjs.runtime.builtins.IsFinite;
import org.dynjs.runtime.builtins.IsNaN;
import org.dynjs.runtime.builtins.JSON;
import org.dynjs.runtime.builtins.Math;
import org.dynjs.runtime.builtins.ParseFloat;
import org.dynjs.runtime.builtins.ParseInt;
import org.dynjs.runtime.builtins.Print;
import org.dynjs.runtime.builtins.Require;
import org.dynjs.runtime.builtins.ThrowTypeError;
import org.dynjs.runtime.builtins.Unescape;
import org.dynjs.runtime.builtins.types.AbstractBuiltinType;
import org.dynjs.runtime.builtins.types.BuiltinArray;
import org.dynjs.runtime.builtins.types.BuiltinBoolean;
import org.dynjs.runtime.builtins.types.BuiltinDate;
import org.dynjs.runtime.builtins.types.BuiltinError;
import org.dynjs.runtime.builtins.types.BuiltinEvalError;
import org.dynjs.runtime.builtins.types.BuiltinFunction;
import org.dynjs.runtime.builtins.types.BuiltinNumber;
import org.dynjs.runtime.builtins.types.BuiltinObject;
import org.dynjs.runtime.builtins.types.BuiltinRangeError;
import org.dynjs.runtime.builtins.types.BuiltinReferenceError;
import org.dynjs.runtime.builtins.types.BuiltinRegExp;
import org.dynjs.runtime.builtins.types.BuiltinString;
import org.dynjs.runtime.builtins.types.BuiltinSyntaxError;
import org.dynjs.runtime.builtins.types.BuiltinTypeError;
import org.dynjs.runtime.builtins.types.BuiltinURIError;
import org.dynjs.runtime.java.JavaPackage;

public class GlobalObject
extends DynObject {
    private DynJS runtime;
    private BlockManager blockManager;
    private List<AbstractBuiltinType> builtinTypes = new ArrayList<AbstractBuiltinType>();

    public GlobalObject(DynJS runtime) {
        super(null);
        this.runtime = runtime;
        this.blockManager = new BlockManager();
        this.defineReadOnlyGlobalProperty("__throwTypeError", new ThrowTypeError(this));
        this.registerBuiltinType("Object", new BuiltinObject(this));
        this.registerBuiltinType("Function", new BuiltinFunction(this));
        this.registerBuiltinType("Boolean", new BuiltinBoolean(this));
        this.registerBuiltinType("Number", new BuiltinNumber(this));
        this.registerBuiltinType("Array", new BuiltinArray(this));
        this.registerBuiltinType("String", new BuiltinString(this));
        this.registerBuiltinType("RegExp", new BuiltinRegExp(this));
        this.registerBuiltinType("Date", new BuiltinDate(this));
        this.registerBuiltinType("Error", new BuiltinError(this));
        this.registerBuiltinType("ReferenceError", new BuiltinReferenceError(this));
        this.registerBuiltinType("RangeError", new BuiltinRangeError(this));
        this.registerBuiltinType("SyntaxError", new BuiltinSyntaxError(this));
        this.registerBuiltinType("TypeError", new BuiltinTypeError(this));
        this.registerBuiltinType("URIError", new BuiltinURIError(this));
        this.registerBuiltinType("EvalError", new BuiltinEvalError(this));
        this.initializeBuiltinTypes();
        this.defineReadOnlyGlobalProperty("undefined", Types.UNDEFINED);
        this.defineGlobalProperty("parseFloat", new ParseFloat(this));
        this.defineGlobalProperty("parseInt", new ParseInt(this));
        this.defineGlobalProperty("eval", new Eval(this));
        this.defineGlobalProperty("isNaN", new IsNaN(this));
        this.defineGlobalProperty("isFinite", new IsFinite(this));
        this.defineGlobalProperty("encodeURI", new EncodeUri(this));
        this.defineGlobalProperty("decodeURI", new DecodeUri(this));
        this.defineGlobalProperty("encodeURIComponent", new EncodeUriComponent(this));
        this.defineGlobalProperty("decodeURIComponent", new DecodeUriComponent(this));
        if (runtime.getConfig().isNodePackageManagerEnabled()) {
            this.defineGlobalProperty("require", new Require(this));
        }
        this.defineGlobalProperty("include", new Include(this));
        this.defineGlobalProperty("load", new Include(this));
        this.defineGlobalProperty("escape", new Escape(this));
        this.defineGlobalProperty("unescape", new Unescape(this));
        this.defineGlobalProperty("print", new Print(this));
        this.defineGlobalProperty("dynjs", new DynJSBuiltin(this.runtime));
        this.put(null, "JSON", new JSON(this), false);
        this.defineGlobalProperty("Math", new Math(this));
        this.defineGlobalProperty("Intl", new Intl(this));
        this.defineGlobalProperty("Packages", new JavaPackage(this, null));
        this.defineGlobalProperty("java", new JavaPackage(this, "java"));
        this.defineGlobalProperty("org", new JavaPackage(this, "org"));
        this.defineGlobalProperty("com", new JavaPackage(this, "com"));
        this.defineGlobalProperty("io", new JavaPackage(this, "io"));
        this.setPrototype(this.getPrototypeFor("Object"));
    }

    private void registerBuiltinType(String name, AbstractBuiltinType type) {
        PropertyDescriptor desc = new PropertyDescriptor();
        desc.set((byte)0, type);
        desc.set((byte)5, false);
        desc.set((byte)3, true);
        desc.set((byte)4, true);
        this.defineOwnProperty(null, name, desc, false);
        this.put(null, "__Builtin_" + name, type, false);
        this.builtinTypes.add(type);
    }

    private void initializeBuiltinTypes() {
        for (AbstractBuiltinType each : this.builtinTypes) {
            each.setPrototype(this.getPrototypeFor("Function"));
            each.initialize(this);
        }
    }

    public static GlobalObject newGlobalObject(DynJS runtime) {
        return runtime.getConfig().getGlobalObjectFactory().newGlobalObject(runtime);
    }

    public DynJS getRuntime() {
        return this.runtime;
    }

    public Config getConfig() {
        return this.getRuntime().getConfig();
    }

    public JSCompiler getCompiler() {
        return this.runtime.getCompiler();
    }

    public BlockManager getBlockManager() {
        return this.blockManager;
    }

    public BlockManager.Entry retrieveBlockEntry(int statementNumber) {
        return this.blockManager.retrieve(statementNumber);
    }

    public void defineGlobalProperty(String name, Object value) {
        PropertyDescriptor desc = new PropertyDescriptor();
        desc.set((byte)0, value);
        desc.set((byte)3, true);
        desc.set((byte)5, false);
        desc.set((byte)4, true);
        this.defineOwnProperty(null, name, desc, false);
    }

    public void defineReadOnlyGlobalProperty(String name, Object value) {
        PropertyDescriptor desc = new PropertyDescriptor();
        desc.set((byte)0, value);
        desc.set((byte)3, false);
        desc.set((byte)4, false);
        desc.set((byte)5, false);
        this.defineOwnProperty(null, name, desc, false);
    }

    public JSObject getPrototypeFor(String type) {
        Object typeObj = this.get(null, type);
        if (typeObj == Types.UNDEFINED) {
            return null;
        }
        Object prototype = ((JSObject)typeObj).get(null, "prototype");
        if (prototype == Types.UNDEFINED) {
            return null;
        }
        return (JSObject)prototype;
    }
}

