/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins;

import org.dynjs.exception.ThrowException;
import org.dynjs.parser.js.LexerException;
import org.dynjs.parser.js.ParserException;
import org.dynjs.runtime.AbstractNonConstructorFunction;
import org.dynjs.runtime.EnvironmentRecord;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.Reference;
import org.dynjs.runtime.Runner;
import org.dynjs.runtime.Types;

public class Eval
extends AbstractNonConstructorFunction {
    public Eval(GlobalObject globalObject) {
        super(globalObject, "code");
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... args) {
        Object code;
        Reference ref;
        boolean direct = false;
        if (context.getFunctionReference() != null && context.getFunctionReference() instanceof Reference && (ref = (Reference)context.getFunctionReference()).getBase() instanceof EnvironmentRecord) {
            direct = ref.getReferencedName().equals("eval");
        }
        if ((code = args[0]) instanceof String) {
            try {
                Runner runner = context.getGlobalObject().getRuntime().newRunner();
                Object result = runner.withContext(context.getParent()).forceStrict(context.getParent().isStrict() && direct).directEval(direct).withSource((String)code).evaluate();
                if (result == null) {
                    return Types.UNDEFINED;
                }
                return result;
            }
            catch (LexerException e) {
                throw new ThrowException(context, context.createSyntaxError(e.getMessage()));
            }
            catch (ParserException e) {
                throw new ThrowException(context, context.createSyntaxError(e.getMessage()));
            }
        }
        return code;
    }

    @Override
    public void setFileName() {
        this.filename = "org/dynjs/runtime/builtins/Eval.java";
    }

    @Override
    public void setupDebugContext() {
        this.debugContext = "<native function: eval>";
    }
}

