/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.dynjs.exception.ThrowException;
import org.dynjs.runtime.AbstractNativeFunction;
import org.dynjs.runtime.DynJS;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.Runner;
import org.dynjs.runtime.Types;

public class Include
extends AbstractNativeFunction {
    public Include(GlobalObject globalObject) {
        super(globalObject, "name");
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... args) {
        String includePath = Types.toString(context, args[0]);
        File includeFile = new File(includePath);
        DynJS runtime = context.getGlobalObject().getRuntime();
        try {
            ExecutionContext parent = context.getParent();
            while (parent != null) {
                context = parent;
                parent = context.getParent();
            }
            Runner runner = runtime.newRunner();
            if (!includeFile.exists()) {
                InputStream is = context.getClassLoader().getResourceAsStream(includePath);
                if (is == null) {
                    throw new FileNotFoundException(includePath);
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                Object ret = runner.withContext(context).withSource(reader).execute();
                try {
                    is.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                return ret;
            }
            runner.withContext(context).withSource(includeFile).execute();
        }
        catch (IOException e) {
            throw new ThrowException(context, (Throwable)e);
        }
        return Types.UNDEFINED;
    }

    @Override
    public void setFileName() {
        this.filename = "org/dynjs/runtime/builtins/Include.java";
    }

    @Override
    public void setupDebugContext() {
        this.debugContext = "<native function: include>";
    }
}

