/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins;

import java.math.BigInteger;
import org.dynjs.runtime.AbstractNonConstructorFunction;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.Types;

public class ParseInt
extends AbstractNonConstructorFunction {
    public ParseInt(GlobalObject globalObject) {
        super(globalObject, "text", "radix");
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... arguments) {
        String inputString = Types.toString(context, arguments[0]);
        int len = inputString.length();
        int firstNonWhitespace = -1;
        for (int i = 0; i < len; ++i) {
            char c = inputString.charAt(i);
            if (Types.isWhitespace(c)) continue;
            firstNonWhitespace = i;
            break;
        }
        String s = null;
        int sign = 1;
        if (firstNonWhitespace < 0) {
            s = "";
        } else {
            s = inputString.substring(firstNonWhitespace);
            char c = s.charAt(0);
            if (c == '-') {
                sign = -1;
            }
            if (c == '-' || c == '+') {
                s = s.substring(1);
            }
        }
        long r = Types.toInt32(context, arguments[1]);
        boolean stripPrefix = true;
        if (r != 0L) {
            if (r < 2L || r > 36L) {
                return Double.NaN;
            }
            if (r != 16L) {
                stripPrefix = false;
            }
        } else {
            r = 10L;
        }
        if (stripPrefix && (s.startsWith("0X") || s.startsWith("0x"))) {
            s = s.substring(2);
            r = 16L;
        }
        len = s.length();
        int firstInvalidDigit = -1;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (ParseInt.isRadixDigit(c, r)) continue;
            firstInvalidDigit = i;
            break;
        }
        String z = null;
        z = firstInvalidDigit < 0 ? s : s.substring(0, firstInvalidDigit);
        if (z.equals("")) {
            return Double.NaN;
        }
        try {
            return (long)sign * Long.parseLong(z, (int)r);
        }
        catch (NumberFormatException e) {
            return (double)sign * new BigInteger(z, (int)r).doubleValue();
        }
    }

    static boolean isRadixDigit(char c, long radix) {
        if (radix <= 10L) {
            return c >= '0' && (long)c <= 48L + (radix - 1L);
        }
        return c >= '0' && c <= '9' || c >= 'a' && (long)c <= 97L + radix - 11L || c >= 'A' && (long)c <= 65L + radix - 11L;
    }

    @Override
    public void setFileName() {
        this.filename = "org/dynjs/runtime/builtins/ParseInt.java";
    }

    @Override
    public void setupDebugContext() {
        this.debugContext = "<native function: parseInt>";
    }
}

