/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.dynjs.exception.ThrowException;
import org.dynjs.runtime.AbstractNativeFunction;
import org.dynjs.runtime.DynObject;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.Types;
import org.dynjs.runtime.modules.ClasspathModuleProvider;
import org.dynjs.runtime.modules.ConsoleModule;
import org.dynjs.runtime.modules.FilesystemModuleProvider;
import org.dynjs.runtime.modules.JavaClassModuleProvider;
import org.dynjs.runtime.modules.ModuleProvider;
import org.dynjs.runtime.modules.UtilModule;

public class Require
extends AbstractNativeFunction {
    private List<ModuleProvider> moduleProviders = new ArrayList<ModuleProvider>();
    private LinkedList<String> loadPaths = new LinkedList();
    private final HashMap<String, Object> cache = new HashMap();

    public Require(GlobalObject globalObject) {
        super(globalObject, "name");
        DynObject module = new DynObject(globalObject);
        module.put("id", (Object)"dynjs");
        module.put("exports", (Object)new DynObject(globalObject));
        globalObject.put("module", (Object)module);
        globalObject.put("exports", module.get("exports"));
        JavaClassModuleProvider javaClassModuleProvider = new JavaClassModuleProvider();
        javaClassModuleProvider.addModule(new ConsoleModule());
        javaClassModuleProvider.addModule(new UtilModule());
        this.moduleProviders.add(javaClassModuleProvider);
        this.moduleProviders.add(new ClasspathModuleProvider());
        this.moduleProviders.add(new FilesystemModuleProvider());
        String customRequirePath = this.getCustomRequirePath();
        if (customRequirePath != null) {
            String[] paths = customRequirePath.split(":");
            Collections.addAll(this.loadPaths, paths);
        }
        this.loadPaths.add(System.getProperty("user.dir") + "/");
        this.put("paths", (Object)this.loadPaths);
        this.put("addLoadPath", (Object)new AbstractNativeFunction(globalObject, new String[0]){

            @Override
            public Object call(ExecutionContext context, Object self, Object ... args) {
                if (args[0] == null || args[0] == Types.UNDEFINED || args[0] == Types.NULL) {
                    return Require.this.loadPaths;
                }
                Require.this.addLoadPath((String)args[0]);
                return Require.this.loadPaths;
            }
        });
        this.put("removeLoadPath", (Object)new AbstractNativeFunction(globalObject, new String[0]){

            @Override
            public Object call(ExecutionContext context, Object self, Object ... args) {
                if (args[0] == null || args[0] == Types.UNDEFINED || args[0] == Types.NULL) {
                    return Types.NULL;
                }
                Require.this.removeLoadPath((String)args[0]);
                return Require.this.loadPaths;
            }
        });
        this.put("pushLoadPath", (Object)new AbstractNativeFunction(globalObject, new String[0]){

            @Override
            public Object call(ExecutionContext context, Object self, Object ... args) {
                if (args[0] == null || args[0] == Types.UNDEFINED || args[0] == Types.NULL) {
                    return Types.NULL;
                }
                Require.this.pushLoadPath((String)args[0]);
                return Require.this.loadPaths;
            }
        });
    }

    public List<ModuleProvider> getModuleProviders() {
        return this.moduleProviders;
    }

    public void addModuleProvider(ModuleProvider provider) {
        this.moduleProviders.add(provider);
    }

    public void removeLoadPath(String path) {
        this.loadPaths.remove(path);
        this.put("paths", (Object)this.loadPaths);
    }

    public void addLoadPath(String path) {
        this.loadPaths.add(path);
        this.put("paths", (Object)this.loadPaths);
    }

    public void pushLoadPath(String path) {
        this.loadPaths.push(path);
        this.put("paths", (Object)this.loadPaths);
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... arguments) {
        if (arguments[0] == Types.UNDEFINED) {
            throw new ThrowException(context, context.createError("Error", "no module identifier provided"));
        }
        String moduleName = (String)arguments[0];
        List<ModuleProvider> moduleProviders = this.getModuleProviders();
        for (int i = moduleProviders.size(); i > 0; --i) {
            ModuleProvider provider = moduleProviders.get(i - 1);
            String moduleId = provider.generateModuleID(context, moduleName);
            if (moduleId == null) continue;
            if (this.cache.containsKey(moduleId)) {
                return this.cache.get(moduleId);
            }
            DynObject module = new DynObject(context.getGlobalObject());
            DynObject exports = new DynObject(context.getGlobalObject());
            module.put(context, "exports", exports, true);
            module.put(context, "id", moduleId, false);
            this.cache.put(moduleId, exports);
            Object exported = provider.findAndLoad(context, moduleId, module, exports);
            if (exported != null) {
                this.cache.put(moduleId, exported);
            }
            return exported;
        }
        throw new ThrowException(context, context.createError("Error", "cannot load module " + moduleName));
    }

    private String getCustomRequirePath() {
        if (System.getenv("DYNJS_REQUIRE_PATH") != null) {
            return System.getenv("DYNJS_REQUIRE_PATH");
        }
        return System.getProperty("dynjs.require.path");
    }

    @Override
    public void setFileName() {
        this.filename = "org/dynjs/runtime/builtins/Require.java";
    }

    @Override
    public void setupDebugContext() {
        this.debugContext = "<native function: require>";
    }

    public List<String> getLoadPaths() {
        return this.loadPaths;
    }
}

