/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins.math;

import org.dynjs.runtime.AbstractNativeFunction;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.Types;
import org.dynjs.runtime.builtins.Math;
import org.dynjs.runtime.builtins.types.number.DynNumber;

public class Min
extends AbstractNativeFunction {
    public Min(GlobalObject globalObject) {
        super(globalObject, "value1", "value2");
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... args) {
        if (args[0] == Types.UNDEFINED) {
            return Double.POSITIVE_INFINITY;
        }
        if (args[1] == Types.UNDEFINED) {
            return args[0];
        }
        if (DynNumber.isNaN(args[0])) {
            return Double.NaN;
        }
        double min = new Double(Types.toNumber(context, args[0]).toString());
        for (int i = 1; i < args.length; ++i) {
            if (DynNumber.isNaN(args[i])) {
                return Double.NaN;
            }
            min = java.lang.Math.min(Types.toNumber(context, args[i]).doubleValue(), min);
        }
        return Math.coerceLongIfPossible(min);
    }

    @Override
    public void setFileName() {
        this.filename = "org/dynjs/runtime/builtins/math/Min.java";
    }

    @Override
    public void setupDebugContext() {
        this.debugContext = "<native function: min>";
    }
}

