/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins.types;

import org.dynjs.runtime.Arguments;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.JSFunction;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.Types;
import org.dynjs.runtime.builtins.types.AbstractBuiltinType;
import org.dynjs.runtime.builtins.types.date.AbstractDateFunction;
import org.dynjs.runtime.builtins.types.date.DynDate;
import org.dynjs.runtime.builtins.types.date.Parse;
import org.dynjs.runtime.builtins.types.date.UTC;
import org.dynjs.runtime.builtins.types.date.prototype.GetDate;
import org.dynjs.runtime.builtins.types.date.prototype.GetDay;
import org.dynjs.runtime.builtins.types.date.prototype.GetFullYear;
import org.dynjs.runtime.builtins.types.date.prototype.GetHours;
import org.dynjs.runtime.builtins.types.date.prototype.GetMilliseconds;
import org.dynjs.runtime.builtins.types.date.prototype.GetMinutes;
import org.dynjs.runtime.builtins.types.date.prototype.GetMonth;
import org.dynjs.runtime.builtins.types.date.prototype.GetSeconds;
import org.dynjs.runtime.builtins.types.date.prototype.GetTimezoneOffset;
import org.dynjs.runtime.builtins.types.date.prototype.GetUTCDate;
import org.dynjs.runtime.builtins.types.date.prototype.GetUTCDay;
import org.dynjs.runtime.builtins.types.date.prototype.GetUTCFullYear;
import org.dynjs.runtime.builtins.types.date.prototype.GetUTCHours;
import org.dynjs.runtime.builtins.types.date.prototype.GetUTCMilliseconds;
import org.dynjs.runtime.builtins.types.date.prototype.GetUTCMinutes;
import org.dynjs.runtime.builtins.types.date.prototype.GetUTCMonth;
import org.dynjs.runtime.builtins.types.date.prototype.GetUTCSeconds;
import org.dynjs.runtime.builtins.types.date.prototype.GetYear;
import org.dynjs.runtime.builtins.types.date.prototype.Now;
import org.dynjs.runtime.builtins.types.date.prototype.SetDate;
import org.dynjs.runtime.builtins.types.date.prototype.SetFullYear;
import org.dynjs.runtime.builtins.types.date.prototype.SetHours;
import org.dynjs.runtime.builtins.types.date.prototype.SetMilliseconds;
import org.dynjs.runtime.builtins.types.date.prototype.SetMinutes;
import org.dynjs.runtime.builtins.types.date.prototype.SetMonth;
import org.dynjs.runtime.builtins.types.date.prototype.SetSeconds;
import org.dynjs.runtime.builtins.types.date.prototype.SetTime;
import org.dynjs.runtime.builtins.types.date.prototype.SetUTCDate;
import org.dynjs.runtime.builtins.types.date.prototype.SetUTCFullYear;
import org.dynjs.runtime.builtins.types.date.prototype.SetUTCHours;
import org.dynjs.runtime.builtins.types.date.prototype.SetUTCMilliseconds;
import org.dynjs.runtime.builtins.types.date.prototype.SetUTCMinutes;
import org.dynjs.runtime.builtins.types.date.prototype.SetUTCMonth;
import org.dynjs.runtime.builtins.types.date.prototype.SetUTCSeconds;
import org.dynjs.runtime.builtins.types.date.prototype.SetYear;
import org.dynjs.runtime.builtins.types.date.prototype.ToDateString;
import org.dynjs.runtime.builtins.types.date.prototype.ToISOString;
import org.dynjs.runtime.builtins.types.date.prototype.ToJSON;
import org.dynjs.runtime.builtins.types.date.prototype.ToLocaleDateString;
import org.dynjs.runtime.builtins.types.date.prototype.ToLocaleString;
import org.dynjs.runtime.builtins.types.date.prototype.ToLocaleTimeString;
import org.dynjs.runtime.builtins.types.date.prototype.ToString;
import org.dynjs.runtime.builtins.types.date.prototype.ToTimeString;
import org.dynjs.runtime.builtins.types.date.prototype.ToUTCString;
import org.dynjs.runtime.builtins.types.date.prototype.ValueOf;

public class BuiltinDate
extends AbstractBuiltinType {
    public BuiltinDate(GlobalObject globalObject) {
        super(globalObject, "year", "month", "date", "hours", "minutes", "seconds", "ms");
        DynDate proto = new DynDate(globalObject);
        this.setPrototypeProperty(proto);
    }

    @Override
    public JSObject createNewObject(ExecutionContext context) {
        return new DynDate(context.getGlobalObject());
    }

    @Override
    public void initialize(GlobalObject globalObject, JSObject proto) {
        proto.setPrototype(globalObject.getPrototypeFor("Object"));
        this.defineNonEnumerableProperty(this, "now", (Object)new Now(globalObject, new String[0]));
        this.defineNonEnumerableProperty(this, "parse", (Object)new Parse(globalObject));
        this.defineNonEnumerableProperty(this, "UTC", (Object)new UTC(globalObject));
        this.defineNonEnumerableProperty(proto, "constructor", (Object)this);
        this.defineNonEnumerableProperty(proto, "toString", (Object)new ToString(globalObject));
        this.defineNonEnumerableProperty(proto, "toDateString", (Object)new ToDateString(globalObject));
        this.defineNonEnumerableProperty(proto, "toTimeString", (Object)new ToTimeString(globalObject));
        this.defineNonEnumerableProperty(proto, "toLocaleString", (Object)new ToLocaleString(globalObject));
        this.defineNonEnumerableProperty(proto, "toLocaleDateString", (Object)new ToLocaleDateString(globalObject));
        this.defineNonEnumerableProperty(proto, "toLocaleTimeString", (Object)new ToLocaleTimeString(globalObject));
        this.defineNonEnumerableProperty(proto, "toISOString", (Object)new ToISOString(globalObject));
        this.defineNonEnumerableProperty(proto, "toUTCString", (Object)new ToUTCString(globalObject));
        this.defineNonEnumerableProperty(proto, "toGMTString", (Object)new ToUTCString(globalObject));
        this.defineNonEnumerableProperty(proto, "valueOf", (Object)new ValueOf(globalObject, new String[0]));
        this.defineNonEnumerableProperty(proto, "getTime", (Object)new ValueOf(globalObject, new String[0]));
        this.defineNonEnumerableProperty(proto, "getFullYear", (Object)new GetFullYear(globalObject));
        this.defineNonEnumerableProperty(proto, "getMonth", (Object)new GetMonth(globalObject));
        this.defineNonEnumerableProperty(proto, "getDay", (Object)new GetDay(globalObject));
        this.defineNonEnumerableProperty(proto, "getHours", (Object)new GetHours(globalObject));
        this.defineNonEnumerableProperty(proto, "getMinutes", (Object)new GetMinutes(globalObject));
        this.defineNonEnumerableProperty(proto, "getSeconds", (Object)new GetSeconds(globalObject));
        this.defineNonEnumerableProperty(proto, "getUTCFullYear", (Object)new GetUTCFullYear(globalObject));
        this.defineNonEnumerableProperty(proto, "getUTCMonth", (Object)new GetUTCMonth(globalObject));
        this.defineNonEnumerableProperty(proto, "getUTCDay", (Object)new GetUTCDay(globalObject));
        this.defineNonEnumerableProperty(proto, "getUTCHours", (Object)new GetUTCHours(globalObject));
        this.defineNonEnumerableProperty(proto, "getUTCMinutes", (Object)new GetUTCMinutes(globalObject));
        this.defineNonEnumerableProperty(proto, "getUTCSeconds", (Object)new GetUTCSeconds(globalObject));
        this.defineNonEnumerableProperty(proto, "getTimezoneOffset", (Object)new GetTimezoneOffset(globalObject));
        this.defineNonEnumerableProperty(proto, "getMilliseconds", (Object)new GetMilliseconds(globalObject));
        this.defineNonEnumerableProperty(proto, "setMilliseconds", (Object)new SetMilliseconds(globalObject));
        this.defineNonEnumerableProperty(proto, "getUTCMilliseconds", (Object)new GetUTCMilliseconds(globalObject));
        this.defineNonEnumerableProperty(proto, "setUTCMilliseconds", (Object)new SetUTCMilliseconds(globalObject));
        this.defineNonEnumerableProperty(proto, "setTime", (Object)new SetTime(globalObject));
        this.defineNonEnumerableProperty(proto, "setSeconds", (Object)new SetSeconds(globalObject));
        this.defineNonEnumerableProperty(proto, "setUTCSeconds", (Object)new SetUTCSeconds(globalObject));
        this.defineNonEnumerableProperty(proto, "setMinutes", (Object)new SetMinutes(globalObject));
        this.defineNonEnumerableProperty(proto, "setUTCMinutes", (Object)new SetUTCMinutes(globalObject));
        this.defineNonEnumerableProperty(proto, "setHours", (Object)new SetHours(globalObject));
        this.defineNonEnumerableProperty(proto, "setUTCHours", (Object)new SetUTCHours(globalObject));
        this.defineNonEnumerableProperty(proto, "setDate", (Object)new SetDate(globalObject));
        this.defineNonEnumerableProperty(proto, "getDate", (Object)new GetDate(globalObject));
        this.defineNonEnumerableProperty(proto, "setUTCDate", (Object)new SetUTCDate(globalObject));
        this.defineNonEnumerableProperty(proto, "getUTCDate", (Object)new GetUTCDate(globalObject));
        this.defineNonEnumerableProperty(proto, "setMonth", (Object)new SetMonth(globalObject));
        this.defineNonEnumerableProperty(proto, "setUTCMonth", (Object)new SetUTCMonth(globalObject));
        this.defineNonEnumerableProperty(proto, "setFullYear", (Object)new SetFullYear(globalObject));
        this.defineNonEnumerableProperty(proto, "setUTCFullYear", (Object)new SetUTCFullYear(globalObject));
        this.defineNonEnumerableProperty(proto, "toJSON", (Object)new ToJSON(globalObject));
        this.defineNonEnumerableProperty(proto, "getYear", (Object)new GetYear(globalObject));
        this.defineNonEnumerableProperty(proto, "setYear", (Object)new SetYear(globalObject));
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... args) {
        if (self == Types.UNDEFINED || self == Types.NULL) {
            DynDate now = new DynDate(context.getGlobalObject());
            JSFunction toString = (JSFunction)now.get(context, "toString");
            return context.call(toString, now, new Object[0]);
        }
        Arguments argsObj = (Arguments)context.resolve("arguments").getValue(context);
        int numArgs = (Integer)argsObj.get(context, "length");
        DynDate date = (DynDate)self;
        if (numArgs == 0) {
            date.setTimeValue(context.getClock().currentTimeMillis());
        } else if (numArgs == 1) {
            Object v = Types.toPrimitive(context, args[0]);
            if (v instanceof String) {
                date.setTimeValue(AbstractDateFunction.timeClip(context, Parse.parse(context, (String)v)));
            } else {
                date.setTimeValue(AbstractDateFunction.timeClip(context, Types.toNumber(context, v)));
            }
        } else {
            long longYr;
            Number y = Types.toNumber(context, args[0]);
            Number m = Types.toNumber(context, args[1]);
            Number dt = 1;
            Number h = 0;
            Number min = 0;
            Number s = 0;
            Number milli = 0;
            if (numArgs >= 3) {
                dt = Types.toNumber(context, args[2]);
            }
            if (numArgs >= 4) {
                h = Types.toNumber(context, args[3]);
            }
            if (numArgs >= 5) {
                min = Types.toNumber(context, args[4]);
            }
            if (numArgs >= 6) {
                s = Types.toNumber(context, args[5]);
            }
            if (numArgs >= 7) {
                milli = Types.toNumber(context, args[6]);
            }
            Number yr = y;
            if (!Double.isNaN(y.doubleValue()) && (longYr = yr.longValue()) >= 0L && longYr <= 99L) {
                yr = longYr + 1900L;
            }
            Number finalDate = AbstractDateFunction.makeDate(context, AbstractDateFunction.makeDay(context, yr, m, dt), AbstractDateFunction.makeTime(context, h, min, s, milli));
            Number clipped = AbstractDateFunction.timeClip(context, AbstractDateFunction.utc(context, finalDate));
            date.setTimeValue(clipped);
        }
        return date;
    }

    @Override
    public void setFileName() {
        this.filename = "org/dynjs/runtime/builtins/types/BuiltinDate.java";
    }

    @Override
    public void setupDebugContext() {
        this.debugContext = "<native function: Date>";
    }
}

