/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins.types;

import org.dynjs.runtime.Arguments;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.PrimitiveDynObject;
import org.dynjs.runtime.PropertyDescriptor;
import org.dynjs.runtime.Types;
import org.dynjs.runtime.builtins.types.AbstractBuiltinType;
import org.dynjs.runtime.builtins.types.number.DynNumber;
import org.dynjs.runtime.builtins.types.number.prototype.ToExponential;
import org.dynjs.runtime.builtins.types.number.prototype.ToFixed;
import org.dynjs.runtime.builtins.types.number.prototype.ToPrecision;
import org.dynjs.runtime.builtins.types.number.prototype.ToString;
import org.dynjs.runtime.builtins.types.number.prototype.ValueOf;

public class BuiltinNumber
extends AbstractBuiltinType {
    public BuiltinNumber(GlobalObject globalObject) {
        super(globalObject, "value");
        DynNumber proto = new DynNumber(globalObject, 0L);
        this.setPrototypeProperty(proto);
    }

    @Override
    public void initialize(GlobalObject globalObject, JSObject proto) {
        proto.setPrototype(globalObject.getPrototypeFor("Object"));
        this.defineNonEnumerableProperty(proto, "constructor", (Object)this);
        this.defineNonEnumerableProperty(proto, "toString", (Object)new ToString(globalObject));
        this.defineNonEnumerableProperty(proto, "toLocaleString", (Object)new ToString(globalObject));
        this.defineNonEnumerableProperty(proto, "valueOf", (Object)new ValueOf(globalObject));
        this.defineNonEnumerableProperty(proto, "toFixed", (Object)new ToFixed(globalObject));
        this.defineNonEnumerableProperty(proto, "toExponential", (Object)new ToExponential(globalObject));
        this.defineNonEnumerableProperty(proto, "toPrecision", (Object)new ToPrecision(globalObject));
        BuiltinNumber.defineReadOnlyProperty(this, globalObject, "NaN", Double.NaN);
        BuiltinNumber.defineReadOnlyProperty(this, globalObject, "POSITIVE_INFINITY", Double.POSITIVE_INFINITY);
        BuiltinNumber.defineReadOnlyProperty(this, globalObject, "NEGATIVE_INFINITY", Double.NEGATIVE_INFINITY);
        BuiltinNumber.defineReadOnlyProperty(this, globalObject, "MIN_VALUE", Double.MIN_VALUE);
        BuiltinNumber.defineReadOnlyProperty(this, globalObject, "MAX_VALUE", Double.MAX_VALUE);
        BuiltinNumber.defineReadOnlyProperty(globalObject, globalObject, "NaN", Double.NaN);
        BuiltinNumber.defineReadOnlyProperty(globalObject, globalObject, "Infinity", Double.POSITIVE_INFINITY);
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... args) {
        Number number = 0L;
        Arguments argsObj = (Arguments)context.resolve("arguments").getValue(context);
        int numArgs = (Integer)argsObj.get(context, "length");
        if (numArgs != 0) {
            number = Types.toNumber(context, args[0]);
        }
        if (self == Types.UNDEFINED || self == Types.NULL) {
            return number;
        }
        PrimitiveDynObject numberObject = (PrimitiveDynObject)self;
        if (numArgs == 0) {
            number = 0L;
        }
        numberObject.setPrimitiveValue(number);
        return numberObject;
    }

    @Override
    public JSObject createNewObject(ExecutionContext context) {
        return new DynNumber(context.getGlobalObject());
    }

    protected static void defineReadOnlyProperty(JSObject on, GlobalObject globalObject, String name, Number value) {
        PropertyDescriptor desc = new PropertyDescriptor();
        desc.set((byte)0, value);
        desc.set((byte)3, false);
        desc.set((byte)5, false);
        desc.set((byte)4, false);
        on.defineOwnProperty(null, name, desc, false);
    }

    protected static void defineReadOnlyFunction(JSObject on, GlobalObject globalObject, String name, Object value) {
        PropertyDescriptor desc = new PropertyDescriptor();
        desc.set((byte)0, value);
        desc.set((byte)3, false);
        desc.set((byte)5, false);
        desc.set((byte)4, false);
        on.defineOwnProperty(null, name, desc, false);
    }

    public static Number modulo(Number a, Number b) {
        double remainder = a.doubleValue() % b.doubleValue();
        if (remainder == 0.0 && Double.compare(a.doubleValue(), 0.0) < 0) {
            return -0.0;
        }
        if (remainder == (double)((long)remainder)) {
            return (long)remainder;
        }
        return remainder;
    }
}

