/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins.types;

import org.dynjs.runtime.DynObject;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.Types;
import org.dynjs.runtime.builtins.types.AbstractBuiltinType;
import org.dynjs.runtime.builtins.types.object.Create;
import org.dynjs.runtime.builtins.types.object.DefineProperties;
import org.dynjs.runtime.builtins.types.object.DefineProperty;
import org.dynjs.runtime.builtins.types.object.Freeze;
import org.dynjs.runtime.builtins.types.object.GetOwnPropertyDescriptor;
import org.dynjs.runtime.builtins.types.object.GetOwnPropertyNames;
import org.dynjs.runtime.builtins.types.object.GetPrototypeOf;
import org.dynjs.runtime.builtins.types.object.IsExtensible;
import org.dynjs.runtime.builtins.types.object.IsFrozen;
import org.dynjs.runtime.builtins.types.object.IsSealed;
import org.dynjs.runtime.builtins.types.object.Keys;
import org.dynjs.runtime.builtins.types.object.PreventExtensions;
import org.dynjs.runtime.builtins.types.object.Seal;
import org.dynjs.runtime.builtins.types.object.prototype.HasOwnProperty;
import org.dynjs.runtime.builtins.types.object.prototype.IsPrototypeOf;
import org.dynjs.runtime.builtins.types.object.prototype.PropertyIsEnumerable;
import org.dynjs.runtime.builtins.types.object.prototype.ToLocaleString;
import org.dynjs.runtime.builtins.types.object.prototype.ToString;
import org.dynjs.runtime.builtins.types.object.prototype.ValueOf;
import org.dynjs.runtime.builtins.types.object.prototype.rhino.DefineGetter;
import org.dynjs.runtime.builtins.types.object.prototype.rhino.DefineSetter;
import org.dynjs.runtime.builtins.types.object.prototype.rhino.LookupGetter;
import org.dynjs.runtime.builtins.types.object.prototype.rhino.LookupSetter;

public class BuiltinObject
extends AbstractBuiltinType {
    public BuiltinObject(GlobalObject globalObject) {
        super(globalObject, "value");
        DynObject proto = new DynObject(globalObject);
        this.setPrototypeProperty(proto);
    }

    @Override
    public void initialize(GlobalObject globalObject, JSObject proto) {
        this.defineNonEnumerableProperty(proto, "constructor", (Object)this);
        this.defineNonEnumerableProperty(proto, "toString", (Object)new ToString(globalObject));
        this.defineNonEnumerableProperty(proto, "toLocaleString", (Object)new ToLocaleString(globalObject));
        this.defineNonEnumerableProperty(proto, "hasOwnProperty", (Object)new HasOwnProperty(globalObject));
        this.defineNonEnumerableProperty(proto, "isPrototypeOf", (Object)new IsPrototypeOf(globalObject));
        this.defineNonEnumerableProperty(proto, "propertyIsEnumerable", (Object)new PropertyIsEnumerable(globalObject));
        this.defineNonEnumerableProperty(proto, "valueOf", (Object)new ValueOf(globalObject));
        if (globalObject.getConfig().isRhinoCompatible()) {
            this.defineNonEnumerableProperty(proto, "__defineGetter__", (Object)new DefineGetter(globalObject));
            this.defineNonEnumerableProperty(proto, "__defineSetter__", (Object)new DefineSetter(globalObject));
            this.defineNonEnumerableProperty(proto, "__lookupGetter__", (Object)new LookupGetter(globalObject));
            this.defineNonEnumerableProperty(proto, "__lookupSetter__", (Object)new LookupSetter(globalObject));
        }
        this.defineNonEnumerableProperty(this, "getPrototypeOf", (Object)new GetPrototypeOf(globalObject));
        this.defineNonEnumerableProperty(this, "getOwnPropertyDescriptor", (Object)new GetOwnPropertyDescriptor(globalObject));
        this.defineNonEnumerableProperty(this, "getOwnPropertyNames", (Object)new GetOwnPropertyNames(globalObject));
        this.defineNonEnumerableProperty(this, "create", (Object)new Create(globalObject));
        this.defineNonEnumerableProperty(this, "defineProperty", (Object)new DefineProperty(globalObject));
        this.defineNonEnumerableProperty(this, "defineProperties", (Object)new DefineProperties(globalObject));
        this.defineNonEnumerableProperty(this, "seal", (Object)new Seal(globalObject));
        this.defineNonEnumerableProperty(this, "freeze", (Object)new Freeze(globalObject));
        this.defineNonEnumerableProperty(this, "preventExtensions", (Object)new PreventExtensions(globalObject));
        this.defineNonEnumerableProperty(this, "isSealed", (Object)new IsSealed(globalObject));
        this.defineNonEnumerableProperty(this, "isFrozen", (Object)new IsFrozen(globalObject));
        this.defineNonEnumerableProperty(this, "isExtensible", (Object)new IsExtensible(globalObject));
        this.defineNonEnumerableProperty(this, "keys", (Object)new Keys(globalObject));
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... args) {
        if (args[0] != Types.UNDEFINED) {
            if (args[0] instanceof JSObject) {
                return args[0];
            }
            if (args[0] instanceof String || args[0] instanceof Boolean || args[0] instanceof Number) {
                JSObject result = Types.toObject(context, args[0]);
                return result;
            }
        }
        return new DynObject(context.getGlobalObject());
    }

    public static DynObject newObject(ExecutionContext context) {
        BuiltinObject ctor = (BuiltinObject)context.getGlobalObject().get(context, "__Builtin_Object");
        return (DynObject)context.construct(ctor, new Object[0]);
    }

    @Override
    public void setFileName() {
        this.filename = "org/dynjs/runtime/builtins/types/BuiltinObject.java";
    }

    @Override
    public void setupDebugContext() {
        this.debugContext = "<native function: Object>";
    }
}

