/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins.types.array.prototype;

import org.dynjs.runtime.AbstractNativeFunction;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.Types;

public class LastIndexOf
extends AbstractNativeFunction {
    public LastIndexOf(GlobalObject globalObject) {
        super(globalObject, "searchElement");
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... args) {
        JSObject o = Types.toObject(context, self);
        long len = Types.toUint32(context, o.get(context, "length"));
        if (len == 0L) {
            return -1L;
        }
        long n = len;
        if (args.length >= 2) {
            n = args[1] != Types.UNDEFINED ? Types.toInteger(context, args[1]) : 0L;
        }
        long k = Math.min(n, len - 1L);
        if (n < 0L) {
            k = len - Math.abs(n);
        }
        while (k >= 0L) {
            Object element;
            if (o.hasProperty(context, "" + k) && Types.compareStrictEquality(context, args[0], element = o.get(context, "" + k))) {
                return k;
            }
            --k;
        }
        return -1L;
    }

    @Override
    public void setFileName() {
        this.filename = "org/dynjs/runtime/builtins/types/array/prototype/LastIndexOf.java";
    }

    @Override
    public void setupDebugContext() {
        this.debugContext = "<native function: lastIndexOf>";
    }
}

