/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins.types.date;

import org.dynjs.runtime.Arguments;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.Types;
import org.dynjs.runtime.builtins.types.date.AbstractDateFunction;

public class UTC
extends AbstractDateFunction {
    public UTC(GlobalObject globalObject) {
        super(globalObject, "year", "month", "date", "hours", "minutes", "seconds", "ms");
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... args) {
        Number y = Types.toNumber(context, args[0]);
        Number m = Types.toNumber(context, args[1]);
        Number dt = 1;
        Number h = 0;
        Number min = 0;
        Number s = 0;
        Number milli = 0;
        Arguments argsObj = (Arguments)context.resolve("arguments").getValue(context);
        int numArgs = (Integer)argsObj.get(context, "length");
        if (numArgs >= 3) {
            dt = Types.toNumber(context, args[2]);
        }
        if (numArgs >= 4) {
            h = Types.toNumber(context, args[3]);
        }
        if (numArgs >= 5) {
            min = Types.toNumber(context, args[4]);
        }
        if (numArgs >= 6) {
            s = Types.toNumber(context, args[5]);
        }
        if (numArgs >= 7) {
            milli = Types.toNumber(context, args[6]);
        }
        Number yr = y;
        if (!Double.isNaN(y.doubleValue())) {
            long longYr = yr.longValue();
            yr = Types.toInteger(context, y);
            if (longYr >= 0L && longYr <= 99L) {
                yr = longYr + 1900L;
            }
        }
        Number finalDate = UTC.makeDate(context, UTC.makeDay(context, yr, m, dt), UTC.makeTime(context, h, min, s, milli));
        Number clipped = UTC.timeClip(context, UTC.utc(context, finalDate));
        return clipped;
    }

    @Override
    public void setFileName() {
        this.filename = "org/dynjs/runtime/builtins/types/date/UTC.java";
    }

    @Override
    public void setupDebugContext() {
        this.debugContext = "<native function: utc>";
    }
}

