/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins.types.json;

import java.io.IOException;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.dynjs.exception.ThrowException;
import org.dynjs.runtime.AbstractNativeFunction;
import org.dynjs.runtime.DynArray;
import org.dynjs.runtime.DynObject;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.JSFunction;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.NameEnumerator;
import org.dynjs.runtime.Types;
import org.dynjs.runtime.builtins.types.BuiltinArray;
import org.dynjs.runtime.builtins.types.BuiltinObject;

public class Parse
extends AbstractNativeFunction {
    public Parse(GlobalObject globalObject) {
        super(globalObject, true, "text", "reviver");
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... args) {
        String jsonText = Types.toString(context, args[0]);
        JsonFactory factory = new JsonFactory();
        Object unfiltered = null;
        try {
            JsonParser parser = factory.createJsonParser(jsonText);
            parser.nextToken();
            unfiltered = this.parse(context, parser);
            if (parser.nextToken() != null) {
                throw new ThrowException(context, context.createSyntaxError("unexpected token"));
            }
        }
        catch (IOException e) {
            JSObject error = context.createSyntaxError(e.getMessage());
            throw new ThrowException(context, error);
        }
        Object reviver = args[1];
        if (!Types.isCallable(reviver)) {
            return unfiltered;
        }
        DynObject root = BuiltinObject.newObject(context);
        root.put(context, "", unfiltered, false);
        Object result = this.walk(context, (JSFunction)reviver, root, "");
        return result;
    }

    protected Object walk(ExecutionContext context, JSFunction reviver, JSObject holder, String name) {
        Object val;
        block6: {
            val = holder.get(context, name);
            if (!(val instanceof JSObject)) break block6;
            JSObject jsVal = (JSObject)val;
            if (jsVal.getClassName().equals("Array")) {
                long len = Types.toInteger(context, jsVal.get(context, "length"));
                for (long i = 0L; i < len; ++i) {
                    Object newElement = this.walk(context, reviver, jsVal, "" + i);
                    if (newElement == Types.UNDEFINED) {
                        jsVal.delete(context, "" + i, false);
                        continue;
                    }
                    jsVal.put(context, "" + i, newElement, false);
                }
            } else {
                NameEnumerator keys = jsVal.getOwnPropertyNames();
                while (keys.hasNext()) {
                    String key = keys.next();
                    Object newElement = this.walk(context, reviver, jsVal, key);
                    if (newElement == Types.UNDEFINED) {
                        jsVal.delete(context, key, false);
                        continue;
                    }
                    jsVal.put(context, key, newElement, false);
                }
            }
        }
        return context.call(reviver, holder, name, val);
    }

    protected Object parse(ExecutionContext context, JsonParser p) throws JsonParseException, IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.START_ARRAY) {
            return this.parseArray(context, p);
        }
        if (t == JsonToken.START_OBJECT) {
            return this.parseObject(context, p);
        }
        return this.parseValue(context, p);
    }

    protected Object parseArray(ExecutionContext context, JsonParser p) throws JsonParseException, IOException {
        DynArray array = BuiltinArray.newArray(context);
        int i = 0;
        while (p.nextToken() != JsonToken.END_ARRAY) {
            Object value = this.parse(context, p);
            array.put(context, "" + i, value, false);
            ++i;
        }
        return array;
    }

    protected Object parseObject(ExecutionContext context, JsonParser p) throws JsonParseException, IOException {
        DynObject obj = BuiltinObject.newObject(context);
        while (p.nextToken() != JsonToken.END_OBJECT) {
            String name = p.getCurrentName();
            Object value = this.parse(context, p);
            obj.put(context, name, value, false);
        }
        return obj;
    }

    protected Object parseValue(ExecutionContext context, JsonParser p) throws JsonParseException, IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        if (t == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (t == JsonToken.VALUE_NULL) {
            return Types.NULL;
        }
        if (t == JsonToken.VALUE_STRING) {
            return p.getText();
        }
        if (t == JsonToken.VALUE_NUMBER_FLOAT) {
            return p.getDoubleValue();
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return p.getIntValue();
        }
        return Types.NULL;
    }
}

