/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins.types.number.prototype;

import java.math.BigDecimal;
import org.dynjs.exception.ThrowException;
import org.dynjs.runtime.AbstractNativeFunction;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.Types;

public class ToFixed
extends AbstractNativeFunction {
    public ToFixed(GlobalObject globalObject) {
        super(globalObject, "fractionDigits");
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... args) {
        if (args.length > 1) {
            return Types.UNDEFINED;
        }
        long digits = Types.toInteger(context, args[0]);
        if (digits < 0L || digits > 20L) {
            throw new ThrowException(context, context.createRangeError("Number.prototype.toFixed() digits argument must be between 0 and 20"));
        }
        Number number = Types.toNumber(context, self);
        if (Double.isInfinite(number.doubleValue()) || Double.isNaN(number.doubleValue())) {
            return String.valueOf(number);
        }
        if (number.doubleValue() < 1.0E21) {
            BigDecimal bigDecimal = new BigDecimal(number.doubleValue());
            return bigDecimal.setScale((int)digits, 4).toString();
        }
        return Types.rewritePossiblyExponentialValue(String.valueOf(number.doubleValue()));
    }
}

