/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins.types.number.prototype;

import java.math.BigDecimal;
import java.math.MathContext;
import org.dynjs.exception.ThrowException;
import org.dynjs.runtime.AbstractNativeFunction;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.Types;

public class ToPrecision
extends AbstractNativeFunction {
    public ToPrecision(GlobalObject globalObject) {
        super(globalObject, "precision");
    }

    @Override
    public Object call(ExecutionContext context, Object self, Object ... args) {
        if (args[0] == Types.UNDEFINED) {
            return Types.toString(context, self);
        }
        Number number = Types.toNumber(context, self);
        Long precision = Types.toInteger(context, args[0]);
        if (Double.isNaN(number.doubleValue()) || Double.isInfinite(number.doubleValue())) {
            return String.valueOf(number);
        }
        if (precision < 1L || precision > 21L) {
            throw new ThrowException(context, context.createRangeError("Number.prototype.toPrecision() [precision] must be between 0 and 20"));
        }
        return new BigDecimal(number.doubleValue(), new MathContext(precision.intValue())).toString();
    }
}

