/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.builtins.types.regexp;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.dynjs.exception.ThrowException;
import org.dynjs.runtime.DynObject;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.GlobalObject;
import org.dynjs.runtime.PropertyDescriptor;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.WarnCallback;
import org.joni.exception.JOniException;

public class DynRegExp
extends DynObject {
    private Regex pattern;

    public DynRegExp(GlobalObject globalObject) {
        super(globalObject);
        this.setClassName("RegExp");
        this.setPrototype(globalObject.getPrototypeFor("RegExp"));
    }

    public DynRegExp(GlobalObject globalObject, String pattern, String flags) {
        this(globalObject);
        this.setPatternAndFlags(null, pattern, flags);
    }

    public void setPatternAndFlags(ExecutionContext context, String pattern, String flags) {
        PropertyDescriptor ignoreCaseDesc;
        PropertyDescriptor globalDesc;
        PropertyDescriptor multilineDesc;
        this.checkSyntaxOfFlags(context, flags);
        PropertyDescriptor sourceDesc = new PropertyDescriptor();
        if (pattern.equals("")) {
            pattern = "(?:)";
        }
        sourceDesc.set((byte)0, pattern);
        sourceDesc.set((byte)3, false);
        sourceDesc.set((byte)4, false);
        sourceDesc.set((byte)5, false);
        this.defineOwnProperty(null, "source", sourceDesc, false);
        if (flags != null) {
            multilineDesc = new PropertyDescriptor();
            multilineDesc.set((byte)0, flags.contains("m"));
            multilineDesc.set((byte)3, false);
            multilineDesc.set((byte)4, false);
            multilineDesc.set((byte)5, false);
            this.defineOwnProperty(null, "multiline", multilineDesc, false);
            globalDesc = new PropertyDescriptor();
            globalDesc.set((byte)0, flags.contains("g"));
            globalDesc.set((byte)3, false);
            globalDesc.set((byte)4, false);
            globalDesc.set((byte)5, false);
            this.defineOwnProperty(null, "global", globalDesc, false);
            ignoreCaseDesc = new PropertyDescriptor();
            ignoreCaseDesc.set((byte)0, flags.contains("i"));
            ignoreCaseDesc.set((byte)3, false);
            ignoreCaseDesc.set((byte)4, false);
            ignoreCaseDesc.set((byte)5, false);
            this.defineOwnProperty(null, "ignoreCase", ignoreCaseDesc, false);
        } else {
            multilineDesc = new PropertyDescriptor();
            multilineDesc.set((byte)0, false);
            multilineDesc.set((byte)3, false);
            multilineDesc.set((byte)4, false);
            multilineDesc.set((byte)5, false);
            this.defineOwnProperty(null, "multiline", multilineDesc, false);
            globalDesc = new PropertyDescriptor();
            globalDesc.set((byte)0, false);
            globalDesc.set((byte)3, false);
            globalDesc.set((byte)4, false);
            globalDesc.set((byte)5, false);
            this.defineOwnProperty(null, "global", globalDesc, false);
            ignoreCaseDesc = new PropertyDescriptor();
            ignoreCaseDesc.set((byte)0, false);
            ignoreCaseDesc.set((byte)3, false);
            ignoreCaseDesc.set((byte)4, false);
            ignoreCaseDesc.set((byte)5, false);
            this.defineOwnProperty(null, "ignoreCase", ignoreCaseDesc, false);
        }
        PropertyDescriptor lastIndexDesc = new PropertyDescriptor();
        lastIndexDesc.set((byte)0, 0L);
        lastIndexDesc.set((byte)3, true);
        lastIndexDesc.set((byte)4, false);
        lastIndexDesc.set((byte)5, false);
        this.defineOwnProperty(null, "lastIndex", lastIndexDesc, false);
        int flagsInt = 0;
        flagsInt = this.get(context, "multiline") == Boolean.TRUE ? (flagsInt |= 4) : (flagsInt |= 8);
        if (this.get(context, "ignoreCase") == Boolean.TRUE) {
            flagsInt |= 1;
        }
        try {
            Charset charset = Charset.forName("UTF-8");
            CharsetEncoder encoder = charset.newEncoder();
            encoder.onMalformedInput(CodingErrorAction.REPLACE);
            encoder.replaceWith(new byte[]{1});
            ByteBuffer patternBuffer = encoder.encode(CharBuffer.wrap(pattern));
            byte[] patternBytes = new byte[patternBuffer.limit()];
            patternBuffer.get(patternBytes, 0, patternBytes.length);
            this.pattern = new Regex(patternBytes, 0, patternBytes.length, flagsInt, (Encoding)UTF8Encoding.INSTANCE, Syntax.ECMAScript, new WarnCallback(){

                public void warn(String message) {
                    System.err.println("WARN: " + message);
                }
            });
        }
        catch (JOniException e) {
            throw new ThrowException(context, context.createSyntaxError(e.getMessage()));
        }
        catch (CharacterCodingException e) {
            throw new ThrowException(context, context.createSyntaxError(e.getMessage()));
        }
    }

    private void checkSyntaxOfFlags(ExecutionContext context, String flags) {
        if (flags == null || flags.equals("")) {
            return;
        }
        block3: for (int i = 0; i < flags.length(); ++i) {
            switch (flags.charAt(i)) {
                case 'g': 
                case 'i': 
                case 'm': {
                    continue block3;
                }
                default: {
                    throw new ThrowException(context, context.createSyntaxError("invalid flag '" + flags.charAt(i) + "'"));
                }
            }
        }
        int index = -1;
        index = flags.indexOf(109);
        if (index >= 0 && flags.indexOf(109, index + 1) >= 0) {
            throw new ThrowException(context, context.createSyntaxError("'m' flag specified more than once"));
        }
        index = flags.indexOf(105);
        if (index >= 0 && flags.indexOf(105, index + 1) >= 0) {
            throw new ThrowException(context, context.createSyntaxError("'i' flag specified more than once"));
        }
        index = flags.indexOf(103);
        if (index >= 0 && flags.indexOf(103, index + 1) >= 0) {
            throw new ThrowException(context, context.createSyntaxError("'g' flag specified more than once"));
        }
    }

    public Region match(String str, int from) {
        byte[] strBytes = str.getBytes();
        Matcher matcher = this.pattern.matcher(strBytes, 0, strBytes.length);
        if (matcher.search(from, strBytes.length, 0) >= 0) {
            return matcher.getEagerRegion();
        }
        return null;
    }

    public boolean isGlobal() {
        return (Boolean)this.get(null, "global");
    }
}

