/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.interp;

import java.util.ArrayList;
import java.util.List;
import org.dynjs.exception.ThrowException;
import org.dynjs.parser.Statement;
import org.dynjs.parser.ast.AdditiveExpression;
import org.dynjs.parser.ast.ArrayLiteralExpression;
import org.dynjs.parser.ast.AssignmentExpression;
import org.dynjs.parser.ast.BitwiseExpression;
import org.dynjs.parser.ast.BitwiseInversionOperatorExpression;
import org.dynjs.parser.ast.BlockStatement;
import org.dynjs.parser.ast.BooleanLiteralExpression;
import org.dynjs.parser.ast.BracketExpression;
import org.dynjs.parser.ast.BreakStatement;
import org.dynjs.parser.ast.CaseClause;
import org.dynjs.parser.ast.CatchClause;
import org.dynjs.parser.ast.CommaOperator;
import org.dynjs.parser.ast.CompoundAssignmentExpression;
import org.dynjs.parser.ast.ContinueStatement;
import org.dynjs.parser.ast.DefaultCaseClause;
import org.dynjs.parser.ast.DeleteOpExpression;
import org.dynjs.parser.ast.DoWhileStatement;
import org.dynjs.parser.ast.DotExpression;
import org.dynjs.parser.ast.EmptyStatement;
import org.dynjs.parser.ast.EqualityOperatorExpression;
import org.dynjs.parser.ast.Expression;
import org.dynjs.parser.ast.ExpressionStatement;
import org.dynjs.parser.ast.ForExprInStatement;
import org.dynjs.parser.ast.ForExprStatement;
import org.dynjs.parser.ast.ForVarDeclInStatement;
import org.dynjs.parser.ast.ForVarDeclStatement;
import org.dynjs.parser.ast.FunctionCallExpression;
import org.dynjs.parser.ast.FunctionDeclaration;
import org.dynjs.parser.ast.FunctionExpression;
import org.dynjs.parser.ast.IdentifierReferenceExpression;
import org.dynjs.parser.ast.IfStatement;
import org.dynjs.parser.ast.InOperatorExpression;
import org.dynjs.parser.ast.InstanceofExpression;
import org.dynjs.parser.ast.LogicalExpression;
import org.dynjs.parser.ast.LogicalNotOperatorExpression;
import org.dynjs.parser.ast.MultiplicativeExpression;
import org.dynjs.parser.ast.NamedValue;
import org.dynjs.parser.ast.NewOperatorExpression;
import org.dynjs.parser.ast.NullLiteralExpression;
import org.dynjs.parser.ast.NumberLiteralExpression;
import org.dynjs.parser.ast.ObjectLiteralExpression;
import org.dynjs.parser.ast.PostOpExpression;
import org.dynjs.parser.ast.PreOpExpression;
import org.dynjs.parser.ast.PropertyAssignment;
import org.dynjs.parser.ast.PropertyGet;
import org.dynjs.parser.ast.PropertySet;
import org.dynjs.parser.ast.RegexpLiteralExpression;
import org.dynjs.parser.ast.RelationalExpression;
import org.dynjs.parser.ast.ReturnStatement;
import org.dynjs.parser.ast.StrictEqualityOperatorExpression;
import org.dynjs.parser.ast.StringLiteralExpression;
import org.dynjs.parser.ast.SwitchStatement;
import org.dynjs.parser.ast.TernaryExpression;
import org.dynjs.parser.ast.ThisExpression;
import org.dynjs.parser.ast.ThrowStatement;
import org.dynjs.parser.ast.TryStatement;
import org.dynjs.parser.ast.TypeOfOpExpression;
import org.dynjs.parser.ast.UnaryMinusExpression;
import org.dynjs.parser.ast.UnaryPlusExpression;
import org.dynjs.parser.ast.VariableDeclaration;
import org.dynjs.parser.ast.VariableStatement;
import org.dynjs.parser.ast.VoidOperatorExpression;
import org.dynjs.parser.ast.WhileStatement;
import org.dynjs.parser.ast.WithStatement;
import org.dynjs.parser.js.Position;
import org.dynjs.runtime.BasicBlock;
import org.dynjs.runtime.BlockManager;
import org.dynjs.runtime.Completion;
import org.dynjs.runtime.DynArray;
import org.dynjs.runtime.DynObject;
import org.dynjs.runtime.EnvironmentRecord;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.JSFunction;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.PropertyDescriptor;
import org.dynjs.runtime.Reference;
import org.dynjs.runtime.Types;
import org.dynjs.runtime.builtins.types.BuiltinArray;
import org.dynjs.runtime.builtins.types.BuiltinNumber;
import org.dynjs.runtime.builtins.types.BuiltinObject;
import org.dynjs.runtime.builtins.types.BuiltinRegExp;
import org.dynjs.runtime.interp.InterpretingVisitor;

public class BasicInterpretingVisitor
implements InterpretingVisitor {
    private List<Object> stack = new ArrayList<Object>();
    private BlockManager blockManager;

    public BasicInterpretingVisitor(BlockManager blockManager) {
        this.blockManager = blockManager;
    }

    public void push(Object value) {
        if (value == null) {
            new Exception().printStackTrace();
        }
        this.stack.add(value);
    }

    @Override
    public Object pop() {
        return this.stack.remove(this.stack.size() - 1);
    }

    @Override
    public void visit(ExecutionContext context, AdditiveExpression expr, boolean strict) {
        if (expr.getOp().equals("+")) {
            this.visitPlus(context, expr, strict);
        } else {
            this.visitMinus(context, expr, strict);
        }
    }

    public void visitPlus(ExecutionContext context, AdditiveExpression expr, boolean strict) {
        expr.getLhs().accept(context, this, strict);
        Object lhs = Types.toPrimitive(context, this.getValue(context, this.pop()));
        expr.getRhs().accept(context, this, strict);
        Object rhs = Types.toPrimitive(context, this.getValue(context, this.pop()));
        if (lhs instanceof String || rhs instanceof String) {
            this.push(Types.toString(context, lhs) + Types.toString(context, rhs));
            return;
        }
        Number lhsNum = Types.toNumber(context, lhs);
        Number rhsNum = Types.toNumber(context, rhs);
        if (Double.isNaN(lhsNum.doubleValue()) || Double.isNaN(rhsNum.doubleValue())) {
            this.push(Double.NaN);
            return;
        }
        if (lhsNum instanceof Double || rhsNum instanceof Double) {
            if (lhsNum.doubleValue() == 0.0 && rhsNum.doubleValue() == 0.0) {
                if (Double.compare(lhsNum.doubleValue(), 0.0) < 0 && Double.compare(rhsNum.doubleValue(), 0.0) < 0) {
                    this.push(-0.0);
                    return;
                }
                this.push(0.0);
                return;
            }
            this.push(lhsNum.doubleValue() + rhsNum.doubleValue());
            return;
        }
        this.push(lhsNum.longValue() + rhsNum.longValue());
    }

    public void visitMinus(ExecutionContext context, AdditiveExpression expr, boolean strict) {
        expr.getLhs().accept(context, this, strict);
        Number lhs = Types.toNumber(context, this.getValue(context, this.pop()));
        expr.getRhs().accept(context, this, strict);
        Number rhs = Types.toNumber(context, this.getValue(context, this.pop()));
        if (Double.isNaN(lhs.doubleValue()) || Double.isNaN(rhs.doubleValue())) {
            this.push(Double.NaN);
            return;
        }
        if (lhs instanceof Double || rhs instanceof Double) {
            if (lhs.doubleValue() == 0.0 && rhs.doubleValue() == 0.0 && Double.compare(lhs.doubleValue(), 0.0) < 0 && Double.compare(rhs.doubleValue(), 0.0) < 0) {
                this.push(0.0);
                return;
            }
            this.push(lhs.doubleValue() - rhs.doubleValue());
            return;
        }
        this.push(lhs.longValue() - rhs.longValue());
    }

    @Override
    public void visit(ExecutionContext context, BitwiseExpression expr, boolean strict) {
        expr.getLhs().accept(context, this, strict);
        Object lhs = this.getValue(context, this.pop());
        Long lhsNum = null;
        lhsNum = expr.getOp().equals(">>>") ? Types.toUint32(context, lhs) : Types.toInt32(context, lhs);
        expr.getRhs().accept(context, this, strict);
        if (expr.getOp().equals("<<")) {
            Long rhsNum = Types.toUint32(context, this.getValue(context, this.pop()));
            int shiftCount = rhsNum.intValue() & 0x1F;
            this.push((int)(lhsNum << shiftCount));
        } else if (expr.getOp().equals(">>")) {
            Long rhsNum = Types.toUint32(context, this.getValue(context, this.pop()));
            int shiftCount = rhsNum.intValue() & 0x1F;
            this.push((int)(lhsNum >> shiftCount));
        } else if (expr.getOp().equals(">>>")) {
            Long rhsNum = Types.toUint32(context, this.getValue(context, this.pop()));
            int shiftCount = rhsNum.intValue() & 0x1F;
            this.push(lhsNum >>> shiftCount);
        } else if (expr.getOp().equals("&")) {
            Long rhsNum = Types.toInt32(context, this.getValue(context, this.pop()));
            this.push(lhsNum & rhsNum);
        } else if (expr.getOp().equals("|")) {
            Long rhsNum = Types.toInt32(context, this.getValue(context, this.pop()));
            this.push(lhsNum | rhsNum);
        } else if (expr.getOp().equals("^")) {
            Long rhsNum = Types.toInt32(context, this.getValue(context, this.pop()));
            this.push(lhsNum ^ rhsNum);
        }
    }

    @Override
    public void visit(ExecutionContext context, ArrayLiteralExpression expr, boolean strict) {
        DynArray array = BuiltinArray.newArray(context);
        int i = 0;
        for (Expression each : expr.getExprs()) {
            Object value = null;
            if (each != null) {
                each.accept(context, this, strict);
                value = this.getValue(context, this.pop());
                array.defineOwnProperty(context, "" + i, PropertyDescriptor.newPropertyDescriptorForObjectInitializer(value), false);
            }
            ++i;
        }
        array.put(context, "length", i, true);
        this.push(array);
    }

    @Override
    public void visit(ExecutionContext context, AssignmentExpression expr, boolean strict) {
        expr.getLhs().accept(context, this, strict);
        Object lhs = this.pop();
        if (!(lhs instanceof Reference)) {
            throw new ThrowException(context, context.createReferenceError(expr.getLhs() + " is not a reference"));
        }
        Reference lhsRef = (Reference)lhs;
        expr.getRhs().accept(context, this, strict);
        Object rhs = this.getValue(context, this.pop());
        lhsRef.putValue(context, rhs);
        this.push(rhs);
    }

    @Override
    public void visit(ExecutionContext context, BitwiseInversionOperatorExpression expr, boolean strict) {
        expr.getExpr().accept(context, this, strict);
        this.push(Types.toInt32(context, this.getValue(context, this.pop())) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void visit(ExecutionContext context, BlockStatement statement, boolean strict) {
        List<Statement> content = statement.getBlockContent();
        Object completionValue = Types.UNDEFINED;
        for (Statement each : content) {
            Position position = each.getPosition();
            if (position != null) {
                context.setLineNumber(position.getLine());
            }
            each.accept(context, this, strict);
            Completion completion = (Completion)this.pop();
            if (completion.type == Completion.Type.NORMAL) {
                completionValue = completion.value;
                continue;
            }
            if (completion.type == Completion.Type.CONTINUE) {
                this.push(completion);
                return;
            }
            if (completion.type == Completion.Type.RETURN) {
                this.push(completion);
                return;
            }
            if (completion.type != Completion.Type.BREAK) continue;
            completion.value = completionValue;
            if (completion.target != null && statement.getLabels().contains(completion.target)) {
                this.push(Completion.createNormal(completionValue));
            } else {
                this.push(completion);
            }
            return;
        }
        this.push(Completion.createNormal(completionValue));
    }

    @Override
    public void visit(ExecutionContext context, BooleanLiteralExpression expr, boolean strict) {
        this.push(expr.getValue());
    }

    @Override
    public void visit(ExecutionContext context, BreakStatement statement, boolean strict) {
        this.push(Completion.createBreak(statement.getTarget()));
    }

    @Override
    public void visit(ExecutionContext context, CaseClause clause, boolean strict) {
    }

    @Override
    public void visit(ExecutionContext context, DefaultCaseClause clause, boolean strict) {
    }

    @Override
    public void visit(ExecutionContext context, CatchClause clause, boolean strict) {
    }

    @Override
    public void visit(ExecutionContext context, CompoundAssignmentExpression expr, boolean strict) {
        expr.getRootExpr().accept(context, this, strict);
        Object r = this.pop();
        expr.getRootExpr().getLhs().accept(context, this, strict);
        Object lref = this.pop();
        if (lref instanceof Reference) {
            if (((Reference)lref).isStrictReference() && ((Reference)lref).getBase() instanceof EnvironmentRecord && (((Reference)lref).getReferencedName().equals("arguments") || ((Reference)lref).getReferencedName().equals("eval"))) {
                throw new ThrowException(context, context.createSyntaxError("invalid assignment: " + ((Reference)lref).getReferencedName()));
            }
            ((Reference)lref).putValue(context, r);
            this.push(r);
            return;
        }
        throw new ThrowException(context, context.createReferenceError("cannot assign to non-reference"));
    }

    @Override
    public void visit(ExecutionContext context, ContinueStatement statement, boolean strict) {
        this.push(Completion.createContinue(statement.getTarget()));
    }

    @Override
    public void visit(ExecutionContext context, DeleteOpExpression expr, boolean strict) {
        expr.getExpr().accept(context, this, strict);
        Object result = this.pop();
        if (!(result instanceof Reference)) {
            this.push(true);
            return;
        }
        Reference ref = (Reference)result;
        if (ref.isUnresolvableReference()) {
            if (strict) {
                throw new ThrowException(context, context.createSyntaxError("cannot delete unresolvable reference"));
            }
            this.push(true);
            return;
        }
        if (ref.isPropertyReference()) {
            this.push(Types.toObject(context, ref.getBase()).delete(context, ref.getReferencedName(), ref.isStrictReference()));
            return;
        }
        if (ref.isStrictReference()) {
            throw new ThrowException(context, context.createSyntaxError("cannot delete from environment record binding"));
        }
        EnvironmentRecord bindings = (EnvironmentRecord)ref.getBase();
        this.push(bindings.deleteBinding(context, ref.getReferencedName()));
    }

    @Override
    public void visit(ExecutionContext context, DoWhileStatement statement, boolean strict) {
        Boolean testResult;
        Expression testExpr = statement.getTest();
        Statement block = statement.getBlock();
        Object v = null;
        do {
            Completion completion = this.invokeCompiledBlockStatement(context, "DoWhile", block);
            if (completion.value != null) {
                v = completion.value;
            }
            if (completion.type == Completion.Type.CONTINUE) {
                if (completion.target != null && !statement.getLabels().contains(completion.target)) {
                    this.push(completion);
                    return;
                }
            } else {
                if (completion.type == Completion.Type.BREAK) {
                    if (completion.target != null && !statement.getLabels().contains(completion.target)) {
                        this.push(completion);
                        return;
                    }
                    break;
                }
                if (completion.type == Completion.Type.RETURN) {
                    this.push(Completion.createReturn(v));
                    return;
                }
            }
            testExpr.accept(context, this, strict);
        } while ((testResult = Types.toBoolean(this.getValue(context, this.pop()))).booleanValue());
        this.push(Completion.createNormal(v));
    }

    @Override
    public void visit(ExecutionContext context, EmptyStatement statement, boolean strict) {
        this.push(Completion.createNormal());
    }

    @Override
    public void visit(ExecutionContext context, EqualityOperatorExpression expr, boolean strict) {
        expr.getLhs().accept(context, this, strict);
        Object lhs = this.getValue(context, this.pop());
        expr.getRhs().accept(context, this, strict);
        Object rhs = this.getValue(context, this.pop());
        if (expr.getOp().equals("==")) {
            this.push(Types.compareEquality(context, lhs, rhs));
        } else {
            this.push(!Types.compareEquality(context, lhs, rhs));
        }
    }

    @Override
    public void visit(ExecutionContext context, CommaOperator expr, boolean strict) {
        expr.getLhs().accept(context, this, strict);
        this.getValue(context, this.pop());
        expr.getRhs().accept(context, this, strict);
        this.push(this.getValue(context, this.pop()));
    }

    @Override
    public void visit(ExecutionContext context, ExpressionStatement statement, boolean strict) {
        Expression expr = statement.getExpr();
        if (expr instanceof FunctionDeclaration) {
            this.push(Completion.createNormal());
        } else {
            expr.accept(context, this, strict);
            this.push(Completion.createNormal(this.getValue(context, this.pop())));
        }
    }

    @Override
    public void visit(ExecutionContext context, ForExprInStatement statement, boolean strict) {
        statement.getRhs().accept(context, this, strict);
        Object exprRef = this.pop();
        Object exprValue = this.getValue(context, exprRef);
        if (exprValue == Types.NULL || exprValue == Types.UNDEFINED) {
            this.push(Completion.createNormal());
            return;
        }
        JSObject obj = Types.toObject(context, exprValue);
        Object v = null;
        List<String> names = obj.getAllEnumerablePropertyNames().toList();
        for (String each : names) {
            statement.getExpr().accept(context, this, strict);
            Object lhsRef = this.pop();
            if (lhsRef instanceof Reference) {
                ((Reference)lhsRef).putValue(context, each);
            }
            Completion completion = this.invokeCompiledBlockStatement(context, "ForIn", statement.getBlock());
            if (completion.value != null) {
                v = completion.value;
            }
            if (completion.type == Completion.Type.BREAK) {
                if (completion.target == null || statement.getLabels().contains(completion.target)) {
                    this.push(Completion.createNormal(v));
                } else {
                    this.push(completion);
                }
                return;
            }
            if (completion.type != Completion.Type.RETURN && completion.type != Completion.Type.BREAK) continue;
            this.push(completion);
            return;
        }
        this.push(Completion.createNormal(v));
    }

    @Override
    public void visit(ExecutionContext context, ForExprStatement statement, boolean strict) {
        if (statement.getExpr() != null) {
            statement.getExpr().accept(context, this, strict);
            this.pop();
        }
        Expression test = statement.getTest();
        Expression incr = statement.getIncrement();
        Statement body = statement.getBlock();
        Object v = null;
        while (true) {
            if (test != null) {
                test.accept(context, this, strict);
                if (!Types.toBoolean(this.getValue(context, this.pop())).booleanValue()) break;
            }
            Completion completion = this.invokeCompiledBlockStatement(context, "ForExpr", body);
            if (completion.value != null && completion.value != Types.UNDEFINED) {
                v = completion.value;
            }
            if (completion.type == Completion.Type.BREAK) {
                if (completion.target == null || statement.getLabels().contains(completion.target)) {
                    this.push(Completion.createNormal(v));
                } else {
                    completion.value = v;
                    this.push(completion);
                }
                return;
            }
            if (completion.type == Completion.Type.RETURN) {
                this.push(completion);
                return;
            }
            if (completion.type == Completion.Type.CONTINUE && completion.target != null && !statement.getLabels().contains(completion.target)) {
                this.push(completion);
                return;
            }
            if (incr == null) continue;
            incr.accept(context, this, strict);
            this.getValue(context, this.pop());
        }
        this.push(Completion.createNormal(v));
    }

    @Override
    public void visit(ExecutionContext context, ForVarDeclInStatement statement, boolean strict) {
        statement.getDeclaration().accept(context, this, strict);
        String varName = (String)this.pop();
        statement.getRhs().accept(context, this, strict);
        Object exprRef = this.pop();
        Object exprValue = this.getValue(context, exprRef);
        if (exprValue == Types.NULL || exprValue == Types.UNDEFINED) {
            this.push(Completion.createNormal());
            return;
        }
        JSObject obj = Types.toObject(context, exprValue);
        Object v = null;
        List<String> names = obj.getAllEnumerablePropertyNames().toList();
        for (String each : names) {
            Reference varRef = context.resolve(varName);
            varRef.putValue(context, each);
            Completion completion = this.invokeCompiledBlockStatement(context, "ForVarDeclsIn", statement.getBlock());
            if (completion.value != null) {
                v = completion.value;
            }
            if (completion.type == Completion.Type.BREAK) {
                if (completion.target == null || statement.getLabels().contains(completion.target)) {
                    this.push(Completion.createNormal(v));
                } else {
                    this.push(completion);
                }
                return;
            }
            if (completion.type != Completion.Type.RETURN && completion.type != Completion.Type.BREAK) continue;
            this.push(completion);
            return;
        }
        this.push(Completion.createNormal(v));
    }

    @Override
    public void visit(ExecutionContext context, ForVarDeclStatement statement, boolean strict) {
        List<VariableDeclaration> decls = statement.getDeclarationList();
        for (VariableDeclaration each : decls) {
            each.accept(context, this, strict);
            this.pop();
        }
        Expression test = statement.getTest();
        Expression incr = statement.getIncrement();
        Statement body = statement.getBlock();
        Object v = null;
        while (true) {
            if (test != null) {
                test.accept(context, this, strict);
                if (!Types.toBoolean(this.getValue(context, this.pop())).booleanValue()) break;
            }
            Completion completion = this.invokeCompiledBlockStatement(context, "ForVarDecl", body);
            if (completion.value != null && completion.value != Types.UNDEFINED) {
                v = completion.value;
            }
            if (completion.type == Completion.Type.BREAK) {
                if (completion.target == null || statement.getLabels().contains(completion.target)) {
                    this.push(Completion.createNormal(v));
                } else {
                    completion.value = v;
                    this.push(completion);
                }
                return;
            }
            if (completion.type == Completion.Type.RETURN) {
                this.push(completion);
                return;
            }
            if (completion.type == Completion.Type.CONTINUE && completion.target != null && !statement.getLabels().contains(completion.target)) {
                this.push(completion);
                return;
            }
            if (incr == null) continue;
            incr.accept(context, this, strict);
            this.getValue(context, this.pop());
        }
        this.push(Completion.createNormal(v));
    }

    @Override
    public void visit(ExecutionContext context, FunctionCallExpression expr, boolean strict) {
        expr.getMemberExpression().accept(context, this, strict);
        Object ref = this.pop();
        Object function = this.getValue(context, ref);
        List<Expression> argExprs = expr.getArgumentExpressions();
        Object[] args = new Object[argExprs.size()];
        int i = 0;
        for (Expression each : argExprs) {
            each.accept(context, this, strict);
            args[i] = this.getValue(context, this.pop());
            ++i;
        }
        if (!(function instanceof JSFunction)) {
            throw new ThrowException(context, context.createTypeError(expr.getMemberExpression() + " is not calllable"));
        }
        Object thisValue = null;
        if (ref instanceof Reference) {
            thisValue = ((Reference)ref).isPropertyReference() ? ((Reference)ref).getBase() : ((EnvironmentRecord)((Reference)ref).getBase()).implicitThisValue();
        }
        this.push(context.call(ref, (JSFunction)function, thisValue, args));
    }

    @Override
    public void visit(ExecutionContext context, FunctionDeclaration statement, boolean strict) {
        this.push(Completion.createNormal());
    }

    @Override
    public void visit(ExecutionContext context, FunctionExpression expr, boolean strict) {
        JSFunction compiledFn = context.getCompiler().compileFunction(context, expr.getDescriptor().getIdentifier(), expr.getDescriptor().getFormalParameterNames(), expr.getDescriptor().getBlock(), expr.getDescriptor().isStrict() || strict);
        this.push(compiledFn);
    }

    @Override
    public void visit(ExecutionContext context, IdentifierReferenceExpression expr, boolean strict) {
        this.push(context.resolve(expr.getIdentifier()));
    }

    @Override
    public void visit(ExecutionContext context, IfStatement statement, boolean strict) {
        statement.getTest().accept(context, this, strict);
        Boolean result = Types.toBoolean(this.getValue(context, this.pop()));
        if (result.booleanValue()) {
            this.push(this.invokeCompiledBlockStatement(context, "Then", statement.getThenBlock()));
        } else if (statement.getElseBlock() != null) {
            this.push(this.invokeCompiledBlockStatement(context, "Else", statement.getElseBlock()));
        } else {
            this.push(Completion.createNormal());
        }
    }

    @Override
    public void visit(ExecutionContext context, InOperatorExpression expr, boolean strict) {
        expr.getLhs().accept(context, this, strict);
        Object lhs = this.getValue(context, this.pop());
        expr.getRhs().accept(context, this, strict);
        Object rhs = this.getValue(context, this.pop());
        if (!(rhs instanceof JSObject)) {
            throw new ThrowException(context, context.createTypeError(expr.getRhs() + " is not an object"));
        }
        this.push(((JSObject)rhs).hasProperty(context, Types.toString(context, lhs)));
    }

    @Override
    public void visit(ExecutionContext context, InstanceofExpression expr, boolean strict) {
        expr.getLhs().accept(context, this, strict);
        Object lhs = this.getValue(context, this.pop());
        expr.getRhs().accept(context, this, strict);
        Object rhs = this.getValue(context, this.pop());
        if (rhs instanceof JSObject) {
            if (!(rhs instanceof JSFunction)) {
                throw new ThrowException(context, context.createTypeError(expr.getRhs() + " is not a function"));
            }
            this.push(((JSFunction)rhs).hasInstance(context, lhs));
        } else if (rhs instanceof Class) {
            Class clazz = (Class)rhs;
            this.push(lhs.getClass().getName().equals(clazz.getName()));
        }
    }

    @Override
    public void visit(ExecutionContext context, LogicalExpression expr, boolean strict) {
        expr.getLhs().accept(context, this, strict);
        Object lhs = this.getValue(context, this.pop());
        if (expr.getOp().equals("||") && Types.toBoolean(lhs).booleanValue() || expr.getOp().equals("&&") && !Types.toBoolean(lhs).booleanValue()) {
            this.push(lhs);
        } else {
            expr.getRhs().accept(context, this, strict);
        }
    }

    @Override
    public void visit(ExecutionContext context, LogicalNotOperatorExpression expr, boolean strict) {
        expr.getExpr().accept(context, this, strict);
        this.push(Types.toBoolean(this.getValue(context, this.pop())) == false);
    }

    @Override
    public void visit(ExecutionContext context, DotExpression expr, boolean strict) {
        expr.getLhs().accept(context, this, strict);
        Object baseRef = this.pop();
        Object baseValue = this.getValue(context, baseRef);
        String propertyName = expr.getIdentifier();
        Types.checkObjectCoercible(context, baseValue, propertyName);
        this.push(context.createPropertyReference(baseValue, propertyName));
    }

    @Override
    public void visit(ExecutionContext context, BracketExpression expr, boolean strict) {
        expr.getLhs().accept(context, this, strict);
        Object baseRef = this.pop();
        Object baseValue = this.getValue(context, baseRef);
        expr.getRhs().accept(context, this, strict);
        Object identifier = this.getValue(context, this.pop());
        Types.checkObjectCoercible(context, baseValue);
        String propertyName = Types.toString(context, identifier);
        this.push(context.createPropertyReference(baseValue, propertyName));
    }

    @Override
    public void visit(ExecutionContext context, MultiplicativeExpression expr, boolean strict) {
        expr.getLhs().accept(context, this, strict);
        Number lval = Types.toNumber(context, this.getValue(context, this.pop()));
        expr.getRhs().accept(context, this, strict);
        Number rval = Types.toNumber(context, this.getValue(context, this.pop()));
        if (Double.isNaN(lval.doubleValue()) || Double.isNaN(rval.doubleValue())) {
            this.push(Double.NaN);
            return;
        }
        if (lval instanceof Double || rval instanceof Double) {
            switch (expr.getOp()) {
                case "*": {
                    this.push(lval.doubleValue() * rval.doubleValue());
                    return;
                }
                case "/": {
                    if (this.isZero(rval)) {
                        if (this.isZero(lval)) {
                            this.push(Double.NaN);
                            return;
                        }
                        if (this.isSameSign(lval, rval)) {
                            this.push(Double.POSITIVE_INFINITY);
                            return;
                        }
                        this.push(Double.NEGATIVE_INFINITY);
                        return;
                    }
                    if (this.isZero(lval)) {
                        if (this.isSameSign(lval, rval)) {
                            this.push(0L);
                        } else {
                            this.push(-0.0);
                        }
                        return;
                    }
                    double primaryValue = lval.doubleValue() / rval.doubleValue();
                    if (this.isRepresentableByLong(primaryValue)) {
                        this.push((long)primaryValue);
                    } else {
                        this.push(primaryValue);
                    }
                    return;
                }
                case "%": {
                    if (rval.doubleValue() == 0.0) {
                        this.push(Double.NaN);
                        return;
                    }
                    this.push(BuiltinNumber.modulo(lval, rval));
                    return;
                }
            }
        } else {
            switch (expr.getOp()) {
                case "*": {
                    this.push(lval.longValue() * rval.longValue());
                    return;
                }
                case "/": {
                    if (rval.longValue() == 0L) {
                        if (lval.longValue() == 0L) {
                            this.push(Double.NaN);
                            return;
                        }
                        if (this.isSameSign(lval, rval)) {
                            this.push(Double.POSITIVE_INFINITY);
                            return;
                        }
                        this.push(Double.NEGATIVE_INFINITY);
                        return;
                    }
                    if (lval.longValue() == 0L) {
                        if (Double.compare(rval.doubleValue(), 0.0) > 0) {
                            this.push(0L);
                            return;
                        }
                        this.push(-0.0);
                        return;
                    }
                    double primaryResult = lval.doubleValue() / (double)rval.longValue();
                    if (primaryResult == (double)((long)primaryResult)) {
                        this.push((long)primaryResult);
                    } else {
                        this.push(primaryResult);
                    }
                    return;
                }
                case "%": {
                    if (rval.longValue() == 0L) {
                        this.push(Double.NaN);
                        return;
                    }
                    this.push(BuiltinNumber.modulo(lval, rval));
                    return;
                }
            }
        }
    }

    @Override
    public void visit(ExecutionContext context, NewOperatorExpression expr, boolean strict) {
        expr.getExpr().accept(context, this, strict);
        Object memberExpr = this.getValue(context, this.pop());
        Object[] args = new Object[expr.getArgumentExpressions().size()];
        int i = 0;
        for (Expression each : expr.getArgumentExpressions()) {
            each.accept(context, this, strict);
            args[i] = this.getValue(context, this.pop());
            ++i;
        }
        if (memberExpr instanceof JSFunction) {
            this.push(context.construct((JSFunction)memberExpr, args));
            return;
        }
        throw new ThrowException(context, context.createTypeError("can only construct using functions"));
    }

    @Override
    public void visit(ExecutionContext context, NullLiteralExpression expr, boolean strict) {
        this.push(Types.NULL);
    }

    @Override
    public void visit(ExecutionContext context, NumberLiteralExpression expr, boolean strict) {
        String text = expr.getText();
        if (text.indexOf(46) == 0) {
            text = "0" + text;
            this.push(Double.valueOf(text));
            return;
        }
        if (text.indexOf(46) > 0) {
            double primaryValue = Double.valueOf(text);
            if (primaryValue == (double)((long)primaryValue)) {
                this.push((long)primaryValue);
            } else {
                this.push(primaryValue);
            }
            return;
        }
        if (text.startsWith("0x") || text.startsWith("0X")) {
            text = text.substring(2);
            this.push(Long.valueOf(text, 16));
            return;
        }
        int eLoc = text.toLowerCase().indexOf(101);
        if (eLoc > 0) {
            String base = text.substring(0, eLoc);
            String exponent = text.substring(eLoc);
            String javafied = base + ".0" + exponent;
            this.push(Double.valueOf(javafied));
        } else {
            this.push(Types.parseLongOrDouble(text, expr.getRadix()));
        }
    }

    @Override
    public void visit(ExecutionContext context, ObjectLiteralExpression expr, boolean strict) {
        DynObject obj = BuiltinObject.newObject(context);
        List<PropertyAssignment> assignments = expr.getPropertyAssignments();
        for (PropertyAssignment each : assignments) {
            each.accept(context, this, strict);
            String debugName = each.getName();
            Object ref = this.pop();
            if (ref instanceof Reference) {
                debugName = ((Reference)ref).getReferencedName();
            }
            Object value = this.getValue(context, ref);
            Object original = obj.getOwnProperty(context, each.getName());
            PropertyDescriptor desc = null;
            desc = each instanceof PropertyGet ? PropertyDescriptor.newPropertyDescriptorForObjectInitializerGet(original, debugName, (JSFunction)value) : (each instanceof PropertySet ? PropertyDescriptor.newPropertyDescriptorForObjectInitializerSet(original, debugName, (JSFunction)value) : PropertyDescriptor.newPropertyDescriptorForObjectInitializer(debugName, value));
            obj.defineOwnProperty(context, each.getName(), desc, false);
        }
        this.push(obj);
    }

    @Override
    public void visit(ExecutionContext context, PostOpExpression expr, boolean strict) {
        expr.getExpr().accept(context, this, strict);
        Object lhs = this.pop();
        if (lhs instanceof Reference) {
            if (((Reference)lhs).isStrictReference() && ((Reference)lhs).getBase() instanceof EnvironmentRecord && (((Reference)lhs).getReferencedName().equals("arguments") || ((Reference)lhs).getReferencedName().equals("eval"))) {
                throw new ThrowException(context, context.createSyntaxError("invalid assignment: " + ((Reference)lhs).getReferencedName()));
            }
            Number newValue = null;
            Number oldValue = Types.toNumber(context, this.getValue(context, lhs));
            if (oldValue instanceof Double) {
                switch (expr.getOp()) {
                    case "++": {
                        newValue = oldValue.doubleValue() + 1.0;
                        break;
                    }
                    case "--": {
                        newValue = oldValue.doubleValue() - 1.0;
                    }
                }
            } else {
                switch (expr.getOp()) {
                    case "++": {
                        newValue = oldValue.longValue() + 1L;
                        break;
                    }
                    case "--": {
                        newValue = oldValue.longValue() - 1L;
                    }
                }
            }
            ((Reference)lhs).putValue(context, newValue);
            this.push(oldValue);
        }
    }

    @Override
    public void visit(ExecutionContext context, PreOpExpression expr, boolean strict) {
        expr.getExpr().accept(context, this, strict);
        Object lhs = this.pop();
        if (lhs instanceof Reference) {
            if (((Reference)lhs).isStrictReference() && ((Reference)lhs).getBase() instanceof EnvironmentRecord && (((Reference)lhs).getReferencedName().equals("arguments") || ((Reference)lhs).getReferencedName().equals("eval"))) {
                throw new ThrowException(context, context.createSyntaxError("invalid assignment: " + ((Reference)lhs).getReferencedName()));
            }
            Number newValue = null;
            Number oldValue = Types.toNumber(context, this.getValue(context, lhs));
            if (oldValue instanceof Double) {
                switch (expr.getOp()) {
                    case "++": {
                        newValue = oldValue.doubleValue() + 1.0;
                        break;
                    }
                    case "--": {
                        newValue = oldValue.doubleValue() - 1.0;
                    }
                }
            } else {
                switch (expr.getOp()) {
                    case "++": {
                        newValue = oldValue.longValue() + 1L;
                        break;
                    }
                    case "--": {
                        newValue = oldValue.longValue() - 1L;
                    }
                }
            }
            ((Reference)lhs).putValue(context, newValue);
            this.push(newValue);
        }
    }

    @Override
    public void visit(ExecutionContext context, PropertyGet propertyGet, boolean strict) {
        JSFunction compiledFn = context.getCompiler().compileFunction(context, null, new String[0], propertyGet.getBlock(), strict);
        this.push(compiledFn);
    }

    @Override
    public void visit(ExecutionContext context, PropertySet propertySet, boolean strict) {
        JSFunction compiledFn = context.getCompiler().compileFunction(context, null, new String[]{propertySet.getIdentifier()}, propertySet.getBlock(), strict);
        this.push(compiledFn);
    }

    @Override
    public void visit(ExecutionContext context, NamedValue namedValue, boolean strict) {
        namedValue.getExpr().accept(context, this, strict);
    }

    @Override
    public void visit(ExecutionContext context, RegexpLiteralExpression expr, boolean strict) {
        this.push(BuiltinRegExp.newRegExp(context, expr.getPattern(), expr.getFlags()));
    }

    @Override
    public void visit(ExecutionContext context, RelationalExpression expr, boolean strict) {
        expr.getLhs().accept(context, this, strict);
        Object lval = this.getValue(context, this.pop());
        expr.getRhs().accept(context, this, strict);
        Object rval = this.getValue(context, this.pop());
        Object r = null;
        switch (expr.getOp()) {
            case "<": {
                r = Types.compareRelational(context, lval, rval, true);
                if (r == Types.UNDEFINED) {
                    this.push(false);
                } else {
                    this.push(r);
                }
                return;
            }
            case ">": {
                r = Types.compareRelational(context, rval, lval, false);
                if (r == Types.UNDEFINED) {
                    this.push(false);
                } else {
                    this.push(r);
                }
                return;
            }
            case "<=": {
                r = Types.compareRelational(context, rval, lval, false);
                if (r == Boolean.TRUE || r == Types.UNDEFINED) {
                    this.push(false);
                } else {
                    this.push(true);
                }
                return;
            }
            case ">=": {
                r = Types.compareRelational(context, lval, rval, true);
                if (r == Boolean.TRUE || r == Types.UNDEFINED) {
                    this.push(false);
                } else {
                    this.push(true);
                }
                return;
            }
        }
    }

    @Override
    public void visit(ExecutionContext context, ReturnStatement statement, boolean strict) {
        if (statement.getExpr() != null) {
            statement.getExpr().accept(context, this, strict);
            Object value = this.pop();
            this.push(Completion.createReturn(this.getValue(context, value)));
        } else {
            this.push(Completion.createReturn(Types.UNDEFINED));
        }
    }

    @Override
    public void visit(ExecutionContext context, StrictEqualityOperatorExpression expr, boolean strict) {
        expr.getLhs().accept(context, this, strict);
        Object lhs = this.getValue(context, this.pop());
        expr.getRhs().accept(context, this, strict);
        Object rhs = this.getValue(context, this.pop());
        Boolean result = null;
        result = expr.getOp().equals("===") ? Boolean.valueOf(Types.compareStrictEquality(context, lhs, rhs)) : Boolean.valueOf(!Types.compareStrictEquality(context, lhs, rhs));
        this.push(result);
    }

    @Override
    public void visit(ExecutionContext context, StringLiteralExpression expr, boolean strict) {
        this.push(expr.getLiteral());
    }

    @Override
    public void visit(ExecutionContext context, SwitchStatement statement, boolean strict) {
        CaseClause each;
        int i;
        statement.getExpr().accept(context, this, strict);
        Object value = this.getValue(context, this.pop());
        Object v = null;
        int numClauses = statement.getCaseClauses().size();
        int startIndex = -1;
        int defaultIndex = -1;
        for (i = 0; i < numClauses; ++i) {
            each = statement.getCaseClauses().get(i);
            if (each instanceof DefaultCaseClause) {
                defaultIndex = i;
                continue;
            }
            each.getExpression().accept(context, this, strict);
            Object caseTest = this.pop();
            if (!Types.compareStrictEquality(context, value, this.getValue(context, caseTest))) continue;
            startIndex = i;
            break;
        }
        if (startIndex < 0 && defaultIndex >= 0) {
            startIndex = defaultIndex;
        }
        if (startIndex >= 0) {
            for (i = startIndex; i < numClauses; ++i) {
                each = statement.getCaseClauses().get(i);
                if (each.getBlock() == null) continue;
                each.getBlock().accept(context, this, strict);
                Completion completion = (Completion)this.pop();
                v = completion.value;
                if (completion.type == Completion.Type.BREAK) break;
                if (completion.type != Completion.Type.RETURN) continue;
                this.push(completion);
                return;
            }
        }
        this.push(Completion.createNormal(v));
    }

    @Override
    public void visit(ExecutionContext context, TernaryExpression expr, boolean strict) {
        expr.getTest().accept(context, this, strict);
        if (Types.toBoolean(this.getValue(context, this.pop())).booleanValue()) {
            expr.getThenExpr().accept(context, this, strict);
        } else {
            expr.getElseExpr().accept(context, this, strict);
        }
    }

    @Override
    public void visit(ExecutionContext context, ThisExpression expr, boolean strict) {
        this.push(context.getThisBinding());
    }

    @Override
    public void visit(ExecutionContext context, ThrowStatement statement, boolean strict) {
        statement.getExpr().accept(context, this, strict);
        Object throwable = this.getValue(context, this.pop());
        throw new ThrowException(context, throwable);
    }

    @Override
    public void visit(ExecutionContext context, TryStatement statement, boolean strict) {
        Completion b = null;
        boolean finallyExecuted = false;
        try {
            b = this.invokeCompiledBlockStatement(context, "Try", statement.getTryBlock());
            this.push(b);
        }
        catch (ThrowException e) {
            block15: {
                if (statement.getCatchClause() != null) {
                    BasicBlock catchBlock = this.compiledBlockStatement(context, "Catch", statement.getCatchClause().getBlock());
                    try {
                        b = context.executeCatch(catchBlock, statement.getCatchClause().getIdentifier(), e.getValue());
                    }
                    catch (ThrowException e2) {
                        if (statement.getFinallyBlock() != null) {
                            Completion f = this.invokeCompiledBlockStatement(context, "Finally", statement.getFinallyBlock());
                            if (f.type == Completion.Type.NORMAL) {
                                if (b != null) {
                                    this.push(b);
                                    break block15;
                                }
                                throw e2;
                            }
                            this.push(f);
                            return;
                        }
                        throw e2;
                    }
                }
            }
            if (statement.getFinallyBlock() != null) {
                finallyExecuted = true;
                Completion f = this.invokeCompiledBlockStatement(context, "Finally", statement.getFinallyBlock());
                if (f.type == Completion.Type.NORMAL) {
                    if (b != null) {
                        this.push(b);
                    }
                    throw e;
                }
                this.push(f);
                return;
            }
            if (b != null) {
                this.push(b);
            }
            throw e;
        }
        if (!finallyExecuted && statement.getFinallyBlock() != null) {
            Completion f = this.invokeCompiledBlockStatement(context, "Finally", statement.getFinallyBlock());
            if (f.type == Completion.Type.NORMAL) {
                this.push(b);
            } else {
                this.push(f);
            }
        }
    }

    @Override
    public void visit(ExecutionContext context, TypeOfOpExpression expr, boolean strict) {
        expr.getExpr().accept(context, this, strict);
        this.push(Types.typeof(context, this.pop()));
    }

    @Override
    public void visit(ExecutionContext context, UnaryMinusExpression expr, boolean strict) {
        expr.getExpr().accept(context, this, strict);
        Object value = this.getValue(context, this.pop());
        Number oldValue = Types.toNumber(context, value);
        if (oldValue instanceof Double) {
            if (Double.isNaN(oldValue.doubleValue())) {
                this.push(Double.NaN);
            } else {
                this.push(-1.0 * oldValue.doubleValue());
            }
        } else if (oldValue.longValue() == 0L) {
            this.push(-0.0);
        } else {
            this.push(-1L * oldValue.longValue());
        }
    }

    @Override
    public void visit(ExecutionContext context, UnaryPlusExpression expr, boolean strict) {
        expr.getExpr().accept(context, this, strict);
        this.push(Types.toNumber(context, this.getValue(context, this.pop())));
    }

    @Override
    public void visit(ExecutionContext context, VariableDeclaration expr, boolean strict) {
        if (expr.getExpr() != null) {
            expr.getExpr().accept(context, this, strict);
            Object value = this.getValue(context, this.pop());
            Reference var = context.resolve(expr.getIdentifier());
            var.putValue(context, value);
        }
        this.push(expr.getIdentifier());
    }

    @Override
    public void visit(ExecutionContext context, VariableStatement statement, boolean strict) {
        for (VariableDeclaration each : statement.getVariableDeclarations()) {
            each.accept(context, this, strict);
            this.pop();
        }
        this.push(Completion.createNormal(Types.UNDEFINED));
    }

    @Override
    public void visit(ExecutionContext context, VoidOperatorExpression expr, boolean strict) {
        expr.getExpr().accept(context, this, strict);
        Object value = this.getValue(context, this.pop());
        this.push(Types.UNDEFINED);
    }

    @Override
    public void visit(ExecutionContext context, WhileStatement statement, boolean strict) {
        Object v;
        block5: {
            Expression testExpr = statement.getTest();
            Statement block = statement.getBlock();
            v = null;
            while (true) {
                testExpr.accept(context, this, strict);
                Boolean testResult = Types.toBoolean(this.getValue(context, this.pop()));
                if (!testResult.booleanValue()) break block5;
                Completion completion = this.invokeCompiledBlockStatement(context, "While", block);
                if (completion.value != null) {
                    v = completion.value;
                }
                if (completion.type == Completion.Type.CONTINUE) {
                    if (completion.target == null || statement.getLabels().contains(completion.target)) continue;
                    this.push(completion);
                    return;
                }
                if (completion.type == Completion.Type.BREAK) {
                    if (completion.target != null && !statement.getLabels().contains(completion.target)) {
                        this.push(completion);
                        return;
                    }
                    break block5;
                }
                if (completion.type == Completion.Type.RETURN) break;
            }
            this.push(Completion.createReturn(v));
            return;
        }
        this.push(Completion.createNormal(v));
    }

    @Override
    public void visit(ExecutionContext context, WithStatement statement, boolean strict) {
        statement.getExpr().accept(context, this, strict);
        JSObject obj = Types.toObject(context, this.getValue(context, this.pop()));
        BasicBlock block = this.compiledBlockStatement(context, "With", statement.getBlock());
        this.push(context.executeWith(obj, block));
    }

    protected BasicBlock compiledBlockStatement(ExecutionContext context, String grist, Statement statement) {
        BlockManager.Entry entry = this.blockManager.retrieve(statement.getStatementNumber());
        if (entry.getCompiled() == null) {
            BasicBlock compiledBlock = context.getCompiler().compileBasicBlock(context, grist, statement, context.isStrict());
            entry.setCompiled(compiledBlock);
        }
        return entry.getCompiled();
    }

    protected Completion invokeCompiledBlockStatement(ExecutionContext context, String grist, Statement statement) {
        BasicBlock block = this.compiledBlockStatement(context, grist, statement);
        return block.call(context);
    }

    protected Object getValue(ExecutionContext context, Object obj) {
        return Types.getValue(context, obj);
    }

    private boolean isZero(Number n) {
        return n.doubleValue() == 0.0;
    }

    private boolean isNegativeZero(Number n) {
        return this.isZero(n) && this.isNegative(n);
    }

    private boolean isPositiveZero(Number n) {
        return this.isZero(n) && this.isPositive(n);
    }

    private boolean isNegative(Number n) {
        return Double.compare(n.doubleValue(), 0.0) < 0;
    }

    private boolean isPositive(Number n) {
        return Double.compare(n.doubleValue(), 0.0) >= 0;
    }

    private boolean isSameSign(Number n1, Number n2) {
        return this.isPositive(n1) && this.isPositive(n2) || this.isNegative(n1) && this.isNegative(n2);
    }

    private boolean isDifferentSign(Number n1, Number n2) {
        return this.isPositive(n1) && this.isNegative(n2) || this.isNegative(n1) && this.isPositive(n2);
    }

    private boolean isRepresentableByLong(double n) {
        if (this.isNegativeZero(n)) {
            return false;
        }
        return n == (double)((long)n);
    }
}

