/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.runtime.modules;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.dynjs.runtime.DynJS;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.builtins.Require;
import org.dynjs.runtime.modules.ModuleProvider;

public class FilesystemModuleProvider
extends ModuleProvider {
    @Override
    protected boolean load(DynJS runtime, ExecutionContext context, String moduleID) {
        File file = new File(moduleID);
        if (file.exists()) {
            runtime.evaluate("require.addLoadPath('" + file.getParent() + "')");
            try {
                runtime.newRunner().withContext(context).withSource(file).execute();
                runtime.evaluate("require.removeLoadPath('" + file.getParent() + "')");
                return true;
            }
            catch (IOException e) {
                System.err.println("There was an error loading the module " + moduleID + ". Error message: " + e.getMessage());
            }
        }
        return false;
    }

    @Override
    public String generateModuleID(ExecutionContext context, String moduleName) {
        File moduleFile;
        Object require = context.getGlobalObject().get("require");
        if (require instanceof Require && (moduleFile = this.findFile(((Require)require).getLoadPaths(), moduleName)) != null && moduleFile.exists()) {
            try {
                return moduleFile.getCanonicalPath();
            }
            catch (IOException e) {
                System.err.println("There was an error generating id of module " + moduleName + ". Error message: " + e.getMessage());
                return moduleFile.getAbsolutePath();
            }
        }
        return null;
    }

    protected File findFile(List<String> loadPaths, String moduleName) {
        String loadPath;
        String fileName = this.normalizeName(moduleName);
        File file = null;
        Iterator<String> iterator = loadPaths.iterator();
        while (iterator.hasNext() && !(file = new File(loadPath = iterator.next(), fileName)).exists()) {
        }
        return file;
    }
}

