/*
 * Decompiled with CFR 0.152.
 */
package me.qmx.jitescript;

import java.util.ArrayList;
import java.util.List;
import me.qmx.jitescript.CodeBlock;
import me.qmx.jitescript.FieldDefinition;
import me.qmx.jitescript.JDKVersion;
import me.qmx.jitescript.MethodDefinition;
import me.qmx.jitescript.VisibleAnnotation;
import me.qmx.jitescript.util.CodegenUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.ClassNode;

public class JiteClass
implements Opcodes {
    public static final String[] INTERFACES = new String[0];
    private final List<MethodDefinition> methods = new ArrayList<MethodDefinition>();
    private final List<FieldDefinition> fields = new ArrayList<FieldDefinition>();
    private final List<String> interfaces = new ArrayList<String>();
    private final List<VisibleAnnotation> annotations = new ArrayList<VisibleAnnotation>();
    private final List<ChildEntry> childClasses = new ArrayList<ChildEntry>();
    private final String className;
    private final String superClassName;
    private String sourceFile;
    private String sourceDebug;
    private int access = 1;
    private String parentClassName;

    public JiteClass(String className) {
        this(className, INTERFACES);
    }

    public JiteClass(String className, String[] interfaces) {
        this(className, CodegenUtils.p(Object.class), interfaces);
    }

    public JiteClass(String className, String superClassName, String[] interfaces) {
        this.className = className;
        this.superClassName = superClassName;
        for (String anInterface : interfaces) {
            this.interfaces.add(anInterface);
        }
    }

    public int getAccess() {
        return this.access;
    }

    public String getClassName() {
        return this.className;
    }

    public String getParentClassName() {
        return this.parentClassName;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    public void setParentClassName(String parentClassName) {
        this.parentClassName = parentClassName;
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public void setSourceDebug(String sourceDebug) {
        this.sourceDebug = sourceDebug;
    }

    public void addChildClass(JiteClass child) {
        String childName = child.getClassName();
        childName = childName.contains("$") ? childName.substring(childName.lastIndexOf(36) + 1) : childName.substring(childName.lastIndexOf(47) + 1);
        this.addChildClass(childName.substring(childName.lastIndexOf(36) + 1), child);
    }

    public void addChildClass(String innerName, JiteClass child) {
        child.setParentClassName(this.getClassName());
        this.childClasses.add(new ChildEntry(innerName, child));
    }

    public List<JiteClass> getChildClasses() {
        ArrayList<JiteClass> childClasses = new ArrayList<JiteClass>();
        for (ChildEntry child : this.childClasses) {
            childClasses.add(child.getJiteClass());
        }
        return childClasses;
    }

    public void defineMethod(String methodName, int modifiers, String signature, CodeBlock methodBody) {
        this.methods.add(new MethodDefinition(methodName, modifiers, signature, methodBody));
    }

    public FieldDefinition defineField(String fieldName, int modifiers, String signature, Object value) {
        FieldDefinition field = new FieldDefinition(fieldName, modifiers, signature, value);
        this.fields.add(field);
        return field;
    }

    public void defineDefaultConstructor() {
        this.defineDefaultConstructor(1);
    }

    public void defineDefaultConstructor(int access) {
        this.defineMethod("<init>", access, CodegenUtils.sig(Void.TYPE, new Class[0]), CodeBlock.newCodeBlock().aload(0).invokespecial(this.superClassName, "<init>", CodegenUtils.sig(Void.TYPE, new Class[0])).voidreturn());
    }

    public byte[] toBytes() {
        return this.toBytes(JDKVersion.V1_6);
    }

    public void addAnnotation(VisibleAnnotation annotation) {
        this.annotations.add(annotation);
    }

    public byte[] toBytes(JDKVersion version) {
        ClassNode node = new ClassNode();
        node.version = version.getVer();
        node.access = this.access | 0x20;
        node.name = this.className;
        node.superName = this.superClassName;
        node.sourceFile = this.sourceFile;
        node.sourceDebug = this.sourceDebug;
        if (this.parentClassName != null) {
            node.visitOuterClass(this.parentClassName, null, null);
        }
        for (ChildEntry childEntry : this.childClasses) {
            node.visitInnerClass(childEntry.getClassName(), this.className, childEntry.getInnerName(), childEntry.getAccess());
        }
        if (!this.interfaces.isEmpty()) {
            node.interfaces.addAll(this.interfaces);
        }
        for (MethodDefinition methodDefinition : this.methods) {
            node.methods.add(methodDefinition.getMethodNode());
        }
        for (FieldDefinition fieldDefinition : this.fields) {
            node.fields.add(fieldDefinition.getFieldNode());
        }
        if (node.visibleAnnotations == null) {
            node.visibleAnnotations = new ArrayList();
        }
        for (VisibleAnnotation visibleAnnotation : this.annotations) {
            node.visibleAnnotations.add(visibleAnnotation.getNode());
        }
        ClassWriter cw = new ClassWriter(2);
        node.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private static final class ChildEntry {
        public final String innerName;
        public final JiteClass jiteClass;

        public ChildEntry(String innerName, JiteClass jiteClass) {
            this.innerName = innerName;
            this.jiteClass = jiteClass;
        }

        public int getAccess() {
            return this.jiteClass.getAccess();
        }

        public String getClassName() {
            return this.jiteClass.getClassName();
        }

        public String getInnerName() {
            return this.innerName;
        }

        public JiteClass getJiteClass() {
            return this.jiteClass;
        }
    }
}

