/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.rephract;

import com.headius.invokebinder.Binder;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.projectodd.rephract.Operation;
import org.projectodd.rephract.OperationImpl;
import org.projectodd.rephract.RephractLinker;
import org.projectodd.rephract.StrategicLink;

class LinkPlan {
    private RephractLinker linker;
    private List<Operation> operations;
    private MutableCallSite callSite;
    private MethodHandles.Lookup lookup;
    private String name;
    private MethodType type;
    List<StrategicLink> links = new ArrayList<StrategicLink>();

    public LinkPlan(RephractLinker linker, MutableCallSite callSite, MethodHandles.Lookup lookup, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
        this.linker = linker;
        this.callSite = callSite;
        this.lookup = lookup;
        this.name = name;
        this.type = type;
        this.determineOperations();
        this.replan(null);
    }

    private void determineOperations() {
        if (!this.name.startsWith("dyn")) {
            return;
        }
        this.operations = new ArrayList<Operation>();
        int firstColon = this.name.indexOf(":");
        if (firstColon > 0) {
            int secondColon = this.name.indexOf(":", firstColon + 1);
            String opNames = this.name.substring(firstColon + 1, secondColon > 0 ? secondColon : this.name.length());
            StringTokenizer opNameTokens = new StringTokenizer(opNames, "|");
            String parameter = null;
            if (secondColon > 0) {
                parameter = this.name.substring(secondColon + 1);
            }
            while (opNameTokens.hasMoreTokens()) {
                String each = opNameTokens.nextToken();
                OperationImpl op = null;
                switch (each) {
                    case "getProperty": {
                        op = new OperationImpl(Operation.Type.GET_PROPERTY, parameter);
                        break;
                    }
                    case "setProperty": {
                        op = new OperationImpl(Operation.Type.SET_PROPERTY, parameter);
                        break;
                    }
                    case "getElement": {
                        op = new OperationImpl(Operation.Type.GET_ELEMENT, parameter);
                        break;
                    }
                    case "setElement": {
                        op = new OperationImpl(Operation.Type.SET_ELEMENT, parameter);
                        break;
                    }
                    case "getMethod": {
                        op = new OperationImpl(Operation.Type.GET_METHOD, parameter);
                        break;
                    }
                    case "call": {
                        op = new OperationImpl(Operation.Type.CALL, parameter);
                        break;
                    }
                    case "construct": {
                        op = new OperationImpl(Operation.Type.CONSTRUCT, parameter);
                    }
                }
                this.operations.add(op);
            }
        }
    }

    public boolean isRephractRequest() {
        return this.operations != null;
    }

    public List<Operation> getOperations() {
        if (this.operations == null) {
            return Collections.emptyList();
        }
        return this.operations;
    }

    public CallSite getCallSite() {
        return this.callSite;
    }

    public void setTarget(MethodHandle target) {
        this.callSite.setTarget(target);
    }

    public String getName() {
        return this.name;
    }

    public MethodType type() {
        return this.type;
    }

    public MethodHandles.Lookup lookup() {
        return this.lookup;
    }

    public void replan(StrategicLink link) throws NoSuchMethodException, IllegalAccessException {
        MethodHandle relink;
        if (link != null) {
            this.links.add(link);
        }
        MethodHandle current = relink = Binder.from((MethodType)this.type).convert(this.type.erase()).collect(0, Object[].class).convert(Object.class, new Class[]{Object[].class}).insert(0, new Object[]{this.linker}).insert(1, new Object[]{this}).invokeVirtual(MethodHandles.lookup(), "linkInvocation");
        for (int i = this.links.size() - 1; i >= 0; --i) {
            StrategicLink eachLink = this.links.get(i);
            current = MethodHandles.guardWithTest(eachLink.getGuard(), eachLink.getTarget(), current);
        }
        this.callSite.setTarget(current);
    }

    public String toString() {
        return "[Request: " + this.name + ": " + this.type + "]";
    }
}

