/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.rephract.mop.java;

import com.headius.invokebinder.Binder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.projectodd.rephract.mop.java.ArrayCoercer;
import org.projectodd.rephract.mop.java.DefaultArrayCoercer;

public class CoercionMatrix {
    private Map<Class<?>, Map<Class<?>, CoercionEntry>> matrix = new HashMap();
    private List<ArrayCoercionEntry> arrayCoercions = new ArrayList<ArrayCoercionEntry>();

    public CoercionMatrix() throws NoSuchMethodException, IllegalAccessException {
        this.initDefaultIntegerCoercions();
        this.initDefaultPrimitiveIntegerCoercions();
        this.initDefaultLongCoercions();
        this.initDefaultPrimitiveLongCoercions();
        this.initDefaultShortCoercions();
        this.initDefaultPrimitiveShortCoercions();
        this.initDefaultDoubleCoercions();
        this.initDefaultPrimitiveDoubleCoercions();
        this.initDefaultFloatCoercions();
        this.initDefaultPrimitiveFloatCoercions();
        this.initDefaultBooleanCoercions();
        this.initDefaultPrimitiveBooleanCoercions();
        this.initDefaultPrimitiveByteCoercions();
        this.initDefaultCharCoercions();
        this.initDefaultPrimitiveCharCoercions();
        this.initDefaultArrayCoercions();
    }

    protected void addCoercion(int distance, Class<?> toType, Class<?> fromType, MethodHandle filter) {
        Map<Class<?>, CoercionEntry> row = this.matrix.get(toType);
        if (row == null) {
            row = new HashMap();
            this.matrix.put(toType, row);
        }
        row.put(fromType, new CoercionEntry(distance, filter));
    }

    protected void addArrayCoercion(int distance, Class<?> toType, Class<?> fromType, ArrayCoercer arrayCoercer) throws IllegalAccessException, NoSuchMethodException {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        String coerceMethod = "coerceToObjectInternal";
        if (toType.equals(boolean[].class)) {
            coerceMethod = "coerceToBoolean";
        } else if (toType.equals(byte[].class)) {
            coerceMethod = "coerceToByte";
        } else if (toType.equals(char[].class)) {
            coerceMethod = "coerceToChar";
        } else if (toType.equals(double[].class)) {
            coerceMethod = "coerceToDouble";
        } else if (toType.equals(float[].class)) {
            coerceMethod = "coerceToFloat";
        } else if (toType.equals(int[].class)) {
            coerceMethod = "coerceToInt";
        } else if (toType.equals(long[].class)) {
            coerceMethod = "coerceToLong";
        } else if (toType.equals(short[].class)) {
            coerceMethod = "coerceToShort";
        }
        MethodHandle filter = Binder.from(toType, Object.class, (Class[])new Class[0]).insert(0, new Object[]{arrayCoercer}).invokeVirtual(lookup, coerceMethod);
        this.arrayCoercions.add(new ArrayCoercionEntry(distance, filter, fromType, toType, arrayCoercer));
    }

    public int isCompatible(Class<?> target, Class<?> actual) {
        if (actual == null || target.isAssignableFrom(actual)) {
            return 0;
        }
        Map<Class<?>, CoercionEntry> row = this.matrix.get(target);
        if (row == null) {
            return -1;
        }
        CoercionEntry entry = row.get(actual);
        if (entry != null) {
            return entry.distance;
        }
        return -1;
    }

    public int isCompatible(Class<?> target, Object actual) {
        ArrayCoercionEntry arrayCoercion;
        int typesAreCompatible = this.isCompatible(target, actual.getClass());
        if (typesAreCompatible < 0 && (arrayCoercion = this.getArrayCoercion(target, actual)) != null) {
            return arrayCoercion.distance;
        }
        return typesAreCompatible;
    }

    protected ArrayCoercionEntry getArrayCoercion(Class<?> target, Object actual) {
        block0: for (ArrayCoercionEntry arrayCoercion : this.arrayCoercions) {
            if (!arrayCoercion.toType.isAssignableFrom(target) || !arrayCoercion.fromType.isAssignableFrom(actual.getClass())) continue;
            Object[] arrayArgs = arrayCoercion.arrayCoercer.coerceToObject(actual);
            for (int i = 0; i < arrayArgs.length; ++i) {
                int arrayParamDistance;
                int n = arrayParamDistance = arrayArgs[i] == null ? 0 : this.isCompatible(target.getComponentType(), arrayArgs[i]);
                if (arrayParamDistance < 0) continue block0;
            }
            return arrayCoercion;
        }
        return null;
    }

    public MethodHandle getFilter(Class<?> target, Class<?> actual) {
        Map<Class<?>, CoercionEntry> row = this.matrix.get(target);
        if (row == null) {
            return MethodHandles.identity(target);
        }
        CoercionEntry entry = row.get(actual);
        if (entry != null) {
            return entry.filter;
        }
        return MethodHandles.identity(target);
    }

    public MethodHandle getFilter(Class<?> target, Object actual) {
        Map<Class<?>, CoercionEntry> row = this.matrix.get(target);
        if (row == null) {
            ArrayCoercionEntry arrayCoercion = this.getArrayCoercion(target, actual);
            if (arrayCoercion != null) {
                return arrayCoercion.filter.asType(MethodType.methodType(target, actual.getClass()));
            }
            return MethodHandles.identity(target);
        }
        CoercionEntry entry = row.get(actual.getClass());
        if (entry != null) {
            return entry.filter;
        }
        return MethodHandles.identity(target);
    }

    private void initDefaultIntegerCoercions() throws NoSuchMethodException, IllegalAccessException {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        this.addCoercion(0, Integer.class, Integer.TYPE, MethodHandles.identity(Integer.TYPE));
        this.addCoercion(0, Integer.class, Integer.class, MethodHandles.identity(Integer.class));
        this.addCoercion(1, Integer.class, Long.class, lookup.findStatic(CoercionMatrix.class, "numberToInteger", MethodType.methodType(Integer.class, Number.class)));
        this.addCoercion(1, Integer.class, Short.class, lookup.findStatic(CoercionMatrix.class, "numberToInteger", MethodType.methodType(Integer.class, Number.class)));
        this.addCoercion(2, Integer.class, Float.class, lookup.findStatic(CoercionMatrix.class, "numberToInteger", MethodType.methodType(Integer.class, Number.class)));
        this.addCoercion(2, Integer.class, Double.class, lookup.findStatic(CoercionMatrix.class, "numberToInteger", MethodType.methodType(Integer.class, Number.class)));
    }

    private void initDefaultPrimitiveIntegerCoercions() throws NoSuchMethodException, IllegalAccessException {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        this.addCoercion(0, Integer.TYPE, Integer.TYPE, MethodHandles.identity(Integer.TYPE));
        this.addCoercion(0, Integer.TYPE, Integer.class, MethodHandles.identity(Integer.TYPE));
        this.addCoercion(1, Integer.TYPE, Short.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveInteger", MethodType.methodType(Integer.TYPE, Number.class)));
        this.addCoercion(1, Integer.TYPE, Long.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveInteger", MethodType.methodType(Integer.TYPE, Number.class)));
        this.addCoercion(2, Integer.TYPE, Double.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveInteger", MethodType.methodType(Integer.TYPE, Number.class)));
        this.addCoercion(2, Integer.TYPE, Float.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveInteger", MethodType.methodType(Integer.TYPE, Number.class)));
    }

    private void initDefaultPrimitiveByteCoercions() throws NoSuchMethodException, IllegalAccessException {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        this.addCoercion(0, Byte.TYPE, Byte.TYPE, MethodHandles.identity(Byte.TYPE));
        this.addCoercion(0, Byte.TYPE, Byte.class, MethodHandles.identity(Byte.TYPE));
        this.addCoercion(1, Byte.TYPE, Short.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveByte", MethodType.methodType(Byte.TYPE, Number.class)));
        this.addCoercion(1, Byte.TYPE, Integer.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveByte", MethodType.methodType(Byte.TYPE, Number.class)));
        this.addCoercion(1, Byte.TYPE, Long.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveByte", MethodType.methodType(Byte.TYPE, Number.class)));
        this.addCoercion(2, Byte.TYPE, Double.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveByte", MethodType.methodType(Byte.TYPE, Number.class)));
        this.addCoercion(2, Byte.TYPE, Float.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveByte", MethodType.methodType(Byte.TYPE, Number.class)));
    }

    private void initDefaultDoubleCoercions() throws NoSuchMethodException, IllegalAccessException {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        this.addCoercion(0, Double.class, Double.TYPE, MethodHandles.identity(Double.TYPE));
        this.addCoercion(0, Double.class, Double.class, MethodHandles.identity(Double.class));
        this.addCoercion(1, Double.class, Float.class, lookup.findStatic(CoercionMatrix.class, "numberToDouble", MethodType.methodType(Double.class, Number.class)));
        this.addCoercion(2, Double.class, Short.class, lookup.findStatic(CoercionMatrix.class, "numberToDouble", MethodType.methodType(Double.class, Number.class)));
        this.addCoercion(2, Double.class, Integer.class, lookup.findStatic(CoercionMatrix.class, "numberToDouble", MethodType.methodType(Double.class, Number.class)));
        this.addCoercion(2, Double.class, Long.class, lookup.findStatic(CoercionMatrix.class, "numberToDouble", MethodType.methodType(Double.class, Number.class)));
    }

    private void initDefaultPrimitiveDoubleCoercions() throws NoSuchMethodException, IllegalAccessException {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        this.addCoercion(0, Double.TYPE, Double.TYPE, MethodHandles.identity(Double.TYPE));
        this.addCoercion(0, Double.TYPE, Double.class, MethodHandles.identity(Double.TYPE));
        this.addCoercion(1, Double.TYPE, Float.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveDouble", MethodType.methodType(Double.TYPE, Number.class)));
        this.addCoercion(2, Double.TYPE, Short.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveDouble", MethodType.methodType(Double.TYPE, Number.class)));
        this.addCoercion(2, Double.TYPE, Integer.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveDouble", MethodType.methodType(Double.TYPE, Number.class)));
        this.addCoercion(2, Double.TYPE, Long.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveDouble", MethodType.methodType(Double.TYPE, Number.class)));
    }

    private void initDefaultFloatCoercions() throws NoSuchMethodException, IllegalAccessException {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        this.addCoercion(0, Float.class, Float.TYPE, MethodHandles.identity(Float.TYPE));
        this.addCoercion(0, Float.class, Float.class, MethodHandles.identity(Float.class));
        this.addCoercion(1, Float.class, Double.class, lookup.findStatic(CoercionMatrix.class, "numberToFloat", MethodType.methodType(Float.class, Number.class)));
        this.addCoercion(2, Float.class, Short.class, lookup.findStatic(CoercionMatrix.class, "numberToFloat", MethodType.methodType(Float.class, Number.class)));
        this.addCoercion(2, Float.class, Integer.class, lookup.findStatic(CoercionMatrix.class, "numberToFloat", MethodType.methodType(Float.class, Number.class)));
        this.addCoercion(2, Float.class, Long.class, lookup.findStatic(CoercionMatrix.class, "numberToFloat", MethodType.methodType(Float.class, Number.class)));
    }

    private void initDefaultPrimitiveFloatCoercions() throws NoSuchMethodException, IllegalAccessException {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        this.addCoercion(0, Float.TYPE, Float.TYPE, MethodHandles.identity(Float.TYPE));
        this.addCoercion(0, Float.TYPE, Float.class, MethodHandles.identity(Float.TYPE));
        this.addCoercion(1, Float.TYPE, Double.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveFloat", MethodType.methodType(Float.TYPE, Number.class)));
        this.addCoercion(2, Float.TYPE, Short.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveFloat", MethodType.methodType(Float.TYPE, Number.class)));
        this.addCoercion(2, Float.TYPE, Integer.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveFloat", MethodType.methodType(Float.TYPE, Number.class)));
        this.addCoercion(2, Float.TYPE, Long.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveFloat", MethodType.methodType(Float.TYPE, Number.class)));
    }

    private void initDefaultLongCoercions() throws NoSuchMethodException, IllegalAccessException {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        this.addCoercion(0, Long.class, Long.TYPE, MethodHandles.identity(Long.TYPE));
        this.addCoercion(0, Long.class, Long.class, MethodHandles.identity(Long.class));
        this.addCoercion(1, Long.class, Short.class, lookup.findStatic(CoercionMatrix.class, "numberToLong", MethodType.methodType(Long.class, Number.class)));
        this.addCoercion(1, Long.class, Integer.class, lookup.findStatic(CoercionMatrix.class, "numberToLong", MethodType.methodType(Long.class, Number.class)));
        this.addCoercion(2, Long.class, Float.class, lookup.findStatic(CoercionMatrix.class, "numberToLong", MethodType.methodType(Long.class, Number.class)));
        this.addCoercion(2, Long.class, Double.class, lookup.findStatic(CoercionMatrix.class, "numberToLong", MethodType.methodType(Long.class, Number.class)));
    }

    private void initDefaultPrimitiveLongCoercions() throws NoSuchMethodException, IllegalAccessException {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        this.addCoercion(0, Long.TYPE, Long.TYPE, MethodHandles.identity(Long.TYPE));
        this.addCoercion(0, Long.TYPE, Long.class, MethodHandles.identity(Long.TYPE));
        this.addCoercion(1, Long.TYPE, Short.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveLong", MethodType.methodType(Long.TYPE, Number.class)));
        this.addCoercion(1, Long.TYPE, Integer.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveLong", MethodType.methodType(Long.TYPE, Number.class)));
        this.addCoercion(2, Long.TYPE, Float.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveLong", MethodType.methodType(Long.TYPE, Number.class)));
        this.addCoercion(2, Long.TYPE, Double.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveLong", MethodType.methodType(Long.TYPE, Number.class)));
    }

    private void initDefaultShortCoercions() throws NoSuchMethodException, IllegalAccessException {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        this.addCoercion(0, Short.class, Short.TYPE, MethodHandles.identity(Short.TYPE));
        this.addCoercion(0, Short.class, Short.class, MethodHandles.identity(Short.class));
        this.addCoercion(1, Short.class, Long.class, lookup.findStatic(CoercionMatrix.class, "numberToShort", MethodType.methodType(Short.class, Number.class)));
        this.addCoercion(1, Short.class, Integer.class, lookup.findStatic(CoercionMatrix.class, "numberToShort", MethodType.methodType(Short.class, Number.class)));
        this.addCoercion(2, Short.class, Float.class, lookup.findStatic(CoercionMatrix.class, "numberToShort", MethodType.methodType(Short.class, Number.class)));
        this.addCoercion(2, Short.class, Double.class, lookup.findStatic(CoercionMatrix.class, "numberToShort", MethodType.methodType(Short.class, Number.class)));
    }

    private void initDefaultPrimitiveShortCoercions() throws NoSuchMethodException, IllegalAccessException {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        this.addCoercion(0, Short.TYPE, Short.TYPE, MethodHandles.identity(Short.TYPE));
        this.addCoercion(0, Short.TYPE, Short.class, MethodHandles.identity(Short.TYPE));
        this.addCoercion(1, Short.TYPE, Long.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveShort", MethodType.methodType(Short.TYPE, Number.class)));
        this.addCoercion(1, Short.TYPE, Integer.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveShort", MethodType.methodType(Short.TYPE, Number.class)));
        this.addCoercion(2, Short.TYPE, Float.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveShort", MethodType.methodType(Short.TYPE, Number.class)));
        this.addCoercion(2, Short.TYPE, Double.class, lookup.findStatic(CoercionMatrix.class, "numberToPrimitiveShort", MethodType.methodType(Short.TYPE, Number.class)));
    }

    private void initDefaultBooleanCoercions() throws NoSuchMethodException, IllegalAccessException {
        this.addCoercion(0, Boolean.class, Boolean.TYPE, MethodHandles.identity(Boolean.TYPE));
        this.addCoercion(0, Boolean.class, Boolean.class, MethodHandles.identity(Boolean.class));
    }

    private void initDefaultPrimitiveBooleanCoercions() throws NoSuchMethodException, IllegalAccessException {
        this.addCoercion(0, Boolean.TYPE, Boolean.TYPE, MethodHandles.identity(Boolean.TYPE));
        this.addCoercion(0, Boolean.TYPE, Boolean.class, MethodHandles.identity(Boolean.TYPE));
    }

    private void initDefaultCharCoercions() throws NoSuchMethodException, IllegalAccessException {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        this.addCoercion(0, Character.class, Character.TYPE, MethodHandles.identity(Character.TYPE));
        this.addCoercion(0, Character.class, Character.class, MethodHandles.identity(Character.class));
        this.addCoercion(1, Character.class, String.class, lookup.findStatic(CoercionMatrix.class, "stringToCharacter", MethodType.methodType(Character.class, String.class)));
    }

    private void initDefaultPrimitiveCharCoercions() throws NoSuchMethodException, IllegalAccessException {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        this.addCoercion(0, Character.TYPE, Character.TYPE, MethodHandles.identity(Character.TYPE));
        this.addCoercion(0, Character.TYPE, Character.class, MethodHandles.identity(Character.TYPE));
        this.addCoercion(1, Character.TYPE, String.class, lookup.findStatic(CoercionMatrix.class, "stringToPrimitiveCharacter", MethodType.methodType(Character.TYPE, String.class)));
    }

    private void initDefaultArrayCoercions() throws NoSuchMethodException, IllegalAccessException {
        this.addArrayCoercion(2, Object[].class, Object[].class, new DefaultArrayCoercer());
    }

    public static Integer numberToInteger(Number value) {
        return value.intValue();
    }

    public static int numberToPrimitiveInteger(Number value) {
        return value.intValue();
    }

    public static byte numberToPrimitiveByte(Number value) {
        return value.byteValue();
    }

    public static Long numberToLong(Number value) {
        return value.longValue();
    }

    public static long numberToPrimitiveLong(Number value) {
        return value.longValue();
    }

    public static Short numberToShort(Number value) {
        return value.shortValue();
    }

    public static short numberToPrimitiveShort(Number value) {
        return value.shortValue();
    }

    public static Double numberToDouble(Number value) {
        return value.doubleValue();
    }

    public static double numberToPrimitiveDouble(Number value) {
        return value.doubleValue();
    }

    public static Float numberToFloat(Number value) {
        return Float.valueOf(value.floatValue());
    }

    public static float numberToPrimitiveFloat(Number value) {
        return value.floatValue();
    }

    public static Character stringToCharacter(String value) {
        return new Character(CoercionMatrix.stringToPrimitiveCharacter(value));
    }

    public static char stringToPrimitiveCharacter(String value) {
        return value.length() > 0 ? value.charAt(0) : (char)'\u0000';
    }

    private static class ArrayCoercionEntry
    extends CoercionEntry {
        Class<?> fromType;
        Class<?> toType;
        ArrayCoercer arrayCoercer;

        ArrayCoercionEntry(int distance, MethodHandle filter, Class<?> fromType, Class<?> toType, ArrayCoercer arrayCoercer) {
            super(distance, filter);
            this.fromType = fromType;
            this.toType = toType;
            this.arrayCoercer = arrayCoercer;
        }
    }

    private static class CoercionEntry {
        int distance;
        MethodHandle filter;

        CoercionEntry(int distance, MethodHandle filter) {
            this.distance = distance;
            this.filter = filter;
        }
    }
}

