/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.rephract.mop.java;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import org.projectodd.rephract.mop.java.AbstractDynamicMember;
import org.projectodd.rephract.mop.java.CoercionMatrix;
import org.projectodd.rephract.mop.java.InvocationPlan;

public class DynamicConstructor
extends AbstractDynamicMember {
    private List<MethodHandle> constructors = new ArrayList<MethodHandle>();

    public DynamicConstructor(CoercionMatrix coercionMatrix) {
        super(coercionMatrix);
    }

    public void addConstructorHandle(MethodHandle method) {
        this.constructors.add(method);
    }

    public InvocationPlan findConstructorInvocationPlan(Object[] args) {
        CoercionMatrix matrix = this.getCoercionMatrix();
        int matchedIndex = -1;
        int bestDistance = Integer.MAX_VALUE;
        int numMethods = this.constructors.size();
        block0: for (int i = 0; i < numMethods; ++i) {
            MethodHandle each = this.constructors.get(i);
            int methodDistance = 0;
            Class<?>[] paramTypes = each.type().parameterArray();
            if (paramTypes.length != args.length) continue;
            for (int j = 0; j < paramTypes.length; ++j) {
                int paramDistance;
                int n = paramDistance = args[j] == null ? 0 : matrix.isCompatible(paramTypes[j], args[j]);
                if (paramDistance < 0) continue block0;
                methodDistance += paramDistance;
            }
            if (methodDistance >= bestDistance) continue;
            matchedIndex = i;
            bestDistance = methodDistance;
        }
        if (matchedIndex >= 0) {
            MethodHandle matchedMethod = this.constructors.get(matchedIndex);
            Class<?>[] paramTypes = matchedMethod.type().parameterArray();
            MethodHandle[] filters = new MethodHandle[paramTypes.length];
            for (int j = 0; j < paramTypes.length; ++j) {
                filters[j] = matrix.getFilter(paramTypes[j], args[j]);
            }
            return new InvocationPlan(matchedMethod, filters);
        }
        return null;
    }
}

