/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.rephract.mop.java;

import com.headius.invokebinder.Binder;
import java.lang.invoke.MethodHandle;
import org.projectodd.rephract.LinkLogger;
import org.projectodd.rephract.NullLinkLogger;
import org.projectodd.rephract.StrategicLink;
import org.projectodd.rephract.StrategyChain;
import org.projectodd.rephract.mop.NonContextualLinkStrategy;
import org.projectodd.rephract.mop.java.DynamicConstructor;
import org.projectodd.rephract.mop.java.DynamicMethod;
import org.projectodd.rephract.mop.java.InvocationPlan;
import org.projectodd.rephract.mop.java.Resolver;
import org.projectodd.rephract.mop.java.ResolverManager;
import org.projectodd.rephract.mop.java.ReturnFilters;

public class JavaClassLinkStrategy
extends NonContextualLinkStrategy {
    private ResolverManager manager;
    private ReturnFilters returnFilters;

    public JavaClassLinkStrategy() throws NoSuchMethodException, IllegalAccessException {
        this(new ResolverManager(), new ReturnFilters());
    }

    public JavaClassLinkStrategy(ResolverManager manager, ReturnFilters returnFilters) {
        this(new NullLinkLogger(), manager, returnFilters);
    }

    public JavaClassLinkStrategy(LinkLogger logger, ResolverManager manager, ReturnFilters returnFilters) {
        super(logger);
        this.manager = manager;
        this.returnFilters = returnFilters;
    }

    @Override
    public StrategicLink linkGetProperty(StrategyChain chain, Object receiver, String propName, Binder binder, Binder guardBinder) throws NoSuchMethodException, IllegalAccessException {
        this.log("receiver: %s // %s", receiver, propName);
        if (!(receiver instanceof Class)) {
            return chain.nextStrategy();
        }
        Resolver resolver = this.getResolver((Class)receiver);
        MethodHandle reader = resolver.getClassResolver().getPropertyReader(propName);
        this.log("reader: %s", reader);
        if (reader == null) {
            return chain.nextStrategy();
        }
        MethodHandle method = binder.drop(0, 2).convert(Object.class, new Class[]{receiver.getClass()}).filterReturn(this.returnFilters.getReturnFilter(reader)).invoke(reader);
        return new StrategicLink(method, JavaClassLinkStrategy.getReceiverClassAndNameGuard((Class)receiver, propName, guardBinder));
    }

    @Override
    public StrategicLink linkSetProperty(StrategyChain chain, Object receiver, String propName, Object value, Binder binder, Binder guardBinder) throws NoSuchMethodException, IllegalAccessException {
        if (!(receiver instanceof Class)) {
            return chain.nextStrategy();
        }
        Resolver resolver = this.getResolver((Class)receiver);
        DynamicMethod writer = resolver.getClassResolver().getPropertyWriter(propName);
        if (writer == null) {
            return chain.nextStrategy();
        }
        InvocationPlan plan = writer.findMethodInvoationPlan(new Object[]{value});
        if (plan == null) {
            return chain.nextStrategy();
        }
        MethodHandle method = binder.drop(1).convert(Object.class, new Class[]{receiver.getClass()}).filter(1, plan.getFilters()).invoke(plan.getMethodHandle());
        return new StrategicLink(method, JavaClassLinkStrategy.getReceiverClassAndNameGuard(receiver.getClass(), propName, guardBinder));
    }

    @Override
    public StrategicLink linkGetMethod(StrategyChain chain, Object receiver, String methodName, Binder binder, Binder guardBinder) throws NoSuchMethodException, IllegalAccessException {
        Resolver resolver = null;
        resolver = receiver instanceof Class ? this.getResolver((Class)receiver) : this.getResolver(receiver.getClass());
        DynamicMethod dynamicMethod = resolver.getClassResolver().getMethod(methodName);
        if (dynamicMethod == null) {
            return chain.nextStrategy();
        }
        MethodHandle method = binder.drop(0, 2).insert(0, new Object[]{dynamicMethod}).identity();
        return new StrategicLink(method, JavaClassLinkStrategy.getReceiverClassAndNameGuard(receiver.getClass(), methodName, guardBinder));
    }

    @Override
    public StrategicLink linkConstruct(StrategyChain chain, Object receiver, Object[] args, Binder binder, Binder guardBinder) throws NoSuchMethodException, IllegalAccessException {
        if (!(receiver instanceof Class)) {
            return chain.nextStrategy();
        }
        Resolver resolver = this.getResolver((Class)receiver);
        DynamicConstructor dynamicCtor = resolver.getClassResolver().getConstructor();
        InvocationPlan plan = dynamicCtor.findConstructorInvocationPlan(args);
        if (plan == null) {
            return chain.nextStrategy();
        }
        Class[] spreadTypes = new Class[args.length];
        for (int i = 0; i < spreadTypes.length; ++i) {
            spreadTypes[i] = Object.class;
        }
        MethodHandle ctor = binder.drop(0).spread(spreadTypes).filter(0, plan.getFilters()).filterReturn(this.returnFilters.getReturnFilter(plan.getMethodHandle())).invoke(plan.getMethodHandle());
        MethodHandle guard = this.getConstructGuard((Class)receiver, args, guardBinder);
        return new StrategicLink(ctor, guard);
    }

    @Override
    public StrategicLink linkCall(StrategyChain chain, Object receiver, Object self, Object[] args, Binder binder, Binder guardBinder) throws NoSuchMethodException, IllegalAccessException {
        if (receiver instanceof DynamicMethod && ((DynamicMethod)receiver).isStatic()) {
            DynamicMethod dynamicMethod = (DynamicMethod)receiver;
            InvocationPlan plan = dynamicMethod.findMethodInvoationPlan(args);
            if (plan == null) {
                return chain.nextStrategy();
            }
            Class[] spreadTypes = new Class[args.length];
            for (int i = 0; i < spreadTypes.length; ++i) {
                spreadTypes[i] = Object.class;
            }
            MethodHandle method = binder.drop(0, 2).spread(spreadTypes).filter(0, plan.getFilters()).filterReturn(this.returnFilters.getReturnFilter(plan.getMethodHandle())).invoke(plan.getMethodHandle());
            MethodHandle guard = this.getCallGuard(self, dynamicMethod, args, guardBinder);
            return new StrategicLink(method, guard);
        }
        return chain.nextStrategy();
    }

    private MethodHandle getCallGuard(Object self, DynamicMethod dynamicMethod, Object[] args, Binder binder) throws NoSuchMethodException, IllegalAccessException {
        Class[] argClasses = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argClasses[i] = args[i].getClass();
        }
        return binder.insert(3, new Object[]{self.getClass()}).insert(4, new Object[]{dynamicMethod.getName()}).insert(5, new Object[]{argClasses}).invokeStatic(JavaClassLinkStrategy.lookup(), JavaClassLinkStrategy.class, "callGuard");
    }

    public static boolean callGuard(Object receiver, Object self, Object[] args, Class<?> expectedReceiverClass, String expectedName, Class<?>[] expectedArgClasses) {
        if (!expectedReceiverClass.isAssignableFrom(self.getClass())) {
            return false;
        }
        if (!(receiver instanceof DynamicMethod) || !((DynamicMethod)receiver).getName().equals(expectedName)) {
            return false;
        }
        if (args.length != expectedArgClasses.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (expectedArgClasses[i].isAssignableFrom(args[i].getClass())) continue;
            return false;
        }
        return true;
    }

    private MethodHandle getConstructGuard(Class<?> targetClass, Object[] args, Binder binder) throws NoSuchMethodException, IllegalAccessException {
        Class[] argClasses = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argClasses[i] = args[i].getClass();
        }
        return binder.insert(2, new Object[]{targetClass}).insert(3, new Object[]{argClasses}).invokeStatic(JavaClassLinkStrategy.lookup(), JavaClassLinkStrategy.class, "constructGuard");
    }

    public static boolean constructGuard(Object targetClass, Object[] args, Class<?> expectedTargetClass, Class<?>[] expectedArgClasses) {
        if (targetClass != expectedTargetClass) {
            return false;
        }
        if (args.length != expectedArgClasses.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (expectedArgClasses[i].isAssignableFrom(args[i].getClass())) continue;
            return false;
        }
        return true;
    }

    private Resolver getResolver(Class<?> targetClass) {
        return this.manager.getResolver(targetClass);
    }
}

