/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.rephract.mop.java;

import com.headius.invokebinder.Binder;
import java.lang.invoke.MethodHandle;
import org.projectodd.rephract.StrategicLink;
import org.projectodd.rephract.StrategyChain;
import org.projectodd.rephract.mop.NonContextualLinkStrategy;
import org.projectodd.rephract.mop.java.BoundDynamicMethod;
import org.projectodd.rephract.mop.java.DynamicMethod;
import org.projectodd.rephract.mop.java.InvocationPlan;
import org.projectodd.rephract.mop.java.Resolver;
import org.projectodd.rephract.mop.java.ResolverManager;
import org.projectodd.rephract.mop.java.ReturnFilters;

public class JavaInstanceLinkStrategy
extends NonContextualLinkStrategy {
    private final ReturnFilters returnFilters;
    private final ResolverManager manager;

    public JavaInstanceLinkStrategy() throws NoSuchMethodException, IllegalAccessException {
        this(new ResolverManager(), new ReturnFilters());
    }

    public JavaInstanceLinkStrategy(ResolverManager manager, ReturnFilters returnFilters) {
        this.manager = manager;
        this.returnFilters = returnFilters;
    }

    @Override
    public StrategicLink linkGetProperty(StrategyChain chain, Object receiver, String propName, Binder binder, Binder guardBinder) throws NoSuchMethodException, IllegalAccessException {
        Resolver resolver = this.getResolver(receiver.getClass());
        MethodHandle reader = resolver.getInstanceResolver().getPropertyReader(propName);
        if (reader != null) {
            MethodHandle method = binder.drop(1).convert(Object.class, new Class[]{receiver.getClass()}).filterReturn(this.returnFilters.getReturnFilter(reader)).invoke(reader);
            return new StrategicLink(method, JavaInstanceLinkStrategy.getReceiverClassAndNameGuard(receiver.getClass(), propName, guardBinder));
        }
        DynamicMethod candidateMethod = resolver.getInstanceResolver().getMethod(propName);
        if (candidateMethod == null) {
            DynamicMethod get = resolver.getInstanceResolver().getMethod("get");
            if (get == null) {
                return chain.nextStrategy();
            }
            InvocationPlan plan = get.findMethodInvoationPlan(new Object[]{propName});
            if (plan == null) {
                return chain.nextStrategy();
            }
            MethodHandle method = binder.convert(Object.class, new Class[]{Object.class, Object.class}).invoke(plan.getMethodHandle());
            return new StrategicLink(method, JavaInstanceLinkStrategy.getReceiverClassAndNameGuard(receiver.getClass(), propName, guardBinder));
        }
        return chain.nextStrategy();
    }

    @Override
    public StrategicLink linkGetMethod(StrategyChain chain, Object receiver, String methodName, Binder binder, Binder guardBinder) throws NoSuchMethodException, IllegalAccessException {
        Resolver resolver = this.getResolver(receiver.getClass());
        DynamicMethod dynamicMethod = resolver.getInstanceResolver().getMethod(methodName);
        if (dynamicMethod == null) {
            return chain.nextStrategy();
        }
        MethodHandle method = binder.drop(0, 2).insert(0, new Object[]{dynamicMethod}).identity();
        return new StrategicLink(method, JavaInstanceLinkStrategy.getReceiverClassAndNameGuard(receiver.getClass(), methodName, guardBinder));
    }

    @Override
    public StrategicLink linkSetProperty(StrategyChain chain, Object receiver, String propName, Object value, Binder binder, Binder guardBinder) throws NoSuchMethodException, IllegalAccessException {
        InvocationPlan plan;
        Resolver resolver = this.getResolver(receiver.getClass());
        DynamicMethod dynamicWriter = resolver.getInstanceResolver().getPropertyWriter(propName);
        if (dynamicWriter != null && (plan = dynamicWriter.findMethodInvoationPlan(new Object[]{value})) != null) {
            MethodHandle method = binder.drop(1).convert(Void.TYPE, new Class[]{Object.class, Object.class}).filter(1, plan.getFilters()).invoke(plan.getMethodHandle());
            return new StrategicLink(method, JavaInstanceLinkStrategy.getReceiverClassAndNameGuard(receiver.getClass(), propName, guardBinder));
        }
        DynamicMethod candidateMethod = resolver.getInstanceResolver().getMethod(propName);
        if (candidateMethod == null) {
            DynamicMethod put = resolver.getInstanceResolver().getMethod("put");
            if (put == null) {
                return chain.nextStrategy();
            }
            InvocationPlan plan2 = put.findMethodInvoationPlan(new Object[]{propName, value});
            if (plan2 == null) {
                return chain.nextStrategy();
            }
            MethodHandle method = binder.convert(Void.TYPE, new Class[]{Object.class, Object.class, Object.class}).filter(1, plan2.getFilters()).invoke(plan2.getMethodHandle());
            return new StrategicLink(method, JavaInstanceLinkStrategy.getReceiverClassAndNameGuard(receiver.getClass(), propName, guardBinder));
        }
        return chain.nextStrategy();
    }

    @Override
    public StrategicLink linkCall(StrategyChain chain, Object receiver, Object self, Object[] args, Binder binder, Binder guardBinder) throws NoSuchMethodException, IllegalAccessException {
        if (receiver instanceof DynamicMethod && !((DynamicMethod)receiver).isStatic()) {
            DynamicMethod dynamicMethod = (DynamicMethod)receiver;
            InvocationPlan plan = dynamicMethod.findMethodInvoationPlan(args);
            if (plan == null) {
                return chain.nextStrategy();
            }
            Class[] spreadTypes = new Class[args.length];
            for (int i = 0; i < spreadTypes.length; ++i) {
                spreadTypes[i] = Object.class;
            }
            if (receiver instanceof BoundDynamicMethod) {
                MethodHandle method = binder.drop(0).spread(spreadTypes).filter(0, plan.getFilters()).filterReturn(this.returnFilters.getReturnFilter(plan.getMethodHandle())).invoke(plan.getMethodHandle());
                MethodHandle guard = this.getCallGuard(((BoundDynamicMethod)receiver).getSelf(), dynamicMethod, args, guardBinder);
                return new StrategicLink(method, guard);
            }
            MethodHandle method = binder.drop(0).spread(spreadTypes).filter(1, plan.getFilters()).filterReturn(this.returnFilters.getReturnFilter(plan.getMethodHandle())).invoke(plan.getMethodHandle());
            MethodHandle guard = this.getCallGuard(self, dynamicMethod, args, guardBinder);
            return new StrategicLink(method, guard);
        }
        return chain.nextStrategy();
    }

    private MethodHandle getCallGuard(Object self, DynamicMethod dynamicMethod, Object[] args, Binder binder) throws NoSuchMethodException, IllegalAccessException {
        Class[] argClasses = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argClasses[i] = args[i].getClass();
        }
        return binder.insert(3, new Object[]{self.getClass()}).insert(4, new Object[]{dynamicMethod.getName()}).insert(5, new Object[]{argClasses}).invokeStatic(JavaInstanceLinkStrategy.lookup(), JavaInstanceLinkStrategy.class, "callGuard");
    }

    public static boolean callGuard(Object receiver, Object self, Object[] args, Class<?> expectedReceiverClass, String expectedName, Class<?>[] expectedArgClasses) {
        if (!expectedReceiverClass.isAssignableFrom(self.getClass())) {
            return false;
        }
        if (!(receiver instanceof DynamicMethod) || !((DynamicMethod)receiver).getName().equals(expectedName)) {
            return false;
        }
        if (args.length != expectedArgClasses.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (expectedArgClasses[i].isAssignableFrom(args[i].getClass())) continue;
            return false;
        }
        return true;
    }

    private Resolver getResolver(Class<?> targetClass) {
        return this.manager.getResolver(targetClass);
    }
}

