/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl;

import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.CommandLineParser;
import org.jboss.aesh.cl.ParsedCompleteObject;
import org.jboss.aesh.cl.ParsedOption;
import org.jboss.aesh.cl.exception.CommandLineParserException;
import org.jboss.aesh.cl.internal.ParameterInt;
import org.jboss.aesh.util.Parser;

public class CommandLineCompletionParser {
    private CommandLineParser parser;

    public CommandLineCompletionParser(CommandLineParser parser) {
        this.parser = parser;
    }

    public ParsedCompleteObject findCompleteObject(String line) throws CommandLineParserException {
        if (Parser.findIfWordEndWithSpace(line)) {
            for (ParameterInt param : this.parser.getParameters()) {
                if (!line.trim().equals(param.getName())) continue;
                return new ParsedCompleteObject(false, null, 0);
            }
            String lastWord = Parser.findEscapedSpaceWordCloseToEnd(line.trim());
            if (lastWord.startsWith("-")) {
                while (lastWord.startsWith("-")) {
                    lastWord = lastWord.substring(1);
                }
                if (lastWord.length() == 0) {
                    return new ParsedCompleteObject(false, null, 0);
                }
                if (this.parser.getParameters().get(0).findOption(lastWord) != null || this.parser.getParameters().get(0).findLongOption(lastWord) != null) {
                    return this.findCompleteObjectValue(line, true);
                }
                return new ParsedCompleteObject(false, null, 0);
            }
            return new ParsedCompleteObject(true);
        }
        return this.optionFinder(line);
    }

    private ParsedCompleteObject optionFinder(String line) throws CommandLineParserException {
        String lastWord = Parser.findEscapedSpaceWordCloseToEnd(line);
        if (lastWord.startsWith("-")) {
            String secLastWord = Parser.findEscapedSpaceWordCloseToEnd(line.substring(0, line.length() - lastWord.length()));
            if (secLastWord.startsWith("-")) {
                return this.findCompleteObjectValue(line, false);
            }
            if (lastWord.equals("-")) {
                return new ParsedCompleteObject(true, "", 1);
            }
            if (lastWord.equals("--")) {
                return new ParsedCompleteObject(true, "", 2);
            }
            return new ParsedCompleteObject(true, Parser.trimOptionName(lastWord), lastWord.length());
        }
        return this.findCompleteObjectValue(line, false);
    }

    private ParsedCompleteObject findCompleteObjectValue(String line, boolean endsWithSpace) throws CommandLineParserException {
        CommandLine cl = this.parser.parse(line, true);
        if (cl.getArguments().isEmpty()) {
            ParsedOption po = cl.getOptions().get(cl.getOptions().size() - 1);
            return new ParsedCompleteObject(po.getLongName().isEmpty() ? po.getName() : po.getLongName(), endsWithSpace ? "" : po.getValue(), po.getType(), true);
        }
        return new ParsedCompleteObject("", cl.getArguments().get(cl.getArguments().size() - 1), this.parser.getParameters().get(0).getArgumentType(), false);
    }
}

