/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.OptionProperty;
import org.jboss.aesh.cl.ParsedOption;
import org.jboss.aesh.cl.exception.ArgumentParserException;
import org.jboss.aesh.cl.exception.CommandLineParserException;
import org.jboss.aesh.cl.exception.OptionParserException;
import org.jboss.aesh.cl.exception.RequiredOptionException;
import org.jboss.aesh.cl.internal.OptionInt;
import org.jboss.aesh.cl.internal.ParameterInt;
import org.jboss.aesh.util.Parser;

public class CommandLineParser {
    private List<ParameterInt> params = new ArrayList<ParameterInt>();
    private static final String EQUALS = "=";

    public CommandLineParser(List<ParameterInt> parameters) {
        this.params.addAll(parameters);
    }

    public CommandLineParser(ParameterInt parameterInt) {
        this.params.add(parameterInt);
    }

    public CommandLineParser(String name, String usage) {
        this.params.add(new ParameterInt(name, usage));
    }

    public void addParameter(ParameterInt param) {
        this.params.add(param);
    }

    public List<ParameterInt> getParameters() {
        return this.params;
    }

    public String printHelp() {
        StringBuilder builder = new StringBuilder();
        for (ParameterInt param : this.params) {
            builder.append(param.printHelp());
        }
        return builder.toString();
    }

    public CommandLine parse(String line) throws CommandLineParserException {
        return this.parse(line, false);
    }

    public CommandLine parse(String line, boolean ignoreMissingRequirements) throws CommandLineParserException {
        List<String> lines = Parser.findAllWords(line);
        if (lines.size() > 0) {
            for (ParameterInt param : this.params) {
                if (!param.getName().equals(lines.get(0))) continue;
                return this.doParse(param, lines, ignoreMissingRequirements);
            }
        }
        throw new CommandLineParserException("Param:" + this.params + ", not found in: " + line);
    }

    private CommandLine doParse(ParameterInt param, List<String> lines, boolean ignoreMissing) throws CommandLineParserException {
        param.clean();
        CommandLine commandLine = new CommandLine();
        OptionInt active = null;
        boolean addedArgument = false;
        for (int i = 1; i < lines.size(); ++i) {
            String name;
            String parseLine = lines.get(i);
            if (parseLine.startsWith("--")) {
                if (active != null) {
                    throw new OptionParserException("Option: " + active.getDisplayName() + " must be given a value");
                }
                active = this.findLongOption(param, parseLine.substring(2));
                if (active != null && active.isProperty()) {
                    if (parseLine.length() <= 2 + active.getLongName().length() || !parseLine.contains(EQUALS)) {
                        throw new OptionParserException("Option " + active.getDisplayName() + ", must be part of a property");
                    }
                    name = parseLine.substring(2 + active.getLongName().length(), parseLine.indexOf(EQUALS));
                    String value = parseLine.substring(parseLine.indexOf(EQUALS) + 1);
                    commandLine.addOption(new ParsedOption(active.getName(), active.getLongName(), new OptionProperty(name, value), active.getType()));
                    active = null;
                    if (!addedArgument) continue;
                    throw new ArgumentParserException("An argument was given to an option that do not support it.");
                }
                if (!(active == null || active.hasValue() && active.getValue() == null)) {
                    commandLine.addOption(new ParsedOption(active.getName(), active.getLongName(), active.getValue(), active.getType()));
                    active = null;
                    if (!addedArgument) continue;
                    throw new ArgumentParserException("An argument was given to an option that do not support it.");
                }
                if (active != null) continue;
                throw new OptionParserException("Option: " + parseLine + " is not a valid option for this command");
            }
            if (parseLine.startsWith("-")) {
                if (active != null) {
                    throw new OptionParserException("Option: " + active.getDisplayName() + " must be given a value");
                }
                if (parseLine.length() != 2 && !parseLine.contains(EQUALS)) {
                    throw new OptionParserException("Option: - must be followed by a valid operator");
                }
                active = this.findOption(param, parseLine.substring(1));
                if (active != null && active.isProperty()) {
                    if (parseLine.length() <= 2 || !parseLine.contains(EQUALS)) {
                        throw new OptionParserException("Option " + active.getDisplayName() + ", must be part of a property");
                    }
                    name = parseLine.substring(2, parseLine.indexOf(EQUALS));
                    String value = parseLine.substring(parseLine.indexOf(EQUALS) + 1);
                    commandLine.addOption(new ParsedOption(active.getName(), active.getLongName(), new OptionProperty(name, value), active.getType()));
                    active = null;
                    if (!addedArgument) continue;
                    throw new OptionParserException("An argument was given to an option that do not support it.");
                }
                if (!(active == null || active.hasValue() && active.getValue() == null)) {
                    commandLine.addOption(new ParsedOption(String.valueOf(active.getName()), active.getLongName(), active.getValue(), active.getType()));
                    active = null;
                    if (!addedArgument) continue;
                    throw new OptionParserException("An argument was given to an option that do not support it.");
                }
                if (active != null) continue;
                throw new OptionParserException("Option: " + parseLine + " is not a valid option for this command");
            }
            if (active != null) {
                if (active.hasMultipleValues()) {
                    if (parseLine.contains(String.valueOf(active.getValueSeparator()))) {
                        for (String value : parseLine.split(String.valueOf(active.getValueSeparator()))) {
                            active.addValue(value.trim());
                        }
                    }
                } else {
                    active.addValue(parseLine);
                }
                commandLine.addOption(new ParsedOption(active.getName(), active.getLongName(), active.getValues(), active.getType()));
                active = null;
                if (!addedArgument) continue;
                throw new OptionParserException("An argument was given to an option that do not support it.");
            }
            commandLine.addArgument(parseLine);
            addedArgument = true;
        }
        if (active != null && ignoreMissing) {
            commandLine.addOption(new ParsedOption(active.getName(), active.getLongName(), active.getValues(), active.getType()));
        }
        if (!ignoreMissing) {
            this.checkForMissingRequiredOptions(param, commandLine);
        }
        return commandLine;
    }

    private void checkForMissingRequiredOptions(ParameterInt param, CommandLine commandLine) throws CommandLineParserException {
        for (OptionInt o : param.getOptions()) {
            if (!o.isRequired()) continue;
            boolean found = false;
            for (ParsedOption po : commandLine.getOptions()) {
                if (!po.getName().equals(o.getName()) && !po.getName().equals(o.getLongName())) continue;
                found = true;
            }
            if (found) continue;
            throw new RequiredOptionException("Option: " + o.getDisplayName() + " is required for this command.");
        }
    }

    private OptionInt findOption(ParameterInt param, String line) {
        String rest;
        OptionInt option = param.findOption(line);
        if (option != null) {
            return option;
        }
        option = param.startWithOption(line);
        if (option != null && option.isProperty()) {
            return option;
        }
        if (option != null && (rest = line.substring(option.getName().length())) != null && rest.length() > 1 && rest.startsWith(EQUALS)) {
            option.addValue(rest.substring(1));
            return option;
        }
        return null;
    }

    private OptionInt findLongOption(ParameterInt param, String line) {
        String rest;
        OptionInt option = param.findLongOption(line);
        if (option != null) {
            return option;
        }
        option = param.startWithLongOption(line);
        if (option != null && option.isProperty()) {
            return option;
        }
        if (option != null && (rest = line.substring(option.getLongName().length())) != null && rest.length() > 1 && rest.startsWith(EQUALS)) {
            option.addValue(rest.substring(1));
            return option;
        }
        return null;
    }

    public String toString() {
        return "CommandLineParser{params=" + this.params + '}';
    }
}

