/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl;

import org.jboss.aesh.cl.CommandLineParser;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.cl.Parameter;
import org.jboss.aesh.cl.ParserBuilder;
import org.jboss.aesh.cl.exception.CommandLineParserException;
import org.jboss.aesh.cl.internal.ParameterInt;

public class ParserGenerator {
    public static CommandLineParser generateParser(Class<?> ... clazzes) throws CommandLineParserException {
        ParserBuilder builder = new ParserBuilder();
        for (Class<?> clazz : clazzes) {
            Parameter param = clazz.getAnnotation(Parameter.class);
            if (param == null) {
                throw new CommandLineParserException("Can only create parser from class thats annotated with Parameter");
            }
            builder.addParameter(ParserGenerator.generateParameter(param));
        }
        return builder.generateParser();
    }

    private static ParameterInt generateParameter(Parameter param) throws CommandLineParserException {
        if (param.name() == null || param.name().length() < 1) {
            throw new CommandLineParserException("The parameter name must be defined");
        }
        ParameterInt parameterInt = new ParameterInt(param.name(), param.usage(), param.argumentType());
        if (param.options() != null) {
            for (Option o : param.options()) {
                parameterInt.addOption(o.name(), o.longName(), o.description(), o.hasValue(), o.argument(), o.required(), o.valueSeparator(), o.isProperty(), o.hasMultipleValues(), o.type());
            }
        }
        return parameterInt;
    }
}

