/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.complete;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.util.Parser;

public class CompleteOperation {
    private String buffer;
    private int cursor;
    private int offset;
    private List<String> completionCandidates;
    private boolean trimmed = false;
    private int trimmedSize = 0;
    private String nonTrimmedBuffer;
    private char separator = (char)32;
    private boolean appendSeparator = true;

    public CompleteOperation(String buffer, int cursor) {
        this.setCursor(cursor);
        this.setSeparator(' ');
        this.doAppendSeparator(true);
        this.completionCandidates = new ArrayList<String>();
        this.setBuffer(buffer);
    }

    public String getBuffer() {
        return this.buffer;
    }

    private void setBuffer(String buffer) {
        if (buffer.startsWith(" ")) {
            this.trimmed = true;
            this.buffer = Parser.trimInFront(buffer);
            this.nonTrimmedBuffer = buffer;
            this.setCursor(this.cursor - this.getTrimmedSize());
        } else {
            this.buffer = buffer;
        }
    }

    public boolean isTrimmed() {
        return this.trimmed;
    }

    public int getTrimmedSize() {
        return this.nonTrimmedBuffer.length() - this.buffer.length();
    }

    public String getNonTrimmedBuffer() {
        return this.nonTrimmedBuffer;
    }

    public int getCursor() {
        return this.cursor;
    }

    private void setCursor(int cursor) {
        this.cursor = cursor < 0 ? 0 : cursor;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public boolean hasAppendSeparator() {
        return this.appendSeparator;
    }

    public void doAppendSeparator(boolean appendSeparator) {
        this.appendSeparator = appendSeparator;
    }

    public List<String> getCompletionCandidates() {
        return this.completionCandidates;
    }

    public void setCompletionCandidates(List<String> completionCandidates) {
        this.completionCandidates = completionCandidates;
    }

    public void addCompletionCandidate(String completionCandidate) {
        this.completionCandidates.add(completionCandidate);
    }

    public void addCompletionCandidates(List<String> completionCandidates) {
        this.completionCandidates.addAll(completionCandidates);
    }

    public void removeEscapedSpacesFromCompletionCandidates() {
        this.setCompletionCandidates(Parser.switchEscapedSpacesToSpacesInList(this.getCompletionCandidates()));
    }

    public List<String> getFormattedCompletionCandidates() {
        if (this.offset < this.cursor) {
            ArrayList<String> fixedCandidates = new ArrayList<String>(this.completionCandidates.size());
            int pos = this.cursor - this.offset;
            for (String c : this.completionCandidates) {
                if (c.length() >= pos) {
                    fixedCandidates.add(c.substring(pos));
                    continue;
                }
                fixedCandidates.add("");
            }
            return fixedCandidates;
        }
        return this.completionCandidates;
    }

    public String getFormattedCompletion(String completion) {
        if (this.offset < this.cursor) {
            int pos = this.cursor - this.offset;
            if (completion.length() > pos) {
                return completion.substring(pos);
            }
            return "";
        }
        return completion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Buffer: ").append(this.buffer).append(", Cursor:").append(this.cursor).append(", Offset:").append(this.offset);
        sb.append(", candidates:").append(this.completionCandidates);
        return sb.toString();
    }
}

