/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.console.settings.VariableSettings;
import org.jboss.aesh.edit.Mode;
import org.jboss.aesh.edit.mapper.KeyMapper;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.util.LoggerUtil;

public class Config {
    private static String lineSeparator = System.getProperty("line.separator");
    private static String pathSeparator = System.getProperty("file.separator");
    private static String tmpDir = System.getProperty("java.io.tmpdir");
    private static boolean posixCompatible = !System.getProperty("os.name").startsWith("Windows") && !System.getProperty("os.name").startsWith("OS/2");
    private static Logger logger = LoggerUtil.getLogger("Config");

    public static boolean isOSPOSIXCompatible() {
        return posixCompatible;
    }

    public static String getLineSeparator() {
        return lineSeparator;
    }

    public static String getPathSeparator() {
        return pathSeparator;
    }

    public static String getTmpDir() {
        return tmpDir;
    }

    public static String getHomeDir() {
        return System.getProperty("user.home");
    }

    protected static void parseInputrc(Settings settings) throws IOException {
        String line;
        if (!settings.getInputrc().isFile()) {
            if (settings.isLogging()) {
                logger.info("Error while parsing: " + settings.getInputrc().getAbsolutePath() + " couldn't find file.");
            }
            return;
        }
        Pattern variablePattern = Pattern.compile("^set\\s+(\\S+)\\s+(\\S+)$");
        Pattern commentPattern = Pattern.compile("^#.*");
        Pattern keyQuoteNamePattern = Pattern.compile("(^\"\\\\\\S+)(\":\\s+)(\\S+)");
        Pattern keyNamePattern = Pattern.compile("(^\\S+)(:\\s+)(\\S+)");
        Pattern keySeqPattern = Pattern.compile("^\"keyseq:\\s+\\b");
        Pattern startConstructs = Pattern.compile("^\\$if");
        Pattern endConstructs = Pattern.compile("^\\$endif");
        Pattern keyOperationPattern = Pattern.compile("(^\\\"\\\\M-\\[D:)(\\s+)(\\S+)");
        BufferedReader reader = new BufferedReader(new FileReader(settings.getInputrc()));
        boolean constructMode = false;
        while ((line = reader.readLine()) != null) {
            if (line.trim().length() < 1 || commentPattern.matcher(line).matches()) continue;
            if (startConstructs.matcher(line).matches()) {
                constructMode = true;
                continue;
            }
            if (endConstructs.matcher(line).matches()) {
                constructMode = false;
                continue;
            }
            if (constructMode) continue;
            Matcher variableMatcher = variablePattern.matcher(line);
            if (variableMatcher.matches()) {
                Config.parseVariables(variableMatcher.group(1), variableMatcher.group(2), settings);
            }
            if (!Config.isOSPOSIXCompatible()) continue;
            Matcher keyQuoteMatcher = keyQuoteNamePattern.matcher(line);
            if (keyQuoteMatcher.matches()) {
                settings.getOperationManager().addOperation(KeyMapper.mapQuoteKeys(keyQuoteMatcher.group(1), keyQuoteMatcher.group(3)));
                continue;
            }
            Matcher keyMatcher = keyNamePattern.matcher(line);
            if (!keyMatcher.matches()) continue;
            settings.getOperationManager().addOperation(KeyMapper.mapKeys(keyMatcher.group(1), keyMatcher.group(3)));
        }
    }

    private static void parseVariables(String variable, String value, Settings settings) {
        if (variable.equals(VariableSettings.EDITING_MODE.getVariable())) {
            if (VariableSettings.EDITING_MODE.getValues().contains(value)) {
                if (value.equals("vi")) {
                    settings.setEditMode(Mode.VI);
                } else {
                    settings.setEditMode(Mode.EMACS);
                }
            } else if (Settings.getInstance().isLogging()) {
                logger.warning("Value " + value + " not accepted for: " + variable + ", only: " + VariableSettings.EDITING_MODE.getValues());
            }
        } else if (variable.equals(VariableSettings.BELL_STYLE.getVariable())) {
            if (VariableSettings.BELL_STYLE.getValues().contains(value)) {
                settings.setBellStyle(value);
            } else if (Settings.getInstance().isLogging()) {
                logger.warning("Value " + value + " not accepted for: " + variable + ", only: " + VariableSettings.BELL_STYLE.getValues());
            }
        } else if (variable.equals(VariableSettings.HISTORY_SIZE.getVariable())) {
            try {
                settings.setHistorySize(Integer.parseInt(value));
            }
            catch (NumberFormatException nfe) {
                if (Settings.getInstance().isLogging()) {
                    logger.warning("Value " + value + " not accepted for: " + variable + ", it must be an integer.");
                }
            }
        } else if (variable.equals(VariableSettings.DISABLE_COMPLETION.getVariable())) {
            if (VariableSettings.DISABLE_COMPLETION.getValues().contains(value)) {
                if (value.equals("on")) {
                    settings.setDisableCompletion(true);
                } else {
                    settings.setDisableCompletion(false);
                }
            } else if (Settings.getInstance().isLogging()) {
                logger.warning("Value " + value + " not accepted for: " + variable + ", only: " + VariableSettings.DISABLE_COMPLETION.getValues());
            }
        }
    }

    protected static void readRuntimeProperties(Settings settings) {
        block20: {
            try {
                String disableCompletion;
                String logFile;
                String doLogging;
                String historySize;
                String historyDisabled;
                String historyPersistent;
                String historyFile;
                String inputrc;
                String readInputrc;
                String editMode;
                String term = System.getProperty("aesh.terminal");
                if (term != null && term.length() > 0) {
                    settings.setTerminal((Terminal)settings.getClass().getClassLoader().loadClass(term).newInstance());
                }
                if ((editMode = System.getProperty("aesh.editmode")) != null && editMode.length() > 0) {
                    if (editMode.equalsIgnoreCase("VI")) {
                        settings.setEditMode(Mode.VI);
                    } else if (editMode.equalsIgnoreCase("EMACS")) {
                        settings.setEditMode(Mode.EMACS);
                    }
                }
                if ((readInputrc = System.getProperty("aesh.readinputrc")) != null && readInputrc.length() > 0 && (readInputrc.equalsIgnoreCase("true") || readInputrc.equalsIgnoreCase("false"))) {
                    settings.setReadInputrc(Boolean.parseBoolean(readInputrc));
                }
                if ((inputrc = System.getProperty("aesh.inputrc")) != null && inputrc.length() > 0 && new File(inputrc).isFile()) {
                    settings.setInputrc(new File(inputrc));
                }
                if ((historyFile = System.getProperty("aesh.historyfile")) != null && historyFile.length() > 0 && new File(historyFile).isFile()) {
                    settings.setHistoryFile(new File(historyFile));
                }
                if ((historyPersistent = System.getProperty("aesh.historypersistent")) != null && historyPersistent.length() > 0 && (historyPersistent.equalsIgnoreCase("true") || historyPersistent.equalsIgnoreCase("false"))) {
                    settings.setHistoryPersistent(Boolean.parseBoolean(historyPersistent));
                }
                if ((historyDisabled = System.getProperty("aesh.historydisabled")) != null && historyDisabled.length() > 0 && (historyDisabled.equalsIgnoreCase("true") || historyDisabled.equalsIgnoreCase("false"))) {
                    settings.setHistoryDisabled(Boolean.parseBoolean(historyDisabled));
                }
                if ((historySize = System.getProperty("aesh.historysize")) != null && historySize.length() > 0) {
                    settings.setHistorySize(Integer.parseInt(historySize));
                }
                if ((doLogging = System.getProperty("aesh.logging")) != null && doLogging.length() > 0 && (doLogging.equalsIgnoreCase("true") || doLogging.equalsIgnoreCase("false"))) {
                    settings.setLogging(Boolean.parseBoolean(doLogging));
                }
                if ((logFile = System.getProperty("aesh.logfile")) != null && logFile.length() > 0) {
                    settings.setLogFile(logFile);
                }
                if ((disableCompletion = System.getProperty("aesh.disablecompletion")) != null && disableCompletion.length() > 0 && (disableCompletion.equalsIgnoreCase("true") || disableCompletion.equalsIgnoreCase("false"))) {
                    settings.setDisableCompletion(Boolean.parseBoolean(disableCompletion));
                }
            }
            catch (ClassNotFoundException e) {
                if (Settings.getInstance().isLogging()) {
                    logger.log(Level.SEVERE, "Fail while finding class: ", e);
                }
            }
            catch (InstantiationException e) {
                if (Settings.getInstance().isLogging()) {
                    logger.log(Level.SEVERE, "Fail while instantiating class: ", e);
                }
            }
            catch (IllegalAccessException e) {
                if (!Settings.getInstance().isLogging()) break block20;
                logger.log(Level.SEVERE, "Fail while accessing class: ", e);
            }
        }
    }
}

