/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console;

import java.util.List;
import org.jboss.aesh.terminal.TerminalCharacter;
import org.jboss.aesh.terminal.TerminalString;

public class Prompt {
    private String prompt;
    private Character mask;
    private String ansiString;

    public Prompt(String prompt) {
        this.prompt = prompt != null ? prompt : "";
    }

    public Prompt(String prompt, Character mask) {
        this.prompt = prompt != null ? prompt : "";
        this.mask = mask;
    }

    public Prompt(TerminalString terminalString) {
        if (terminalString != null) {
            this.ansiString = terminalString.getAsString();
            this.prompt = terminalString.getCharacters();
        } else {
            this.prompt = "";
        }
    }

    public Prompt(List<TerminalCharacter> characters) {
        this.generateOutString(characters);
    }

    public Prompt(List<TerminalCharacter> characters, Character mask) {
        this.mask = mask;
        this.generateOutString(characters);
    }

    private void generateOutString(List<TerminalCharacter> chars) {
        StringBuilder promptBuilder = new StringBuilder();
        StringBuilder builder = new StringBuilder();
        TerminalCharacter prev = null;
        for (TerminalCharacter c : chars) {
            if (prev == null) {
                builder.append(c.getAsString());
            } else {
                builder.append(c.getAsString(prev));
            }
            prev = c;
            promptBuilder.append(c.getCharacter());
        }
        this.ansiString = builder.toString();
        this.prompt = promptBuilder.toString();
    }

    public Character getMask() {
        return this.mask;
    }

    public boolean isMasking() {
        return this.mask != null;
    }

    public String getPromptAsString() {
        return this.prompt;
    }

    public int getLength() {
        return this.prompt.length();
    }

    public boolean hasANSI() {
        return this.ansiString != null;
    }

    public String getANSI() {
        return this.ansiString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Prompt)) {
            return false;
        }
        Prompt prompt1 = (Prompt)o;
        if (this.ansiString != null ? !this.ansiString.equals(prompt1.ansiString) : prompt1.ansiString != null) {
            return false;
        }
        if (this.mask != null ? !this.mask.equals(prompt1.mask) : prompt1.mask != null) {
            return false;
        }
        return this.prompt.equals(prompt1.prompt);
    }

    public int hashCode() {
        int result = this.ansiString != null ? this.ansiString.hashCode() : 0;
        result = 31 * result + this.prompt.hashCode();
        result = 31 * result + (this.mask != null ? this.mask.hashCode() : 0);
        return result;
    }
}

