/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ConsoleInputSession {
    private InputStream consoleStream;
    private InputStream externalInputStream;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private ArrayBlockingQueue<String> blockingQueue = new ArrayBlockingQueue(1000);

    public ConsoleInputSession(InputStream consoleStream) {
        this.consoleStream = consoleStream;
        this.externalInputStream = new InputStream(){
            private String b;
            private int c;

            @Override
            public int read() throws IOException {
                try {
                    if (this.b == null || this.c == this.b.length()) {
                        this.b = (String)ConsoleInputSession.this.blockingQueue.poll(365L, TimeUnit.DAYS);
                        this.c = 0;
                    }
                    if (this.b != null && !this.b.isEmpty()) {
                        return this.b.charAt(this.c++);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return -1;
            }

            @Override
            public int available() {
                if (this.b != null) {
                    return this.b.length();
                }
                return 0;
            }

            @Override
            public void close() throws IOException {
                try {
                    ConsoleInputSession.this.stop();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        this.startReader();
    }

    private void startReader() {
        Runnable reader = new Runnable(){

            @Override
            public void run() {
                while (!ConsoleInputSession.this.executorService.isShutdown()) {
                    try {
                        int read;
                        byte[] bBuf = new byte[20];
                        if (ConsoleInputSession.this.consoleStream.available() > 0 && (read = ConsoleInputSession.this.consoleStream.read(bBuf)) > 0) {
                            ConsoleInputSession.this.blockingQueue.put(new String(bBuf, 0, read));
                        }
                        Thread.sleep(10L);
                    }
                    catch (IOException e) {
                        if (ConsoleInputSession.this.executorService.isShutdown()) continue;
                        ConsoleInputSession.this.executorService.shutdown();
                        throw new RuntimeException("broken pipe");
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        this.executorService.execute(reader);
    }

    public void interruptPipe() {
        this.blockingQueue.offer("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException, InterruptedException {
        try {
            this.executorService.shutdown();
            this.blockingQueue.offer("");
        }
        finally {
            this.consoleStream.close();
        }
    }

    public InputStream getExternalInputStream() {
        return this.externalInputStream;
    }
}

