/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class InfocmpHandler {
    private Map<String, String> values;
    private final String escape = "\\E";
    private final String escAsString = "\u001b";

    public static InfocmpHandler getInstance() {
        return InfocmpHolder.INSTANCE;
    }

    private InfocmpHandler() {
        if (this.values == null) {
            this.parseInfocmp();
        }
    }

    private void parseInfocmp() {
        this.values = new HashMap<String, String>();
        this.fetchInfocmp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchInfocmp() {
        InputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            int c;
            ProcessBuilder builder = new ProcessBuilder("infocmp");
            builder.redirectErrorStream(true);
            Process process = builder.start();
            in = process.getInputStream();
            out = new ByteArrayOutputStream();
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            for (String keyValue : new String(out.toByteArray()).split(",")) {
                String[] valuePair = keyValue.split("=");
                if (valuePair.length != 2) continue;
                this.values.put(valuePair[0].trim(), valuePair[1]);
            }
            process.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public int[] getAsInts(String key) {
        if (this.values.containsKey(key)) {
            return this.convertStringToInts(this.values.get(key));
        }
        return new int[0];
    }

    private int[] convertStringToInts(String input) {
        if (input.startsWith("\\E")) {
            int[] out = new int[input.length() - 1];
            out[0] = 27;
            int counter = 1;
            char[] arr$ = input.substring(2).toCharArray();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int c;
                out[counter] = c = arr$[i$];
                ++counter;
            }
            return out;
        }
        int[] out = new int[input.length()];
        int counter = 0;
        char[] arr$ = input.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int c;
            out[counter] = c = arr$[i$];
            ++counter;
        }
        return out;
    }

    public String get(String key) {
        if (this.values.containsKey(key)) {
            return this.values.get(key).replaceAll("\\\\E", "\u001b");
        }
        return "";
    }

    private static class InfocmpHolder {
        static final InfocmpHandler INSTANCE = new InfocmpHandler();

        private InfocmpHolder() {
        }
    }
}

