/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.util.Parser;

public class FileLister {
    private static final Pattern startsWithParent = Pattern.compile("^\\.\\..*");
    private static final Pattern startsWithHomePattern = Pattern.compile("^~/*");
    private static final Pattern containParent = Config.isOSPOSIXCompatible() ? Pattern.compile("[\\.\\.[" + Config.getPathSeparator() + "]?]+") : Pattern.compile("[\\.\\.[\\\\]?]+");
    private static final Pattern space = Pattern.compile(".+\\s+.+");
    private static final Pattern startsWithSlash = Config.isOSPOSIXCompatible() ? Pattern.compile("^\\" + Config.getPathSeparator() + ".*") : Pattern.compile("^\\\\.*");
    private static final Pattern endsWithSlash = Config.isOSPOSIXCompatible() ? Pattern.compile(".*\\" + Config.getPathSeparator() + "$") : Pattern.compile(".*\\\\$");
    private String incDir;
    private File cwd;
    private String rest;
    private String lastDir;
    private FileFilter fileFilter;

    public FileLister(String incDir, File cwd) {
        if (incDir == null) {
            throw new IllegalArgumentException("Incoming directory cannot be null");
        }
        if (cwd == null) {
            throw new IllegalArgumentException("Current working directory cannot be null");
        }
        this.incDir = Parser.switchEscapedSpacesToSpacesInWord(incDir);
        this.cwd = cwd;
        this.findRestAndLastDir();
        this.setFileFilter(Filter.ALL);
    }

    public FileLister(String incDir, File cwd, Filter filter) {
        this(incDir, cwd);
        this.setFileFilter(filter);
    }

    public FileLister(String incDir, File cwd, FileFilter fileFilter) {
        this(incDir, cwd);
        this.fileFilter = fileFilter;
    }

    private void setFileFilter(Filter filter) {
        this.fileFilter = filter == Filter.ALL ? new FileAndDirectoryFilter() : (filter == Filter.FILE ? new OnlyFileFilter() : new DirectoryFileFilter());
    }

    public void findMatchingDirectories(CompleteOperation completion) {
        completion.doAppendSeparator(false);
        if (this.incDir.trim().isEmpty()) {
            completion.addCompletionCandidates(this.listDirectory(this.cwd, null));
        } else if (this.startWithHome()) {
            if (this.isHomeAndIncDirADirectory()) {
                if (this.endWithSlash()) {
                    completion.addCompletionCandidates(this.listDirectory(new File(Config.getHomeDir() + this.incDir.substring(1)), null));
                } else {
                    completion.addCompletionCandidate(Config.getPathSeparator());
                }
            } else if (this.isHomeAndIncDirAFile()) {
                completion.addCompletionCandidate("");
                completion.doAppendSeparator(true);
            } else {
                this.listPossibleDirectories(completion);
            }
        } else if (!this.startWithSlash()) {
            if (this.isCwdAndIncDirADirectory()) {
                if (this.endWithSlash()) {
                    completion.addCompletionCandidates(this.listDirectory(new File(this.cwd.getAbsolutePath() + Config.getPathSeparator() + this.incDir), null));
                } else {
                    completion.addCompletionCandidate(Config.getPathSeparator());
                }
            } else if (this.isCwdAndIncDirAFile()) {
                completion.addCompletionCandidate("");
                completion.doAppendSeparator(true);
            } else {
                this.listPossibleDirectories(completion);
            }
        } else if (this.startWithSlash()) {
            if (this.isIncDirADirectory()) {
                if (this.endWithSlash()) {
                    completion.addCompletionCandidates(this.listDirectory(new File(this.incDir), null));
                } else {
                    completion.addCompletionCandidate(Config.getPathSeparator());
                }
            } else if (this.isIncDirAFile()) {
                completion.addCompletionCandidate("");
                completion.doAppendSeparator(true);
            } else {
                this.listPossibleDirectories(completion);
            }
        }
    }

    private void listPossibleDirectories(CompleteOperation completion) {
        List<String> returnFiles = this.startWithSlash() ? (this.lastDir != null && this.lastDir.startsWith(Config.getPathSeparator()) ? this.listDirectory(new File(this.lastDir), this.rest) : this.listDirectory(new File(Config.getPathSeparator() + this.lastDir), this.rest)) : (this.startWithHome() ? (this.lastDir != null ? this.listDirectory(new File(Config.getHomeDir() + this.lastDir.substring(1)), this.rest) : this.listDirectory(new File(Config.getHomeDir() + Config.getPathSeparator()), this.rest)) : (this.lastDir != null ? this.listDirectory(new File(this.cwd + Config.getPathSeparator() + this.lastDir), this.rest) : this.listDirectory(this.cwd, this.rest)));
        if (returnFiles.size() > 1) {
            String startsWith = Parser.findStartsWith(returnFiles);
            if (startsWith != null && startsWith.length() > 0 && startsWith.length() > this.rest.length()) {
                completion.addCompletionCandidate(Parser.switchSpacesToEscapedSpacesInWord(startsWith.substring(this.rest.length())));
            } else {
                completion.addCompletionCandidates(returnFiles);
            }
        } else if (returnFiles.size() == 1) {
            completion.addCompletionCandidate(returnFiles.get(0).substring(this.rest.length()));
        }
        if (completion.getCompletionCandidates().size() > 1 && this.rest != null && this.rest.length() > 0) {
            completion.setOffset(completion.getCursor() - this.rest.length());
        }
    }

    private void findRestAndLastDir() {
        if (this.incDir.contains(Config.getPathSeparator())) {
            this.lastDir = this.incDir.substring(0, this.incDir.lastIndexOf(Config.getPathSeparator()));
            this.rest = this.incDir.substring(this.incDir.lastIndexOf(Config.getPathSeparator()) + 1);
        } else if (new File(this.cwd + Config.getPathSeparator() + this.incDir).exists()) {
            this.lastDir = this.incDir;
        } else {
            this.rest = this.incDir;
        }
    }

    private boolean isIncDirADirectory() {
        return new File(this.incDir).isDirectory();
    }

    private boolean isIncDirAFile() {
        return new File(this.incDir).isFile();
    }

    private boolean isCwdAndIncDirADirectory() {
        return new File(this.cwd.getAbsolutePath() + Config.getPathSeparator() + this.incDir).isDirectory();
    }

    private boolean isCwdAndIncDirAFile() {
        return new File(this.cwd.getAbsolutePath() + Config.getPathSeparator() + this.incDir).isFile();
    }

    private boolean isHomeAndIncDirADirectory() {
        return new File(Config.getHomeDir() + this.incDir.substring(1)).isDirectory();
    }

    private boolean isHomeAndIncDirAFile() {
        return new File(Config.getHomeDir() + this.incDir.substring(1)).isFile();
    }

    private boolean startWithParent() {
        return startsWithParent.matcher(this.incDir).matches();
    }

    private boolean startWithHome() {
        return this.incDir.startsWith("~/");
    }

    private boolean startWithSlash() {
        return startsWithSlash.matcher(this.incDir).matches();
    }

    private boolean endWithSlash() {
        return endsWithSlash.matcher(this.incDir).matches();
    }

    private List<String> listDirectory(File path, String rest) {
        ArrayList<String> fileNames = new ArrayList<String>();
        if (path != null && path.isDirectory()) {
            for (File file : path.listFiles(this.fileFilter)) {
                if (rest == null || rest.length() == 0) {
                    fileNames.add(Parser.switchSpacesToEscapedSpacesInWord(file.getName()));
                    continue;
                }
                if (!file.getName().startsWith(rest)) continue;
                fileNames.add(Parser.switchSpacesToEscapedSpacesInWord(file.getName()));
            }
        }
        return fileNames;
    }

    public String toString() {
        return "FileLister{incDir='" + this.incDir + '\'' + ", cwd=" + this.cwd + ", rest='" + this.rest + '\'' + ", lastDir='" + this.lastDir + '\'' + '}';
    }

    public static enum Filter {
        FILE,
        DIRECTORY,
        ALL;

    }

    class OnlyFileFilter
    implements FileFilter {
        OnlyFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile();
        }
    }

    class FileAndDirectoryFilter
    implements FileFilter {
        FileAndDirectoryFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.isFile();
        }
    }

    class DirectoryFileFilter
    implements FileFilter {
        DirectoryFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

