/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.otp.hotp;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.otp.Authenticator;
import io.vertx.ext.auth.otp.DummyDatabase;
import io.vertx.ext.auth.otp.hotp.HotpAuth;
import io.vertx.ext.auth.otp.hotp.HotpAuthOptions;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class HotpAuthTest {
    private static final String USER1_KEY = "SRF6EYYCC6SNJEQD4VDZDZPGMODFPCSL";
    private static final String USER2_KEY = "OK7JVNHJO5ZMC57QLYJ6QNTOZFKVN76Y";
    @Rule
    public RunTestOnContext rule = new RunTestOnContext();

    @Test
    public void testHotp1(TestContext should) {
        DummyDatabase db = new DummyDatabase().fixture(new Authenticator().setIdentifier("user1").setKey(USER1_KEY).setCounter(0L));
        HotpAuthOptions hotpAuthOptions = new HotpAuthOptions();
        HotpAuth authProvider = HotpAuth.create((HotpAuthOptions)hotpAuthOptions).authenticatorFetcher(db::fetch).authenticatorUpdater(db::upsert);
        JsonObject credentials = new JsonObject().put("identifier", (Object)"user1").put("code", (Object)"698956");
        authProvider.authenticate(credentials, should.asyncAssertSuccess(user1 -> {
            long counter = (Long)user1.get("counter");
            should.assertEquals((Object)1L, (Object)counter);
            Integer authAttempt = (Integer)user1.get("auth_attempt");
            should.assertNull((Object)authAttempt);
        }));
    }

    @Test
    public void testHotp2(TestContext should) {
        DummyDatabase db = new DummyDatabase().fixture(new Authenticator().setIdentifier("user1").setKey(USER1_KEY).setCounter(0L));
        HotpAuthOptions hotpAuthOptions = new HotpAuthOptions();
        HotpAuth authProvider = HotpAuth.create((HotpAuthOptions)hotpAuthOptions).authenticatorFetcher(db::fetch).authenticatorUpdater(db::upsert);
        JsonObject credentials = new JsonObject().put("identifier", (Object)"user1").put("code", (Object)"718330");
        authProvider.authenticate(credentials, should.asyncAssertFailure());
        credentials = new JsonObject().put("identifier", (Object)"user1").put("code", (Object)"698956");
        authProvider.authenticate(credentials, should.asyncAssertSuccess(user1 -> {
            long counter = (Long)user1.get("counter");
            should.assertEquals((Object)1L, (Object)counter);
            int authAttempt = (Integer)user1.get("auth_attempts");
            should.assertEquals((Object)2, (Object)authAttempt);
        }));
    }

    @Test
    public void testHotp3(TestContext should) {
        DummyDatabase db = new DummyDatabase().fixture(new Authenticator().setIdentifier("user1").setKey(USER1_KEY).setCounter(5L));
        HotpAuthOptions hotpAuthOptions = new HotpAuthOptions();
        HotpAuth authProvider = HotpAuth.create((HotpAuthOptions)hotpAuthOptions).authenticatorFetcher(db::fetch).authenticatorUpdater(db::upsert);
        JsonObject credentials = new JsonObject().put("identifier", (Object)"user1").put("code", (Object)"296103");
        authProvider.authenticate(credentials, should.asyncAssertFailure());
        credentials = new JsonObject().put("identifier", (Object)"user1").put("code", (Object)"571931");
        authProvider.authenticate(credentials, should.asyncAssertFailure());
        credentials = new JsonObject().put("identifier", (Object)"user1").put("code", (Object)"881695");
        authProvider.authenticate(credentials, should.asyncAssertFailure());
        credentials = new JsonObject().put("identifier", (Object)"user1").put("code", (Object)"142559");
        authProvider.authenticate(credentials, should.asyncAssertSuccess(user1 -> {
            long counter = (Long)user1.get("counter");
            should.assertEquals((Object)6L, (Object)counter);
            int authAttempt = (Integer)user1.get("auth_attempts");
            should.assertEquals((Object)4, (Object)authAttempt);
        }));
    }

    @Test
    public void testHotp4(TestContext should) {
        DummyDatabase db = new DummyDatabase();
        HotpAuthOptions hotpAuthOptions = new HotpAuthOptions();
        HotpAuth authProvider = HotpAuth.create((HotpAuthOptions)hotpAuthOptions).authenticatorFetcher(db::fetch).authenticatorUpdater(db::upsert);
        JsonObject credentials = new JsonObject().put("identifier", (Object)"user1").put("code", (Object)"651075");
        authProvider.authenticate(credentials, should.asyncAssertFailure());
    }

    @Test
    public void testHotp5(TestContext should) {
        DummyDatabase db = new DummyDatabase().fixture(new Authenticator().setIdentifier("user1").setKey(USER1_KEY).setCounter(0L));
        HotpAuthOptions hotpAuthOptions = new HotpAuthOptions();
        HotpAuth authProvider = HotpAuth.create((HotpAuthOptions)hotpAuthOptions).authenticatorFetcher(db::fetch).authenticatorUpdater(db::upsert);
        JsonObject credentials = new JsonObject().put("identifier", (Object)"user1").put("code", (Object)"698956");
        authProvider.authenticate(credentials, should.asyncAssertSuccess(user1 -> {
            long counter = (Long)user1.get("counter");
            should.assertEquals((Object)1L, (Object)counter);
            Integer authAttempt = (Integer)user1.get("auth_attempt");
            should.assertNull((Object)authAttempt);
        }));
        authProvider.authenticate(credentials, should.asyncAssertFailure());
    }

    @Test
    public void testHotp6(TestContext should) {
        DummyDatabase db = new DummyDatabase().fixture(new Authenticator().setIdentifier("user1").setKey(USER1_KEY).setCounter(0L));
        HotpAuthOptions hotpAuthOptions = new HotpAuthOptions();
        HotpAuth authProvider = HotpAuth.create((HotpAuthOptions)hotpAuthOptions).authenticatorFetcher(db::fetch).authenticatorUpdater(db::upsert);
        JsonObject credentials = new JsonObject().put("identifier", (Object)"user1").put("code", (Object)"651075");
        authProvider.authenticate(credentials, should.asyncAssertFailure());
    }

    @Test
    public void testHotp7(TestContext should) {
        DummyDatabase db = new DummyDatabase().fixture(new Authenticator().setIdentifier("user1").setKey(USER1_KEY).setCounter(7L)).fixture(new Authenticator().setIdentifier("user2").setKey(USER2_KEY).setCounter(3L));
        HotpAuthOptions hotpAuthOptions = new HotpAuthOptions();
        HotpAuth authProvider = HotpAuth.create((HotpAuthOptions)hotpAuthOptions).authenticatorFetcher(db::fetch).authenticatorUpdater(db::upsert);
        JsonObject user1Credentials = new JsonObject().put("identifier", (Object)"user1").put("code", (Object)"974712");
        authProvider.authenticate(user1Credentials, should.asyncAssertSuccess(user -> {
            long counter = (Long)user.get("counter");
            should.assertEquals((Object)8L, (Object)counter);
            Integer authAttempt = (Integer)user.get("auth_attempt");
            should.assertNull((Object)authAttempt);
        }));
        JsonObject user2Credentials = new JsonObject().put("identifier", (Object)"user2").put("code", (Object)"054804");
        authProvider.authenticate(user2Credentials, should.asyncAssertSuccess(user -> {
            long counter = (Long)user.get("counter");
            should.assertEquals((Object)4L, (Object)counter);
            Integer authAttempt = (Integer)user.get("auth_attempt");
            should.assertNull((Object)authAttempt);
        }));
    }

    @Test
    public void testHotp8(TestContext should) {
        DummyDatabase db = new DummyDatabase().fixture(new Authenticator().setIdentifier("user1").setKey(USER1_KEY).setCounter(7L)).fixture(new Authenticator().setIdentifier("user2").setKey(USER2_KEY).setCounter(3L));
        HotpAuthOptions hotpAuthOptions = new HotpAuthOptions();
        HotpAuth authProvider = HotpAuth.create((HotpAuthOptions)hotpAuthOptions).authenticatorFetcher(db::fetch).authenticatorUpdater(db::upsert);
        JsonObject user1Credentials = new JsonObject().put("identifier", (Object)"user1").put("code", (Object)"974712");
        authProvider.authenticate(user1Credentials, should.asyncAssertSuccess(user -> {
            long counter = (Long)user.get("counter");
            should.assertEquals((Object)8L, (Object)counter);
            Integer authAttempt = (Integer)user.get("auth_attempt");
            should.assertNull((Object)authAttempt);
        }));
        JsonObject user2Credentials = new JsonObject().put("identifier", (Object)"user2").put("code", (Object)"302344");
        authProvider.authenticate(user2Credentials, should.asyncAssertFailure());
    }

    @Test
    public void testHotp9(TestContext should) {
        DummyDatabase db = new DummyDatabase().fixture(new Authenticator().setIdentifier("user1").setKey(USER1_KEY).setCounter(0L));
        HotpAuthOptions hotpAuthOptions = new HotpAuthOptions().setPasswordLength(8);
        HotpAuth authProvider = HotpAuth.create((HotpAuthOptions)hotpAuthOptions).authenticatorFetcher(db::fetch).authenticatorUpdater(db::upsert);
        JsonObject credentials = new JsonObject().put("identifier", (Object)"user1").put("code", (Object)"698956");
        authProvider.authenticate(credentials, should.asyncAssertFailure());
    }

    @Test
    public void testHotp10(TestContext should) {
        DummyDatabase db = new DummyDatabase().fixture(new Authenticator().setIdentifier("user1").setKey(USER1_KEY).setCounter(0L));
        HotpAuthOptions hotpAuthOptions = new HotpAuthOptions().setPasswordLength(6);
        HotpAuth authProvider = HotpAuth.create((HotpAuthOptions)hotpAuthOptions).authenticatorFetcher(db::fetch).authenticatorUpdater(db::upsert);
        JsonObject credentials = new JsonObject().put("identifier", (Object)"user1").put("code", (Object)"29403113451");
        authProvider.authenticate(credentials, should.asyncAssertFailure());
    }

    @Test
    public void testHotp12(TestContext should) {
        DummyDatabase db = new DummyDatabase().fixture(new Authenticator().setIdentifier("user1").setKey(USER1_KEY).setCounter(0L));
        int attemptsLimit = 3;
        HotpAuthOptions hotpAuthOptions = new HotpAuthOptions().setAuthAttemptsLimit(3);
        HotpAuth authProvider = HotpAuth.create((HotpAuthOptions)hotpAuthOptions).authenticatorFetcher(db::fetch).authenticatorUpdater(db::upsert);
        JsonObject credentials = new JsonObject().put("identifier", (Object)"user1").put("code", (Object)"738419");
        int i = 0;
        while (i < 10) {
            int finalI = i++;
            authProvider.authenticate(credentials, res -> {
                if (res.succeeded()) {
                    should.fail();
                } else if (finalI >= 3) {
                    should.assertNotNull((Object)res.cause());
                }
            });
        }
    }

    @Test
    public void testHotp13(TestContext should) {
        DummyDatabase db = new DummyDatabase().fixture(new Authenticator().setIdentifier("user1").setKey(USER1_KEY).setCounter(8L));
        HotpAuthOptions hotpAuthOptions = new HotpAuthOptions().setLookAheadWindow(5);
        HotpAuth authProvider = HotpAuth.create((HotpAuthOptions)hotpAuthOptions).authenticatorFetcher(db::fetch).authenticatorUpdater(db::upsert);
        JsonObject credentials = new JsonObject().put("identifier", (Object)"user1").put("code", (Object)"203646");
        authProvider.authenticate(credentials, should.asyncAssertSuccess(res -> {
            long counter = (Long)res.get("counter");
            should.assertEquals((Object)11L, (Object)counter);
            Integer authAttempt = (Integer)res.get("auth_attempt");
            should.assertNull((Object)authAttempt);
        }));
    }
}

