/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.otp.hotp;

import io.vertx.ext.auth.otp.hotp.HotpAuthOptions;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class HotpAuthOptionsTest {
    @Rule
    public RunTestOnContext rule = new RunTestOnContext();

    @Test
    public void test1(TestContext should) {
        HotpAuthOptions hotpAuthOptions2;
        try {
            new HotpAuthOptions().setPasswordLength(0);
            should.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new HotpAuthOptions().setPasswordLength(5);
            should.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new HotpAuthOptions().setPasswordLength(6);
        }
        catch (IllegalArgumentException e) {
            should.fail();
        }
        try {
            new HotpAuthOptions().setPasswordLength(7);
        }
        catch (IllegalArgumentException e) {
            should.fail();
        }
        try {
            new HotpAuthOptions().setPasswordLength(8);
        }
        catch (IllegalArgumentException e) {
            should.fail();
        }
        try {
            new HotpAuthOptions().setPasswordLength(9);
            should.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new HotpAuthOptions().setPasswordLength(10);
            should.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new HotpAuthOptions().setPasswordLength(Integer.MAX_VALUE);
            should.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new HotpAuthOptions().setPasswordLength(Integer.MIN_VALUE);
            should.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new HotpAuthOptions().setLookAheadWindow(-1);
            should.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new HotpAuthOptions().setLookAheadWindow(Integer.MIN_VALUE);
            should.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            hotpAuthOptions2 = new HotpAuthOptions().setLookAheadWindow(5);
            should.assertTrue(hotpAuthOptions2.isUsingResynchronization());
        }
        catch (IllegalArgumentException hotpAuthOptions2) {
            // empty catch block
        }
        try {
            hotpAuthOptions2 = new HotpAuthOptions().setLookAheadWindow(0);
            should.assertFalse(hotpAuthOptions2.isUsingResynchronization());
        }
        catch (IllegalArgumentException hotpAuthOptions3) {
            // empty catch block
        }
        try {
            new HotpAuthOptions().setAuthAttemptsLimit(-1);
            should.fail();
        }
        catch (IllegalArgumentException hotpAuthOptions3) {
            // empty catch block
        }
        try {
            new HotpAuthOptions().setAuthAttemptsLimit(Integer.MIN_VALUE);
            should.fail();
        }
        catch (IllegalArgumentException hotpAuthOptions3) {
            // empty catch block
        }
        try {
            hotpAuthOptions2 = new HotpAuthOptions().setAuthAttemptsLimit(5);
            should.assertTrue(hotpAuthOptions2.isUsingAttemptsLimit());
        }
        catch (IllegalArgumentException hotpAuthOptions4) {
            // empty catch block
        }
        try {
            hotpAuthOptions2 = new HotpAuthOptions().setAuthAttemptsLimit(0);
            should.assertFalse(hotpAuthOptions2.isUsingAttemptsLimit());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

