/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.test.shiro;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.core.schema.SchemaPartition;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.ldif.extractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.shared.ldap.schema.loader.ldif.LdifSchemaLoader;
import org.apache.directory.shared.ldap.schema.manager.impl.DefaultSchemaManager;
import org.apache.directory.shared.ldap.schema.registries.SchemaLoader;

public class EmbeddedADS {
    private DirectoryService service;
    private LdapServer server;

    private Partition addPartition(String partitionId, String partitionDn) throws Exception {
        JdbmPartition partition = new JdbmPartition();
        partition.setId(partitionId);
        partition.setPartitionDir(new File(this.service.getWorkingDirectory(), partitionId));
        partition.setSuffix(partitionDn);
        this.service.addPartition((Partition)partition);
        return partition;
    }

    private void addIndex(Partition partition, String ... attrs) {
        HashSet<JdbmIndex> indexedAttributes = new HashSet<JdbmIndex>();
        for (String attribute : attrs) {
            indexedAttributes.add(new JdbmIndex(attribute));
        }
        ((JdbmPartition)partition).setIndexedAttributes(indexedAttributes);
    }

    private void initSchemaPartition() throws Exception {
        SchemaPartition schemaPartition = this.service.getSchemaService().getSchemaPartition();
        LdifPartition ldifPartition = new LdifPartition();
        String workingDirectory = this.service.getWorkingDirectory().getPath();
        ldifPartition.setWorkingDirectory(workingDirectory + "/schema");
        File schemaRepository = new File(workingDirectory, "schema");
        DefaultSchemaLdifExtractor extractor = new DefaultSchemaLdifExtractor(new File(workingDirectory));
        extractor.extractOrCopy(true);
        schemaPartition.setWrappedPartition((Partition)ldifPartition);
        LdifSchemaLoader loader = new LdifSchemaLoader(schemaRepository);
        DefaultSchemaManager schemaManager = new DefaultSchemaManager((SchemaLoader)loader);
        this.service.setSchemaManager((SchemaManager)schemaManager);
        schemaManager.loadAllEnabled();
        schemaPartition.setSchemaManager((SchemaManager)schemaManager);
        List errors = schemaManager.getErrors();
        if (errors.size() != 0) {
            throw new Exception("Schema load failed : " + errors);
        }
    }

    private void initDirectoryService(File workDir) throws Exception {
        this.service = new DefaultDirectoryService();
        this.service.setWorkingDirectory(workDir);
        this.initSchemaPartition();
        Partition systemPartition = this.addPartition("system", "ou=system");
        this.service.setSystemPartition(systemPartition);
        this.service.getChangeLog().setEnabled(false);
        this.service.setDenormalizeOpAttrsEnabled(true);
        Partition fooPartition = this.addPartition("foo", "dc=foo,dc=com");
        this.addIndex(fooPartition, "objectClass", "ou", "uid");
        this.service.startup();
        DN dnFoo = new DN("dc=foo,dc=com");
        ServerEntry entryFoo = this.service.newEntry(dnFoo);
        entryFoo.add("objectClass", new String[]{"top", "domain", "extensibleObject"});
        entryFoo.add("dc", new String[]{"foo"});
        this.service.getAdminSession().add(entryFoo);
        DN usersDN = new DN("ou=users,dc=foo,dc=com");
        ServerEntry usersEntry = this.service.newEntry(usersDN);
        usersEntry.add("objectClass", new String[]{"organizationalUnit", "top"});
        usersEntry.add("ou", new String[]{"users"});
        this.service.getAdminSession().add(usersEntry);
    }

    public EmbeddedADS(File workDir) throws Exception {
        this.initDirectoryService(workDir);
    }

    public void startServer() throws Exception {
        this.server = new LdapServer();
        int serverPort = 10389;
        this.server.setTransports(new Transport[]{new TcpTransport(serverPort)});
        this.server.setDirectoryService(this.service);
        this.server.start();
    }

    public void stopServer() {
        this.server.stop();
    }

    public static void main(String[] args) {
        try {
            File workDir = new File(System.getProperty("java.io.tmpdir") + "/server-work/" + UUID.randomUUID().toString());
            workDir.mkdirs();
            EmbeddedADS ads = new EmbeddedADS(workDir);
            ClonedServerEntry result = ads.service.getAdminSession().lookup(new DN("ou=users,dc=foo,dc=com"));
            System.out.println("Found entry : " + result);
            ads.startServer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

