/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.test.shiro;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.shiro.ShiroAuth;
import io.vertx.test.core.VertxTestBase;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.junit.Test;

public class CreateShiroAuthProviderTest
extends VertxTestBase {
    @Test
    public void testCreateWithRealm() {
        MyShiroRealm realm = new MyShiroRealm();
        ShiroAuth authProvider = ShiroAuth.create((Vertx)this.vertx, (Realm)realm);
        JsonObject authInfo = new JsonObject().put("username", (Object)"tim").put("password", (Object)"sausages");
        authProvider.authenticate(authInfo, this.onSuccess(user -> {
            this.assertNotNull(user);
            this.testComplete();
        }));
        this.await();
    }

    class MyShiroRealm
    implements Realm {
        MyShiroRealm() {
        }

        public String getName() {
            return this.getClass().getName();
        }

        public boolean supports(AuthenticationToken token) {
            return true;
        }

        public AuthenticationInfo getAuthenticationInfo(final AuthenticationToken token) throws AuthenticationException {
            return new AuthenticationInfo(){

                public PrincipalCollection getPrincipals() {
                    return new SimplePrincipalCollection(token.getPrincipal(), this.getClass().getName());
                }

                public Object getCredentials() {
                    return token.getCredentials();
                }
            };
        }
    }
}

