/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.test.shiro;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.shiro.ShiroAuth;
import io.vertx.ext.auth.shiro.ShiroAuthOptions;
import io.vertx.ext.auth.shiro.ShiroAuthRealmType;
import io.vertx.ext.auth.test.shiro.EmbeddedADS;
import io.vertx.ext.auth.test.shiro.ShiroAuthProviderTestBase;
import java.util.ArrayList;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

@Ignore
public class LDAPShiroAuthProviderTest
extends ShiroAuthProviderTestBase {
    @Rule
    public TemporaryFolder ldapWorkingDirectory = new TemporaryFolder();
    protected EmbeddedADS ldapServer;

    public void setUp() throws Exception {
        super.setUp();
        this.ldapServer = new EmbeddedADS(this.ldapWorkingDirectory.newFolder());
        this.ldapServer.startServer();
        this.insertTestUsers();
        this.authProvider = ShiroAuth.create((Vertx)this.vertx, (ShiroAuthOptions)new ShiroAuthOptions().setType(ShiroAuthRealmType.LDAP).setConfig(this.getConfig()));
    }

    protected JsonObject getConfig() {
        JsonObject config = new JsonObject();
        config.put("ldap_url", (Object)"ldap://localhost:10389");
        config.put("ldap_user_dn_template", (Object)"uid={0},ou=users,dc=foo,dc=com");
        return config;
    }

    private void insertTestUsers() throws LDAPException {
        try (LDAPConnection connection = null;){
            connection = new LDAPConnection("localhost", 10389);
            ArrayList<Attribute> addRequest = new ArrayList<Attribute>();
            addRequest.add(new Attribute("objectClass", "top"));
            addRequest.add(new Attribute("objectClass", "person"));
            addRequest.add(new Attribute("objectClass", "organizationalPerson"));
            addRequest.add(new Attribute("objectClass", "inetOrgPerson"));
            addRequest.add(new Attribute("cn", "Tim Fox"));
            addRequest.add(new Attribute("sn", "Fox"));
            addRequest.add(new Attribute("mail", "tim@example.com"));
            addRequest.add(new Attribute("uid", "tim"));
            addRequest.add(new Attribute("userPassword", "{ssha}d0M5Z2qjOOCSCQInvZHgVAleCqU5I+ag9ZHXMw=="));
            connection.add("uid=tim,ou=users,dc=foo,dc=com", addRequest);
        }
    }

    protected void tearDown() throws Exception {
        this.ldapServer.stopServer();
        super.tearDown();
    }
}

