/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.test.shiro;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.test.core.VertxTestBase;
import java.util.function.Consumer;
import org.junit.Test;

public abstract class ShiroAuthProviderTestBase
extends VertxTestBase {
    protected AuthProvider authProvider;

    @Test
    public void testSimpleAuthenticate() throws Exception {
        JsonObject authInfo = new JsonObject().put("username", (Object)"tim").put("password", (Object)"sausages");
        this.authProvider.authenticate(authInfo, this.onSuccess(user -> {
            this.assertNotNull(user);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSimpleAuthenticateFailWrongPassword() throws Exception {
        JsonObject authInfo = new JsonObject().put("username", (Object)"tim").put("password", (Object)"wrongpassword");
        this.authProvider.authenticate(authInfo, this.onFailure(thr -> {
            this.assertNotNull(thr);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSimpleAuthenticateFailWrongUser() throws Exception {
        JsonObject authInfo = new JsonObject().put("username", (Object)"frank").put("password", (Object)"sausages");
        this.authProvider.authenticate(authInfo, this.onFailure(thr -> {
            this.assertNotNull(thr);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testHasRole() throws Exception {
        this.loginThen(user -> this.executeTwice(handler -> user.isAuthorized("role:morris_dancer", handler), res -> {
            this.assertTrue(res.succeeded());
            this.assertTrue((Boolean)res.result());
        }));
        this.await();
    }

    @Test
    public void testNotHasRole() throws Exception {
        this.loginThen(user -> this.executeTwice(handler -> user.isAuthorized("role:manager", handler), res -> {
            this.assertTrue(res.succeeded());
            this.assertFalse((Boolean)res.result());
        }));
        this.await();
    }

    @Test
    public void testHasPermission() throws Exception {
        this.loginThen(user -> this.executeTwice(handler -> user.isAuthorized("do_actual_work", handler), res -> {
            this.assertTrue(res.succeeded());
            this.assertTrue((Boolean)res.result());
        }));
        this.await();
    }

    @Test
    public void testNotHasPermission() throws Exception {
        this.loginThen(user -> this.executeTwice(handler -> user.isAuthorized("play_golf", handler), res -> {
            this.assertTrue(res.succeeded());
            this.assertFalse((Boolean)res.result());
        }));
        this.await();
    }

    private void loginThen(Consumer<User> runner) throws Exception {
        JsonObject authInfo = new JsonObject().put("username", (Object)"tim").put("password", (Object)"sausages");
        this.authProvider.authenticate(authInfo, this.onSuccess(user -> {
            this.assertNotNull(user);
            runner.accept((User)user);
        }));
    }

    private <T> void executeTwice(Consumer<Handler<AsyncResult<T>>> action, Consumer<AsyncResult<T>> resultConsumer) {
        action.accept(res -> {
            resultConsumer.accept((AsyncResult)res);
            action.accept(res2 -> {
                resultConsumer.accept((AsyncResult)res);
                this.testComplete();
            });
        });
    }
}

