/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.test.shiro;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.shiro.ShiroAuth;
import io.vertx.ext.auth.shiro.ShiroAuthOptions;
import io.vertx.ext.auth.shiro.ShiroAuthRealmType;
import io.vertx.ext.auth.test.shiro.ShiroAuthProviderTestBase;
import java.io.File;
import org.junit.Test;

public class PropertiesShiroAuthProviderTest
extends ShiroAuthProviderTestBase {
    public void setUp() throws Exception {
        super.setUp();
        this.authProvider = ShiroAuth.create((Vertx)this.vertx, (ShiroAuthOptions)new ShiroAuthOptions().setType(ShiroAuthRealmType.PROPERTIES).setConfig(this.getConfig()));
    }

    protected JsonObject getConfig() {
        JsonObject config = new JsonObject();
        config.put("properties_path", (Object)"classpath:test-auth.properties");
        return config;
    }

    @Test
    public void testHasWildcardPermission() throws Exception {
        JsonObject authInfo = new JsonObject().put("username", (Object)"paulo").put("password", (Object)"secret");
        this.authProvider.authenticate(authInfo, this.onSuccess(user -> {
            this.assertNotNull(user);
            user.isAuthorized("do_actual_work", this.onSuccess(res -> {
                this.assertTrue((boolean)res);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testHasWildcardMatchPermission() throws Exception {
        JsonObject authInfo = new JsonObject().put("username", (Object)"editor").put("password", (Object)"secret");
        this.authProvider.authenticate(authInfo, this.onSuccess(user -> {
            this.assertNotNull(user);
            user.isAuthorized("newsletter:edit:13", this.onSuccess(res -> {
                this.assertTrue((boolean)res);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testResolve() throws Exception {
        ClassLoader loader = PropertiesShiroAuthProviderTest.class.getClassLoader();
        File res = new File(loader.getResource("test-auth.properties").toURI());
        try {
            ShiroAuth.create((Vertx)this.vertx, (ShiroAuthOptions)new ShiroAuthOptions().setType(ShiroAuthRealmType.PROPERTIES).setConfig(new JsonObject().put("properties_path", (Object)res.getName())));
            this.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertResolve(res.getParentFile(), res.getName());
        this.assertResolve(res.getParentFile(), "file:" + res.getName());
        this.assertResolve(res.getParentFile().getParentFile(), "file:" + res.getParentFile().getName() + File.separatorChar + res.getName());
        this.assertResolve(res.getParentFile().getParentFile(), "classpath:" + res.getName());
        this.assertResolve(res.getParentFile().getParentFile(), "url:" + res.toURI().toURL());
    }

    private void assertResolve(File cwd, String path) {
        try {
            System.setProperty("vertx.cwd", cwd.getAbsolutePath());
            ShiroAuth.create((Vertx)this.vertx, (ShiroAuthOptions)new ShiroAuthOptions().setType(ShiroAuthRealmType.PROPERTIES).setConfig(new JsonObject().put("properties_path", (Object)path)));
        }
        finally {
            System.clearProperty("vertx.cwd");
        }
    }
}

