/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.bridge;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.bridge.BridgeOptions;
import io.vertx.ext.bridge.PermittedOptions;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class BridgeOptionsTest {
    @Test
    public void testInstantiation() {
        BridgeOptions options = new BridgeOptions();
        Assertions.assertThat((List)options.getInboundPermitteds()).isEmpty();
        Assertions.assertThat((List)options.getOutboundPermitteds()).isEmpty();
    }

    @Test
    public void testInstantiationByCopy() {
        BridgeOptions options = new BridgeOptions();
        options.addInboundPermitted(new PermittedOptions().setAddress("foo")).addInboundPermitted(new PermittedOptions().setAddress("bar")).addOutboundPermitted(new PermittedOptions().setAddress("foo"));
        Assertions.assertThat((List)options.getInboundPermitteds()).hasSize(2);
        Assertions.assertThat((List)options.getOutboundPermitteds()).hasSize(1);
        BridgeOptions options2 = new BridgeOptions(options);
        Assertions.assertThat((Object)options).isNotSameAs((Object)options2);
        Assertions.assertThat((List)options2.getInboundPermitteds()).hasSize(2);
        Assertions.assertThat((List)options2.getOutboundPermitteds()).hasSize(1);
    }

    @Test
    public void testSetInboundAndOutboundPermitted() {
        BridgeOptions options = new BridgeOptions();
        ArrayList<PermittedOptions> inbound = new ArrayList<PermittedOptions>();
        ArrayList<PermittedOptions> outbound = new ArrayList<PermittedOptions>();
        inbound.add(new PermittedOptions().setAddress("foo"));
        inbound.add(new PermittedOptions().setAddress("bar"));
        outbound.add(new PermittedOptions().setAddress("foo"));
        options.setInboundPermitteds(inbound).setOutboundPermitteds(outbound);
        Assertions.assertThat((List)options.getInboundPermitteds()).hasSize(2);
        Assertions.assertThat((List)options.getOutboundPermitteds()).hasSize(1);
    }

    @Test
    public void testSerializationOfEmptyOptions() {
        BridgeOptions options = new BridgeOptions();
        JsonObject json = options.toJson();
        Assertions.assertThat((Iterable)json.getJsonArray("inboundPermitteds")).isEmpty();
        Assertions.assertThat((Iterable)json.getJsonArray("outboundPermitteds")).isEmpty();
        BridgeOptions options2 = new BridgeOptions(json);
        Assertions.assertThat((List)options2.getInboundPermitteds()).isEmpty();
        Assertions.assertThat((List)options2.getOutboundPermitteds()).isEmpty();
    }

    @Test
    public void testSerialization() {
        BridgeOptions options = new BridgeOptions();
        ArrayList<PermittedOptions> inbound = new ArrayList<PermittedOptions>();
        ArrayList<PermittedOptions> outbound = new ArrayList<PermittedOptions>();
        inbound.add(new PermittedOptions().setAddress("foo"));
        inbound.add(new PermittedOptions().setAddress("bar"));
        outbound.add(new PermittedOptions().setAddress("foo"));
        options.setInboundPermitteds(inbound).setOutboundPermitteds(outbound);
        JsonObject json = options.toJson();
        Assertions.assertThat((Iterable)json.getJsonArray("inboundPermitteds")).hasSize(2);
        Assertions.assertThat((Iterable)json.getJsonArray("outboundPermitteds")).hasSize(1);
        BridgeOptions options2 = new BridgeOptions(json);
        Assertions.assertThat((List)options2.getInboundPermitteds()).hasSize(2);
        Assertions.assertThat((List)options2.getOutboundPermitteds()).hasSize(1);
    }
}

