/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.bridge;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.bridge.PermittedOptions;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class PermittedOptionsTest {
    @Test
    public void testEmptyInstantiation() {
        PermittedOptions options = new PermittedOptions();
        Assertions.assertThat((String)options.getAddress()).isEqualTo((Object)PermittedOptions.DEFAULT_ADDRESS);
        Assertions.assertThat((String)options.getAddressRegex()).isEqualTo((Object)PermittedOptions.DEFAULT_ADDRESS_REGEX);
        Assertions.assertThat((Iterable)options.getMatch()).isEqualTo((Object)PermittedOptions.DEFAULT_MATCH);
    }

    @Test
    public void testCopyConstructor() {
        PermittedOptions options = new PermittedOptions();
        options.setAddress("foo").setAddressRegex(".ert\\..").setMatch(new JsonObject().put("foo", (Object)""));
        Assertions.assertThat((String)options.getAddress()).isEqualTo((Object)"foo");
        Assertions.assertThat((String)options.getAddressRegex()).isEqualTo((Object)".ert\\..");
        Assertions.assertThat((Iterable)options.getMatch()).isEqualTo((Object)new JsonObject().put("foo", (Object)""));
        PermittedOptions options2 = new PermittedOptions(options);
        Assertions.assertThat((Object)options).isNotSameAs((Object)options2);
        Assertions.assertThat((String)options2.getAddress()).isEqualTo((Object)"foo");
        Assertions.assertThat((String)options2.getAddressRegex()).isEqualTo((Object)".ert\\..");
        Assertions.assertThat((Iterable)options2.getMatch()).isEqualTo((Object)new JsonObject().put("foo", (Object)""));
    }

    @Test
    public void testSerializationOfEmptyPermittedOption() {
        PermittedOptions options = new PermittedOptions();
        JsonObject json = options.toJson();
        Assertions.assertThat((String)json.getString("address")).isNull();
        PermittedOptions options2 = new PermittedOptions(json);
        Assertions.assertThat((Object)options).isNotSameAs((Object)options2);
        Assertions.assertThat((String)options.getAddress()).isNull();
    }

    @Test
    public void testSerializationPermittedOption() {
        PermittedOptions options = new PermittedOptions();
        options.setAddress("foo").setAddressRegex(".ert\\..").setMatch(new JsonObject().put("foo", (Object)""));
        JsonObject json = options.toJson();
        Assertions.assertThat((String)json.getString("address")).isEqualTo((Object)"foo");
        PermittedOptions options2 = new PermittedOptions(json);
        Assertions.assertThat((String)options2.getAddress()).isEqualTo((Object)"foo");
        Assertions.assertThat((String)options2.getAddressRegex()).isEqualTo((Object)".ert\\..");
        Assertions.assertThat((Iterable)options2.getMatch()).isEqualTo((Object)new JsonObject().put("foo", (Object)""));
    }
}

