/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.cassandra.impl;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import io.vertx.cassandra.ResultSet;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;

public class ResultSetImpl
implements ResultSet {
    private final Vertx vertx;
    private final AtomicReference<AsyncResultSet> resultSetRef;

    public ResultSetImpl(AsyncResultSet resultSet, Vertx vertx) {
        this.resultSetRef = new AtomicReference<AsyncResultSet>(resultSet);
        this.vertx = vertx;
    }

    @Override
    public ResultSet all(Handler<AsyncResult<List<Row>>> handler) {
        this.loadMore(this.vertx.getOrCreateContext(), Collections.emptyList(), handler);
        return this;
    }

    @Override
    public Future<List<Row>> all() {
        Promise promise = Promise.promise();
        this.all((Handler<AsyncResult<List<Row>>>)promise);
        return promise.future();
    }

    @Override
    public ColumnDefinitions getColumnDefinitions() {
        return this.resultSetRef.get().getColumnDefinitions();
    }

    @Override
    public ExecutionInfo getExecutionInfo() {
        return this.resultSetRef.get().getExecutionInfo();
    }

    @Override
    public int remaining() {
        return this.resultSetRef.get().remaining();
    }

    @Override
    public Iterable<Row> currentPage() {
        return this.resultSetRef.get().currentPage();
    }

    @Override
    public Row one() {
        return (Row)this.resultSetRef.get().one();
    }

    @Override
    public boolean hasMorePages() {
        return this.resultSetRef.get().hasMorePages();
    }

    @Override
    public void fetchNextPage(Handler<AsyncResult<ResultSet>> handler) {
        Future<ResultSet> fut = this.fetchNextPage();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    @Override
    public Future<ResultSet> fetchNextPage() throws IllegalStateException {
        return Future.fromCompletionStage((CompletionStage)this.resultSetRef.get().fetchNextPage(), (Context)this.vertx.getOrCreateContext()).map(datastaxRS -> {
            this.resultSetRef.set((AsyncResultSet)datastaxRS);
            return this;
        });
    }

    @Override
    public boolean wasApplied() {
        return this.resultSetRef.get().wasApplied();
    }

    private void loadMore(Context context, List<Row> loaded, Handler<AsyncResult<List<Row>>> handler) {
        int availableWithoutFetching = this.resultSetRef.get().remaining();
        ArrayList<Object> rows = new ArrayList<Object>(loaded.size() + availableWithoutFetching);
        rows.addAll(loaded);
        for (int i = 0; i < availableWithoutFetching; ++i) {
            rows.add(this.resultSetRef.get().one());
        }
        if (this.resultSetRef.get().hasMorePages()) {
            Future.fromCompletionStage((CompletionStage)this.resultSetRef.get().fetchNextPage(), (Context)context).onComplete(ar -> {
                if (ar.succeeded()) {
                    this.resultSetRef.set((AsyncResultSet)ar.result());
                    this.loadMore(context, rows, handler);
                } else if (handler != null) {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            });
        } else if (handler != null) {
            handler.handle((Object)Future.succeededFuture(rows));
        }
    }
}

