/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.testmodel;

import io.vertx.codegen.testmodel.DataObjectTCK;
import io.vertx.codegen.testmodel.DataObjectWithListAdders;
import io.vertx.codegen.testmodel.DataObjectWithLists;
import io.vertx.codegen.testmodel.DataObjectWithMapAdders;
import io.vertx.codegen.testmodel.DataObjectWithMaps;
import io.vertx.codegen.testmodel.DataObjectWithNestedBuffer;
import io.vertx.codegen.testmodel.DataObjectWithOnlyJsonObjectConstructor;
import io.vertx.codegen.testmodel.DataObjectWithRecursion;
import io.vertx.codegen.testmodel.DataObjectWithValues;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.testmodel.TestEnum;
import io.vertx.codegen.testmodel.TestGenEnum;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.Instant;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.junit.Assert;

public class DataObjectTCKImpl
implements DataObjectTCK {
    @Override
    public DataObjectWithValues getDataObjectWithValues() {
        DataObjectWithValues dataObject = new DataObjectWithValues();
        dataObject.setBooleanValue(true);
        dataObject.setShortValue((short)520);
        dataObject.setIntValue(123456);
        dataObject.setLongValue(123456789L);
        dataObject.setFloatValue(1.1f);
        dataObject.setDoubleValue(1.11);
        dataObject.setBoxedShortValue((short)1040);
        dataObject.setBoxedBooleanValue(true);
        dataObject.setBoxedIntValue(654321);
        dataObject.setBoxedLongValue(987654321L);
        dataObject.setBoxedFloatValue(Float.valueOf(2.2f));
        dataObject.setBoxedDoubleValue(2.22);
        dataObject.setStringValue("wibble");
        dataObject.setInstantValue(Instant.parse("1984-05-27T00:05:00Z"));
        dataObject.setJsonObjectValue(new JsonObject().put("foo", (Object)"eek").put("bar", (Object)"wibble"));
        dataObject.setJsonArrayValue(new JsonArray().add((Object)"eek").add((Object)"wibble"));
        dataObject.setEnumValue(TestEnum.TIM);
        dataObject.setGenEnumValue(TestGenEnum.MIKE);
        dataObject.setDataObjectValue(new TestDataObject().setFoo("1").setBar(1).setWibble(1.1));
        return dataObject;
    }

    @Override
    public void setDataObjectWithValues(DataObjectWithValues dataObject) {
        Assert.assertEquals((Object)true, (Object)dataObject.booleanValue);
        Assert.assertEquals((long)520L, (long)dataObject.shortValue);
        Assert.assertEquals((long)123456L, (long)dataObject.intValue);
        Assert.assertEquals((long)123456789L, (long)dataObject.longValue);
        Assert.assertEquals((float)1.1f, (float)dataObject.floatValue, (float)0.01f);
        Assert.assertEquals((double)1.11f, (double)dataObject.doubleValue, (double)0.01f);
        Assert.assertEquals((Object)true, (Object)dataObject.boxedBooleanValue);
        Assert.assertEquals((long)1040L, (long)dataObject.boxedShortValue.shortValue());
        Assert.assertEquals((long)654321L, (long)dataObject.boxedIntValue.intValue());
        Assert.assertEquals((long)987654321L, (long)dataObject.boxedLongValue);
        Assert.assertEquals((float)2.2f, (float)dataObject.boxedFloatValue.floatValue(), (float)0.01f);
        Assert.assertEquals((double)2.22f, (double)dataObject.boxedDoubleValue, (double)0.01f);
        Assert.assertEquals((Object)"wibble", (Object)dataObject.stringValue);
        Assert.assertEquals((Object)Instant.parse("1984-05-27T00:05:00Z"), (Object)dataObject.instantValue);
        Assert.assertEquals((Object)new JsonObject().put("foo", (Object)"eek").put("bar", (Object)"wibble"), (Object)dataObject.jsonObjectValue);
        Assert.assertEquals((Object)new JsonArray().add((Object)"eek").add((Object)"wibble"), (Object)dataObject.jsonArrayValue);
        Assert.assertEquals((Object)((Object)TestEnum.TIM), (Object)((Object)dataObject.enumValue));
        Assert.assertEquals((Object)((Object)TestGenEnum.MIKE), (Object)((Object)dataObject.genEnumValue));
        Assert.assertEquals((Object)"1", (Object)dataObject.dataObjectValue.getFoo());
        Assert.assertEquals((long)1L, (long)dataObject.dataObjectValue.getBar());
        Assert.assertEquals((double)1.1f, (double)dataObject.dataObjectValue.getWibble(), (double)0.01f);
    }

    @Override
    public DataObjectWithLists getDataObjectWithLists() {
        DataObjectWithLists dataObject = new DataObjectWithLists();
        dataObject.setBooleanValues(Arrays.asList(true, false, true));
        dataObject.setShortValues(Arrays.asList((short)0, (short)520, (short)1040));
        dataObject.setIntegerValues(Arrays.asList(0, 123456, 654321));
        dataObject.setLongValues(Arrays.asList(0L, 123456789L, 987654321L));
        dataObject.setFloatValues(Arrays.asList(Float.valueOf(1.1f), Float.valueOf(2.2f), Float.valueOf(3.3f)));
        dataObject.setDoubleValues(Arrays.asList(1.11, 2.22, 3.33));
        dataObject.setStringValues(Arrays.asList("stringValues1", "stringValues2", "stringValues3"));
        dataObject.setInstantValues(Arrays.asList(Instant.parse("1984-05-27T00:05:00Z"), Instant.parse("2018-07-05T08:23:21Z")));
        dataObject.setJsonObjectValues(Arrays.asList(new JsonObject().put("foo", (Object)"eek"), new JsonObject().put("foo", (Object)"wibble")));
        dataObject.setJsonArrayValues(Arrays.asList(new JsonArray().add((Object)"foo"), new JsonArray().add((Object)"bar")));
        dataObject.setDataObjectValues(Arrays.asList(new TestDataObject().setFoo("1").setBar(1).setWibble(1.1), new TestDataObject().setFoo("2").setBar(2).setWibble(2.2)));
        dataObject.setEnumValues(Arrays.asList(TestEnum.TIM, TestEnum.JULIEN));
        dataObject.setGenEnumValues(Arrays.asList(TestGenEnum.BOB, TestGenEnum.LAURA));
        return dataObject;
    }

    @Override
    public void setDataObjectWithLists(DataObjectWithLists dataObject) {
        Assert.assertEquals(Arrays.asList(true, false, true), dataObject.booleanValues);
        Assert.assertEquals(Arrays.asList((short)0, (short)520, (short)1040), dataObject.shortValues);
        Assert.assertEquals(Arrays.asList(0, 123456, 654321), dataObject.integerValues);
        Assert.assertEquals(Arrays.asList(0L, 123456789L, 987654321L), dataObject.longValues);
        Assert.assertEquals(Arrays.asList(Float.valueOf(1.1f), Float.valueOf(2.2f), Float.valueOf(3.3f)), dataObject.floatValues);
        Assert.assertEquals(Arrays.asList(1.11, 2.22, 3.33), dataObject.doubleValues);
        Assert.assertEquals(Arrays.asList("stringValues1", "stringValues2", "stringValues3"), dataObject.stringValues);
        Assert.assertEquals(Arrays.asList(Instant.parse("1984-05-27T00:05:00Z"), Instant.parse("2018-07-05T08:23:21Z")), dataObject.instantValues);
        Assert.assertEquals(Arrays.asList(new JsonObject().put("foo", (Object)"eek"), new JsonObject().put("foo", (Object)"wibble")), dataObject.jsonObjectValues);
        Assert.assertEquals(Arrays.asList(new JsonArray().add((Object)"foo"), new JsonArray().add((Object)"bar")), dataObject.jsonArrayValues);
        Assert.assertEquals((long)2L, (long)dataObject.dataObjectValues.size());
        Assert.assertEquals((Object)"1", (Object)dataObject.dataObjectValues.get(0).getFoo());
        Assert.assertEquals((long)1L, (long)dataObject.dataObjectValues.get(0).getBar());
        Assert.assertEquals((double)1.1, (double)dataObject.dataObjectValues.get(0).getWibble(), (double)0.01);
        Assert.assertEquals((Object)"2", (Object)dataObject.dataObjectValues.get(1).getFoo());
        Assert.assertEquals((long)2L, (long)dataObject.dataObjectValues.get(1).getBar());
        Assert.assertEquals((double)2.2, (double)dataObject.dataObjectValues.get(1).getWibble(), (double)0.01);
        Assert.assertEquals(Arrays.asList(TestEnum.TIM, TestEnum.JULIEN), dataObject.enumValues);
        Assert.assertEquals(Arrays.asList(TestGenEnum.BOB, TestGenEnum.LAURA), dataObject.genEnumValues);
    }

    private <T> Map<String, T> map(T first, T second) {
        LinkedHashMap<String, T> map = new LinkedHashMap<String, T>();
        map.put("1", first);
        map.put("2", second);
        return map;
    }

    @Override
    public DataObjectWithMaps getDataObjectWithMaps() {
        DataObjectWithMaps dataObject = new DataObjectWithMaps();
        dataObject.setBooleanValues(this.map(true, false));
        dataObject.setShortValues(this.map((short)520, (short)1040));
        dataObject.setIntegerValues(this.map(123456, 654321));
        dataObject.setLongValues(this.map(123456789L, 987654321L));
        dataObject.setFloatValues(this.map(Float.valueOf(1.1f), Float.valueOf(2.2f)));
        dataObject.setDoubleValues(this.map(1.11, 2.22));
        dataObject.setStringValues(this.map("stringValues1", "stringValues2"));
        dataObject.setInstantValues(this.map(Instant.parse("1984-05-27T00:05:00Z"), Instant.parse("2018-07-05T08:23:21Z")));
        dataObject.setJsonObjectValues(this.map(new JsonObject().put("foo", (Object)"eek"), new JsonObject().put("foo", (Object)"wibble")));
        dataObject.setJsonArrayValues(this.map(new JsonArray().add((Object)"foo"), new JsonArray().add((Object)"bar")));
        dataObject.setDataObjectValues(this.map(new TestDataObject().setFoo("1").setBar(1).setWibble(1.1), new TestDataObject().setFoo("2").setBar(2).setWibble(2.2)));
        dataObject.setEnumValues(this.map(TestEnum.TIM, TestEnum.JULIEN));
        dataObject.setGenEnumValues(this.map(TestGenEnum.BOB, TestGenEnum.LAURA));
        return dataObject;
    }

    private <T> Map<String, T> assertMap(Map<String, T> map, T first, T second) {
        return this.assertMap(map, first, second, Assert::assertEquals);
    }

    private <T> Map<String, T> assertMap(Map<String, T> map, T first, T second, BiConsumer<T, T> assertEquals) {
        assertEquals.accept(first, map.get("1"));
        assertEquals.accept(second, map.get("2"));
        return map;
    }

    @Override
    public void setDataObjectWithMaps(DataObjectWithMaps dataObject) {
        this.assertMap(dataObject.booleanValues, true, false);
        this.assertMap(dataObject.shortValues, (short)520, (short)1040);
        this.assertMap(dataObject.integerValues, 123456, 654321);
        this.assertMap(dataObject.longValues, 123456789L, 987654321L);
        this.assertMap(dataObject.floatValues, Float.valueOf(1.1f), Float.valueOf(2.2f), (f1, f2) -> Assert.assertEquals((double)f1.floatValue(), (double)f2.floatValue(), (double)0.1));
        this.assertMap(dataObject.doubleValues, 1.11, 2.22, (f1, f2) -> Assert.assertEquals((double)f1, (double)f2, (double)0.1));
        this.assertMap(dataObject.stringValues, "stringValues1", "stringValues2");
        this.assertMap(dataObject.instantValues, Instant.parse("1984-05-27T00:05:00Z"), Instant.parse("2018-07-05T08:23:21Z"));
        this.assertMap(dataObject.jsonObjectValues, new JsonObject().put("foo", (Object)"eek"), new JsonObject().put("foo", (Object)"wibble"));
        this.assertMap(dataObject.jsonArrayValues, new JsonArray().add((Object)"foo"), new JsonArray().add((Object)"bar"));
        Assert.assertEquals((long)2L, (long)dataObject.dataObjectValues.size());
        Assert.assertEquals((Object)"1", (Object)dataObject.dataObjectValues.get("1").getFoo());
        Assert.assertEquals((long)1L, (long)dataObject.dataObjectValues.get("1").getBar());
        Assert.assertEquals((double)1.1, (double)dataObject.dataObjectValues.get("1").getWibble(), (double)0.01);
        Assert.assertEquals((Object)"2", (Object)dataObject.dataObjectValues.get("2").getFoo());
        Assert.assertEquals((long)2L, (long)dataObject.dataObjectValues.get("2").getBar());
        Assert.assertEquals((double)2.2, (double)dataObject.dataObjectValues.get("2").getWibble(), (double)0.01);
        this.assertMap(dataObject.enumValues, TestEnum.TIM, TestEnum.JULIEN);
        this.assertMap(dataObject.genEnumValues, TestGenEnum.BOB, TestGenEnum.LAURA);
    }

    @Override
    public void methodWithOnlyJsonObjectConstructorDataObject(DataObjectWithOnlyJsonObjectConstructor dataObject) {
        Assert.assertEquals((Object)dataObject.toJson(), (Object)new JsonObject().put("foo", (Object)"bar"));
    }

    @Override
    public void setDataObjectWithBuffer(DataObjectWithNestedBuffer dataObject) {
        Assert.assertEquals((Object)"Hello World", (Object)new String(dataObject.getBuffer().getBytes()));
        Assert.assertEquals((Object)"Bye World", (Object)new String(dataObject.getNested().getBuffer().getBytes()));
        Assert.assertEquals((Object)"one", (Object)new String(dataObject.getBuffers().get(0).getBytes()));
        Assert.assertEquals((Object)"two", (Object)new String(dataObject.getBuffers().get(1).getBytes()));
    }

    @Override
    public void setDataObjectWithListAdders(DataObjectWithListAdders dataObject) {
        this.setDataObjectWithLists(dataObject.value);
    }

    @Override
    public void setDataObjectWithMapAdders(DataObjectWithMapAdders dataObject) {
        this.setDataObjectWithMaps(dataObject.value);
    }

    @Override
    public void setDataObjectWithRecursion(DataObjectWithRecursion dataObject) {
        Assert.assertEquals((Object)"first", (Object)dataObject.getData());
        Assert.assertEquals((Object)"second", (Object)dataObject.getNext().getData());
        Assert.assertEquals((Object)"third", (Object)dataObject.getNext().getNext().getData());
        Assert.assertEquals(null, (Object)dataObject.getNext().getNext().getNext());
    }
}

