/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.testmodel;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.testmodel.DataObjectWithBuffer;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;

@DataObject
public class DataObjectWithNestedBuffer {
    private Buffer buffer;
    private DataObjectWithBuffer nested;
    private List<Buffer> buffers;

    public DataObjectWithNestedBuffer() {
    }

    public DataObjectWithNestedBuffer(JsonObject json) {
        byte[] buffer = json.getBinary("buffer");
        this.buffer = buffer != null ? Buffer.buffer((byte[])buffer) : null;
        JsonObject nested = json.getJsonObject("nested");
        this.nested = nested != null ? new DataObjectWithBuffer(nested) : null;
        JsonArray buffers_ = json.getJsonArray("buffers");
        if (buffers_ != null) {
            this.buffers = new ArrayList<Buffer>();
            for (int i = 0; i < buffers_.size(); ++i) {
                this.buffers.add(Buffer.buffer((byte[])buffers_.getBinary(i)));
            }
        }
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Buffer buffer) {
        this.buffer = buffer;
    }

    public List<Buffer> getBuffers() {
        return this.buffers;
    }

    public void setBuffers(List<Buffer> buffers) {
        this.buffers = buffers;
    }

    public DataObjectWithBuffer getNested() {
        return this.nested;
    }

    public void setNested(DataObjectWithBuffer nested) {
        this.nested = nested;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.buffer != null) {
            json.put("buffer", (Object)this.buffer.getBytes());
        }
        if (this.buffers != null) {
            JsonArray arr = new JsonArray();
            for (Buffer b : this.buffers) {
                arr.add((Object)b.getBytes());
            }
            json.put("buffers", (Object)arr);
        }
        if (this.nested != null) {
            json.put("nested", (Object)this.nested.toJson());
        }
        return json;
    }
}

